DECLARE SUB FontMapErzeugen ()
DECLARE SUB VPtoVFLauf ()
DECLARE SUB PLtoTFLauf ()

CLS

FontMapErzeugen
PLtoTFLauf
VPtoVFLauf

END

SUB FontMapErzeugen

' Mit Hilfe von afm2tfm die Fontnamen aller im Unterverzeichnis
' enthaltenen FontDateinamen ermitteln
' und in eine temporre Datei fonts.tmp schreiben:

IF DIR$("fonts.tmp") <> "" THEN
   KILL "fonts.tmp"
END IF

AFMDatei$ = DIR$("*.afm")           ' AFM-Dateien ermitteln
KB$ = LCASE$(LEFT$(AFMDatei$, 3))   ' Karl-Berry-Name (die ersten 3 Buchstaben)
DO                                  '
   AFMDatei$ = LCASE$(AFMDatei$)    ' Kleinschreibung sicherstellen
   Punkt = INSTR(AFMDatei$, ".")
   TFMDatei$ = LEFT$(AFMDatei$, Punkt) + "tfm"
   Befehl$ = "afm2tfm " + AFMDatei$ + " " + TFMDatei$ + " >>fonts.tmp"  ' afm2tfm in einer DOS-Shell ausfhren
   SHELL Befehl$                    ' Fontnamen ermitteln
   KILL TFMDatei$                   ' *.tfm-Datei lschen (Befehl evtl. berflssig)
   AFMDatei$ = DIR$                 ' nchste *.afm-Datei im Unterverzeichnis
LOOP WHILE AFMDatei$ <> ""

' ***************************************************************

OPEN "fonts.tmp" FOR INPUT AS #1
OPEN "fonts.map" FOR OUTPUT AS #2

DO
   LINE INPUT #1, Zeile$
   Lz = INSTR(Zeile$, " ")    ' Trennstelle zwischen Datei- und Fontname
   Dateiname$ = LEFT$(Zeile$, Lz - 1)
   Fontname$ = RIGHT$(Zeile$, LEN(Zeile$) - Lz)

   ' Informationen fr Non-Slanted Fonts schreiben:
   SELECT CASE LCASE$(RIGHT$(Dateiname$, 2))
      CASE "8a"   ' Non-Condensed Font
         AchtrEncDateiname$ = LEFT$(Dateiname$, LEN(Dateiname$) - 2) + "8r"
      CASE "an"   ' Condensed Font
         AchtrEncDateiname$ = LEFT$(Dateiname$, LEN(Dateiname$) - 2) + "rn"
   END SELECT
   PRINT #2, AchtrEncDateiname$ + " " + Fontname$ + " "; CHR$(34) + "TeXBase1Encoding ReEncodeFont" + CHR$(34) + " <[8r.enc <" + Dateiname$ + ".pfb"

   ' Informationen fr Slanted Fonts schreiben:
   SELECT CASE LCASE$(AchtrEncDateiname$)  ' Slanted Fonts fr Non-Condensed
      CASE KB$ + "a8r", KB$ + "i8r", KB$ + "l8r", KB$ + "k8r", KB$ + "r8r", KB$ + "m8r", KB$ + "d8r", KB$ + "s8r", KB$ + "b8r", KB$ + "c8r", KB$ + "h8r", KB$ + "x8r", KB$ + "u8r"
      AchtrEncSlDateiname$ = LEFT$(AchtrEncDateiname$, LEN(AchtrEncDateiname$) - 2) + "o8r"
      PRINT #2, AchtrEncSlDateiname$ + " " + Fontname$ + " "; CHR$(34) + ".167 SlantFont TeXBase1Encoding ReEncodeFont" + CHR$(34) + " <[8r.enc <" + Dateiname$ + ".pfb"
   END SELECT
   SELECT CASE LCASE$(AchtrEncDateiname$)  ' Slanted Fonts fr Condensed
      CASE KB$ + "a8rn", KB$ + "i8rn", KB$ + "l8rn", KB$ + "k8rn", KB$ + "r8rn", KB$ + "m8rn", KB$ + "d8rn", KB$ + "s8rn", KB$ + "b8rn", KB$ + "c8rn", KB$ + "h8rn", KB$ + "x8rn", KB$ + "u8rn"
      AchtrEncSlDateiname$ = LEFT$(AchtrEncDateiname$, LEN(AchtrEncDateiname$) - 3) + "o8rn"
      PRINT #2, AchtrEncSlDateiname$ + " " + Fontname$ + " "; CHR$(34) + ".167 SlantFont TeXBase1Encoding ReEncodeFont" + CHR$(34) + " <[8r.enc <" + Dateiname$ + ".pfb"
   END SELECT

LOOP WHILE NOT EOF(1)
CLOSE

IF DIR$("fonts.tmp") <> "" THEN
   KILL "fonts.tmp"
END IF
PRINT "Fonts.map erzeugt"

END SUB

SUB PLtoTFLauf

PLDatei$ = DIR$("*.pl")
IF PLDatei$ = "" THEN
   CLS
   PRINT
   PRINT "No PL files available yet."
   PRINT "Please run 'TeX fontinst' first!"
   PRINT
   PRINT "Program aborted"
   END
END IF

DO
   PLDatei$ = LCASE$(PLDatei$)
   Punkt = INSTR(PLDatei$, ".")
   TFMDatei$ = LEFT$(PLDatei$, Punkt) + "tfm"
   Befehl$ = "pltotf " + PLDatei$ + " " + TFMDatei$
   SHELL Befehl$
   PLDatei$ = DIR$
LOOP WHILE PLDatei$ <> ""

END SUB

SUB VPtoVFLauf

VPLDatei$ = DIR$("*.vpl")
DO
   VPLDatei$ = LCASE$(VPLDatei$)
   Punkt = INSTR(VPLDatei$, ".")
   VFDatei$ = LEFT$(VPLDatei$, Punkt) + "vf"
   TFMDatei$ = LEFT$(VPLDatei$, Punkt) + "tfm"
   Befehl$ = "vptovf " + VPLDatei$ + " " + VFDatei$ + " " + TFMDatei$
   SHELL Befehl$
   VPLDatei$ = DIR$
LOOP WHILE VPLDatei$ <> ""

END SUB

