import java.io.*; 
import java.sql.*;
import java.util.*;

/*
 * SlideConnection.java
 *
 */


/**
 *
 * SlideConnection is a static class providing all data exchange with
 * the database engine. (In this case a mySQL-engine.)
 * In fact the only thing to do for using <i>CMS</i>4talks with a data
 * base engine other than mySQL is rewriting this class.
 *
 * Therefor a convention is not to make any calls to the data base from
 * other classes.
 *
 * @author  Olle Nebendahl
 *
 */

public class SlideConnection
{
    static Connection cn;
    static Statement    ust;
    static Statement    qst;
    
    static boolean gotConnection=false;
    
    static PreparedStatement wordIndexAddSt;
    static PreparedStatement searchIndexAddSt;
    static PreparedStatement tmpSearchIndexAddSt;
    
    static PreparedStatement slideSourceUpdateSt;
    static PreparedStatement slideTitleUpdateSt;
    static PreparedStatement slideSubjectUpdateSt;
    static PreparedStatement slideAnnotationUpdateSt;
    static PreparedStatement slideAAnnotationUpdateSt;
    static PreparedStatement slideUpdateSt;
    static PreparedStatement getSlideSourceByIdSt;
    
    static PreparedStatement talkTitleUpdateSt;
    static PreparedStatement talkSubjectUpdateSt;
    static PreparedStatement talkOriginalFileNameUpdateSt;
    static PreparedStatement talkSourceFileNameUpdateSt;
    static PreparedStatement talkFirstSlideUpdateSt;
    
    static PreparedStatement talks1stSlideUpdateSt;
    static PreparedStatement talks1stSlideDeleteSt;

    static PreparedStatement slideOrderUpdateSt;
    static PreparedStatement slideOrderNoPredSt;
    static PreparedStatement slideOrderNoSuccSt;
    static PreparedStatement slideOrderDeleteEntrySt;
    
    static PreparedStatement slideBelongsToTalkSt;
    static PreparedStatement slideBelongsToNoTalkSt;

    static PreparedStatement getWordIndexSt;
    static Statement getSlideIdFromWordSt;
    //PreparedStatement getSlideIdFromWordSt; // won't work
    static String getSlideIdFromWordFrage;
    static String getSlideIdFromWordFrageWithWildCards;
    static String getSlideIdFromWordFrageFullSearch;

    static String getSlideIdFromWordFrageCIS;
    static String getSlideIdFromWordFrageWithWildCardsCIS;
    static String getSlideIdFromWordFrageFullSearchCIS;
    
    
    static PreparedStatement getTalksSt;
    
    static PreparedStatement getSlideByIdSt;
    static PreparedStatement getTalkByIdSt;
    static PreparedStatement getSlideHeaderByIdSt;
    
    static PreparedStatement getSuccSlideSt;
    static PreparedStatement getPredSlideSt;
    static PreparedStatement getTalksBySlideSt;
    static PreparedStatement getTalkForSlideSt;
    static PreparedStatement getTalks1stSlideSt;
    
    static PreparedStatement prepStInt(PreparedStatement pst,int i)
    {
        try
        {
            pst.setInt(1,i);     
        }
        catch(SQLException e)
        { 
            System.out.println(e); 
            System.out.println("PreparedStatement prepStIntInt("+pst+","+i+")");
        }
        return pst;
    }
    
    
    static PreparedStatement prepStIntInt(PreparedStatement pst,int i, int j)
    {
        try
        {
            pst.setInt(1,i);     
            pst.setInt(2,j);
        }
        catch(SQLException e)
        { 
            System.out.println(e); 
            System.out.println("PreparedStatement prepStIntInt("+pst+","+i+","+j+")");
        }
        return pst;
    }

    static PreparedStatement prepStStrInt(PreparedStatement pst,String s,int i)
    {
        try
        {
            pst.setString(1,s);     
            pst.setInt(2,i);
        }
        catch(SQLException e)
        { 
            System.out.println(e); 
            System.out.println("PreparedStatement prepStStringInt("+pst+","+s+","+i+")");
        }
        return pst;
    }
    
    static void doSqlUpdate(PreparedStatement pst)
    {
        try 
        {
            pst.executeUpdate();
        } 
        catch( SQLException ex )
        {  System.out.println( ex ); System.out.println("static void soSqlUpdate(PreparedStatement "+pst+")");  }
    }
    
    
    static SlideConnection tryConnection(String DBDriverName, String DBURL, String DBUser, String DBUserPwd)
    {
        SlideConnection testConnection=new SlideConnection(DBDriverName, DBURL, DBUser, DBUserPwd);
        if(!testConnection.gotConnection)return null;
        return testConnection;
    }
 
    static
    {
        try
        {
           Class.forName( Constants.DBDriverName ).newInstance();
           cn = DriverManager.getConnection( Constants.DBURL, Constants.DBUser, Constants.DBUserPwd );
           gotConnection=true;
           prepareStatements();
        }
        catch(Exception e){ System.out.println(e); System.out.println("static { } ");System.exit(1);};
    } 
 
  SlideConnection(String DBDriverName, String DBURL, String DBUser, String DBUserPwd)
  {
      try
      {
         Class.forName( DBDriverName ).newInstance();
         cn = DriverManager.getConnection( DBURL, DBUser, DBUserPwd );
         gotConnection=true;
         prepareStatements();
      }
      catch(Exception e){ System.out.println(e); System.out.println("SlideConnection()");System.exit(1);};
  }
  
    SlideConnection()
    {
          this(Constants.DBDriverName, Constants.DBURL, Constants.DBUser, Constants.DBUserPwd );
    }


    private static void prepareStatements() throws SQLException
    {
        ust = cn.createStatement();
        qst = cn.createStatement();

        wordIndexAddSt = cn.prepareStatement("select talkid from talks;");

        wordIndexAddSt = cn.prepareStatement("insert into wordindex (word) values (\"?\");");
        searchIndexAddSt = cn.prepareStatement("insert into searchindex (wordid,slideid) values (\"?,?\");");
        tmpSearchIndexAddSt = cn.prepareStatement("insert into tempsearchindex (word,slideid) values (\"?,?\");");

        getSlideSourceByIdSt = cn.prepareStatement("select source from slides where slideid=?;");
        
        slideSourceUpdateSt = cn.prepareStatement("update slides set source=? where slideid=?;");
        slideTitleUpdateSt = cn.prepareStatement("update slides set title=? where slideid=?;");
        slideSubjectUpdateSt = cn.prepareStatement("update slides set subject=? where slideid=?;");
        slideAnnotationUpdateSt = cn.prepareStatement("update slides set annotation=? where slideid=?;");
        slideAAnnotationUpdateSt = cn.prepareStatement("update slides set aannotation=? where slideid=?;");
        
        talkSubjectUpdateSt = cn.prepareStatement("update talks set subject=? where talkid=?;");
        talkTitleUpdateSt = cn.prepareStatement("update talks set title=? where talkid=?;");
        talkOriginalFileNameUpdateSt = cn.prepareStatement("update talks set originalFileName=? where talkid=?;");
        talkSourceFileNameUpdateSt = cn.prepareStatement("update talks set SourceFileName=? where talkid=?;");
        talkFirstSlideUpdateSt = cn.prepareStatement("update talks set firstSlideId=? where talkid=?;");

        
        slideUpdateSt = cn.prepareStatement("update slides set title=?, subject=?, annotation=?, aannotation=?, source=?, duration=?, version=?, dateofcreation=? where slideid=?;");

        getWordIndexSt = cn.prepareStatement("select wordid from wordindex where word=?;");
        
        //getSlideHeaderByIdSt = cn.prepareStatement("select title,subject,aannotatoin,annotattion from slides where slideid=?;");
        getSlideByIdSt = cn.prepareStatement("select title,subject,aannotation,annotation,duration,version, dateofcreation, dateofmodification    from slides where slideid=?;");
        getTalkByIdSt = cn.prepareStatement("select title,subject,originalfilename,sourcefilename,firstslideid from talks where talkid=?;");
        
        getSuccSlideSt = cn.prepareStatement("select  slideid from slideorder where predslideid=?;");
        getPredSlideSt = cn.prepareStatement("select  predslideid from slideorder where slideid=?;");
        
        getTalksBySlideSt = cn.prepareStatement("select talkid from slidebelongstotalk where slideid=?;");
        getTalkForSlideSt = cn.prepareStatement("select talkid from slidebelongstotalk where slideid=?;");
        getTalks1stSlideSt = cn.prepareStatement("select slideid from talksfirstslide where talkid=?;");
        
        talks1stSlideUpdateSt = cn.prepareStatement("insert into talksfirstslide(talkid,slideid) values (?,?);");
        talks1stSlideDeleteSt = cn.prepareStatement("delete from talksfirstslide where talkid=?;");

        slideOrderUpdateSt = cn.prepareStatement("insert ignore into slideorder(slideid,predslideid) values (?,?);");
        
        slideOrderNoPredSt = cn.prepareStatement("delete from slideorder where slideid=?;");
        slideOrderNoSuccSt = cn.prepareStatement("delete from slideorder where predslideid=?;");
        slideOrderDeleteEntrySt = cn.prepareStatement("delete from slideorder where slideid=? and predslideid=?;");
        slideBelongsToTalkSt = cn.prepareStatement("insert into slidebelongstotalk(slideid,talkid) values (?,?);");
        slideBelongsToNoTalkSt = cn.prepareStatement("delete from slidebelongstotalk where slideid=?;");



        //getWordFromSlideIdSt = cn.prepareStatement("select slideid from searchindex,(select wordid from"
        //+" wordindex where word=\"?\") as temp where temp.wordid=searchindex.wordid;");        
        getSlideIdFromWordFrage="select slideid from searchindex,(select wordid from"
        +" wordindex where word like \"?\") as temp where temp.wordid=searchindex.wordid order by slideid;";
        getSlideIdFromWordFrageWithWildCards="select slideid from searchindex,(select wordid from"
        +" wordindex where word like \"?\") as temp where temp.wordid=searchindex.wordid order by slideid;";
        getSlideIdFromWordFrageFullSearch="select slideid from Slides where source like \"?\"";
        
        getSlideIdFromWordFrageCIS="select slideid from searchindex,(select wordid from"
        +" wordindex where lower(word) like lower(\"?\")) as temp where temp.wordid=searchindex.wordid order by slideid;";
        getSlideIdFromWordFrageWithWildCardsCIS="select slideid from searchindex,(select wordid from"
        +" wordindex where lower(word) like lower(\"?\")) as temp where temp.wordid=searchindex.wordid order by slideid;";
        getSlideIdFromWordFrageFullSearchCIS="select slideid from Slides where lower(source) like lower(\"?\");";
        
    }

    //select slideid from searchindex,(select wordid from wordindex where word="?") as temp where temp.wordid=searchindex.wordid
  
    protected void finalize() throws Throwable //todo close alle statements
    {
        try 
        {
            qst.close();
            ust.close();
            cn.close();
        } finally 
        {
            super.finalize();
        }
    } 




   
   static ResultSet doSqlQuery(String statementString) throws SQLException
   {
                 ResultSet  rs = qst.executeQuery( statementString );
                 return rs;
   }
   
   static ResultSet doSqlQuery(PreparedStatement pst) throws SQLException
   {
                 ResultSet  rs = pst.executeQuery();
                 return rs;
   }
   
   
   static String[] getSqlQuery1stCol(PreparedStatement pst)
   {
     OLL liste=new OLL();
     String s;
     try
     {
         ResultSet rs = doSqlQuery(pst);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getString(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stCol(String statementString)");
     }
     return liste.asStringArray();   
   }
   
   static int[] getSqlQuery1stColAsInt(PreparedStatement pst)
   {
     ILL liste= new ILL();
     int s;
     try
     {
         ResultSet rs = doSqlQuery(pst);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getInt(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stColAsInt(PreparedStatement pst)");
     }
     return liste.asArray(Help.HEAD_FIRST);   
   }

   static int[] getSqlQuery1stColAsInt(String statementString)
   {
     ILL liste=new ILL();
     int s;
     try
     {
         ResultSet rs = doSqlQuery(statementString);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getInt(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stCol(String statementString)");
     }
     return liste.asArray(Help.HEAD_FIRST);   
   }
   
   
   static String[] getSqlQuery1stCol(String statementString)
   {
     OLL liste=null;
     String s;
     try
     {
         ResultSet rs = doSqlQuery(statementString);
         ResultSetMetaData rsmd = rs.getMetaData();
         while( rs.next() )
         {
                  s=rs.getString(1);
                  liste.add(s);
         }
         rs.close();
     }
     catch( SQLException ex )
     {   
         System.out.println( ex );   
         System.out.println("getSqlQuery1stCol(String statementString)");
     }
        
     return liste.asStringArray();   
       
   }
   
   static Object[] getSqlQuery1stRow(String statementString)
   {
     return (Object[])getSqlQuery(statementString,true).getFirst();
   }
   
   static Object[] getSqlQuery1stRow(PreparedStatement pst)
   {
     return (Object[])getSqlQuery(pst,true).getFirst();
   }
   

   static OLL getSqlQuery(String statementString)
   {
     return getSqlQuery(statementString,false);
   }
   
   static OLL  getSqlQuery(PreparedStatement pst,boolean specialTask)
   {
     OLL objectList=new OLL();
     try
     {
         ResultSet rs = doSqlQuery(pst);
         rs2OLL(rs,objectList,specialTask);
     }
     catch( SQLException ex )
     {  System.out.println( ex ); System.out.println( "getSqlQuery(PreparedStatement pst,boolean specialTask)"+(3/(2-2)) ); System.exit(2);  }//
        
     return objectList;   
   }
   
   
   static OLL  getSqlQuery(String statementString,boolean specialTask)
   {
     OLL objectList=new OLL();
     try
     {
         ResultSet rs = doSqlQuery(statementString);
         rs2OLL(rs,objectList,specialTask);
     }
     catch( SQLException ex )
     {  System.out.println( ex ); System.out.println( "getSqlQuery(String statementString,boolean specialTask)"+(3/(2-2)) ); System.exit(3);  }//
        
     return objectList;   
   }
   
     
   static void rs2OLL(ResultSet rs, OLL oL, boolean specialTask)throws SQLException
   {
         ResultSetMetaData rsmd = rs.getMetaData();
         int n,t;
                 
         int nmax = rsmd.getColumnCount();
         
         Object[] result;

         while( rs.next() )
         {
            result = new Object[nmax];
            for( n=1 ; n<=nmax ; n++ )
            { 
              t=rsmd.getColumnType(n);
              switch(t)
              {
                case java.sql.Types.DATE:
                //case java.sql.Types.TIMESTAMP:
                case java.sql.Types.TIME:
                  result[n-1]=rs.getDate(n);
                  break;
                case java.sql.Types.TINYINT:
                case java.sql.Types.SMALLINT:
                case java.sql.Types.INTEGER:
                  result[n-1]=new Integer(rs.getInt(n));
                  break;
                case java.sql.Types.BIGINT:  
                  result[n-1]=new Long(rs.getLong(n));
                  break;
                case java.sql.Types.CHAR:
                case java.sql.Types.VARCHAR:
                case java.sql.Types.LONGVARCHAR:
                default:
                  result[n-1]=rs.getString(n);
                  //System.out.print(n);
                  //System.out.println(result[n-1]);
              }
            }
            oL.add(result);
            if(specialTask)break;
         }
         rs.close();
   }
   
    static void slideOrderUpdate(ILL orderList)
    {
        orderList.reset();
        int i;
        int p;
        if(orderList.hasNext())
        {
            i=orderList.getNext();
            while(orderList.hasNext())
            {
                p=i;
                i=orderList.getNext();
                slideOrderUpdate(i,p);  
            }
        }
    }
    
    static synchronized void slideBelongsToTalkUpdate(int slideId, int talkId)
    {
        slideBelongsToTalkDeleteEntry(slideId);
        if(talkId!=Constants.NO_TALK_ID)
        {
            try 
            { 
                prepStIntInt(slideBelongsToTalkSt,slideId,talkId).executeUpdate();
                //SlideOrderCache.empty();
            } catch( SQLException ex )
            {  
                            System.out.println( ex+"void doSlideBelongsToTalkUpdate("+slideId+","+talkId+")" );   
            }
        }
    }
    
   
    static synchronized void slideBelongsToTalkDeleteEntry(int slideId)
    {
        try 
        { 
            prepStInt(slideBelongsToNoTalkSt,slideId).executeUpdate();
        } catch( SQLException ex )
        {  
                         System.out.println( ex+"void doslideBelongsToTalkDeleteEntry("+slideId+")" );   
        }
    }
    
   
    static synchronized void slideOrderUpdate(int slideId, int predSlideId)
    {
        try 
        { 
            prepStIntInt(slideOrderUpdateSt,slideId,predSlideId).executeUpdate();
            SlideOrderCache.empty();
        } catch( SQLException ex )
        {  
                         System.out.println( ex+"void doSlideOrderUpdate("+slideId+","+predSlideId+")" );   
        }
    }
    
   
    static synchronized void slideOrderDeleteEntry(int slideId, int predSlideId)
    {
        try 
        { 
            prepStIntInt(slideOrderDeleteEntrySt,slideId,predSlideId).executeUpdate();
            SlideOrderCache.empty();
        } catch( SQLException ex )
        {  
                         System.out.println( ex+"void doslideOrderDeleteEntry("+slideId+","+predSlideId+")" );   
        }
    }
    

    static synchronized void slideOrderNoPred(int slideId)
    {
        try 
        { 
            prepStInt(slideOrderNoPredSt,slideId).executeUpdate();
        } catch( SQLException ex )
        {  
                         System.out.println( ex+"void slideOrderNoPred("+slideId+")" );   
        }
    }


    static synchronized void slideOrderNoSucc(int slideId)
    {
        try 
        { 
            prepStInt(slideOrderNoSuccSt,slideId).executeUpdate();
        } catch( SQLException ex )
        {  
                         System.out.println( ex+"void slideOrderNoSucc("+slideId+")" );   
        }
    }


    static synchronized int insertSlide()
    {
        doSqlUpdate("insert into slides values ()");
        Object[] test=(Object[])SlideConnection.getSqlQuery("select last_insert_id();").getFirst();
        return ((Long)test[0]).intValue();
    }
   
   static int[] getTalks()
   {
        return getSqlQuery1stColAsInt("select talkid from talks;");
   }

   
   int[] includeTalkPal(int[] slides)
   {
       int i;
       if(0==(i=slides.length))return null;
       String itpSt="(slideid="+slides[--i]+")";
       while(--i>0)itpSt+=" OR (slideid="+slides[i]+")";
       return getSqlQuery1stColAsInt("select slideid from slidebelongstotalk where talkid in (select distinct talkid from slidebelongstotalk where "+itpSt+");");
   }

    static int getTalkForSlide(int id)
    {
        try
        {
            getTalkForSlideSt.setInt(1,id);     
        }
        catch(SQLException e)
        { 
            System.out.println(e); System.out.println("int getTalkForSlide("+id+")");
        }
        try
        {
            return getSqlQuery1stColAsInt(getTalkForSlideSt)[0];
        }
        catch(ArrayIndexOutOfBoundsException e)
        {
            return Constants.NO_TALK_ID;
        }
        
    }
 
    /**
        This method doesn't make much sense in today`s implementation.
     */
    int[] _getTalksBySlide(int id)
    {
        try
        {
            getTalksBySlideSt.setInt(1,id);     
        }
        catch(SQLException e)
        { 
            System.out.println(e); System.out.println("int[] getTalksBySlide("+id+")");
        }
        return getSqlQuery1stColAsInt(getTalksBySlideSt);
    }
    
    static int getTalks1stSlide(int id)
    {
        try
        {
            getTalks1stSlideSt.setInt(1,id);     
        }
        catch(SQLException e)
        { 
            System.out.println(e); System.out.println("int[] getTalks1stSlide("+id+")");
        }
        int[] result=getSqlQuery1stColAsInt(getTalks1stSlideSt);
        if(result.length==0)return Constants.NO_SLIDE_ID;
        else //if(Constants.DBG)System.out.println(result[0]);
        return result[0];
    }
    

   static int[] getSuccSlides(int id)
   {
       try
       {
           getSuccSlideSt.setInt(1,id);     
       }
       catch(SQLException e)
       { 
           System.out.println(e); System.out.println("int[] succSlides("+id+")");
       }
       return getSqlQuery1stColAsInt(getSuccSlideSt);
   }

   static int[] getPredSlides(int id)
   {
       try
       {
           getPredSlideSt.setInt(1,id);     
       }
       catch(SQLException e)
       { 
           System.out.println(e); System.out.println("int[] predSlides("+id+")");
       }
       return getSqlQuery1stColAsInt(getPredSlideSt);
   }
   
   
   static String getSlideSourceByIdSt(int id)
   {
       try
       {
           getSlideSourceByIdSt.setInt(1,id);     
       }
       catch(SQLException e)
       { 
           System.out.println(e); System.out.println("String getSlideSourceById("+id+")");
       };

       return (String)getSqlQuery1stRow(getSlideSourceByIdSt)[0]; //"select source from slides where slideid="+id+";"
   }

// getSlideByIdSt = cn.prepareStatement("select title,subject,aannotation,annotation,duration,version, 
// dateofcreation,dateofmodification from slides where slideid=?;");   
   static SlideRecord getSlide(int id)
   {
       Object[] rawSlide=new Object[10];
       try
       {
           getSlideByIdSt.setInt(1,id);     
           rawSlide=getSqlQuery1stRow(getSlideByIdSt);
       }
       catch(SQLException e)
       { 
           System.out.println(e); System.out.println("SlideRecord getSlide("+id+")");
       }
       SlideRecord newSlide= new SlideRecord();
       int i=0;
       newSlide.setSlideId(id);
       if(null!=rawSlide[i])newSlide.setTitle((String)rawSlide[i]);i++;
       if(null!=rawSlide[i])newSlide.setSubject(rawSlide[i].toString());i++;
       if(null!=rawSlide[i])newSlide.setAAnnotation(rawSlide[i].toString());i++;
       if(null!=rawSlide[i])newSlide.setAnnotation(rawSlide[i].toString());i++;
//       if(null!=rawSlide[i])newSlide.setSource(rawSlide[i].toString());i++;
       if(null!=rawSlide[i])newSlide.setDuration((java.sql.Date)rawSlide[i]);i++;
       if(null!=rawSlide[i])newSlide.setVersion(((Integer)rawSlide[i]).intValue());i++;
       if(null!=rawSlide[i])newSlide.setDateOfCreation((java.sql.Date)rawSlide[i]);i++;
       if(null!=rawSlide[i])newSlide.setDateOfModification((String)rawSlide[i]);i++;
       return newSlide;

   }

    static TalkRecord getTalk(int id)
    {
        Object[] rawTalk=new Object[10];
        try
        {
            getTalkByIdSt.setInt(1,id);     
            rawTalk=getSqlQuery1stRow(getTalkByIdSt);
        }
        catch(SQLException e)
        { 
            System.out.println(e); System.out.println("SlideTalk getTalk("+id+")");
        }
        TalkRecord newTalk= new TalkRecord();
        int i=0;
        newTalk.setTalkId(id);
        if(null!=rawTalk[i])newTalk.setTitle((String)rawTalk[i]);i++;
        if(null!=rawTalk[i])newTalk.setSubject(rawTalk[i].toString());i++;
        if(null!=rawTalk[i])newTalk.setOriginalFileName(rawTalk[i].toString());i++;
        if(null!=rawTalk[i])newTalk.setSourceFileName(rawTalk[i].toString());i++;
        if(null!=rawTalk[i])newTalk.setFirstSlide(((Integer)rawTalk[i]).intValue());i++;
        
        //int firstSlide = getTalks1stSlide(id);
        //newTalk.setFirstSlide(firstSlide); 
        
        
        
        return newTalk;
   }

   
   
   static void doSqlUpdate(String statementString)
   {
        String[] statements=statementString.trim().split(";");
        int i=0;
             try 
             { 
                 while(i<statements.length)
                   ust.executeUpdate( statements[i++]);
             }
             catch( SQLException ex )
             {  
                System.out.println( ex );  
                System.out.println("doSqlUpdate(String statementString)"); 
                System.out.println("statementString: "+statementString);
                System.exit(3);
             }
   }
   
   
   static void doWordindexAdd(String s)
   {
             try 
             {
                    wordIndexAddSt.setString(1,s);
                    wordIndexAddSt.executeUpdate();
             } catch( SQLException ex )
                         {  System.out.println( ex );   }
   }
   
   static int getWordIndex(String word)
   {
        int t=-512;

             try { 
                    getWordIndexSt.setString(1,word);
                    
                    ResultSet  rs = getWordIndexSt.executeQuery();
   
                    ResultSetMetaData rsmd = rs.getMetaData();


                    if( rs.next() )
                          t=rs.getInt(1);
                    
                    rs.close();



                 } catch( SQLException ex )
                 {  
                    System.out.println( ex );   
                    System.out.println("   int getWordIndex(String word)");
                 }
        
        return t;
     
   }
   
   static void doTempSearchIndexAdd(String word, int slideId)
   {
             try { 
                    tmpSearchIndexAddSt.setString(1,word);
                    tmpSearchIndexAddSt.setInt(2,slideId);
                    tmpSearchIndexAddSt.executeUpdate();
                 } catch( SQLException ex )
                         {  System.out.println( ex );   }
   }

   static void doSearchIndexAdd(int wordid, int slideId)
   {
             try { //*** Anfrage  - Fehler abfangen **********************
                    searchIndexAddSt.setInt(1,wordid);
                    searchIndexAddSt.setInt(2,slideId);
                    searchIndexAddSt.executeUpdate();
                 } catch( SQLException ex )
                         {  System.out.println( ex );   }
   }
   
//  slideUpdateSt = cn.prepareStatement("update slides set title=?, subject=?, annotation=?, aannotation=?, source=?, 
//  duration=?, version=?, dateofcreation=? where slideid=?;");   

   static void doSlideUpdate(String title, String subject, String annotation, String aannotation, String source,
                             java.sql.Date duration, int version, java.sql.Date dateofcreation, int slideId)
   {
             try { 
                    slideUpdateSt.setString(1,title);
                    slideUpdateSt.setString(2,subject);
                    slideUpdateSt.setString(3,annotation);
                    slideUpdateSt.setString(4,aannotation);
                    slideUpdateSt.setString(5,source);
                    slideUpdateSt.setDate(6,duration);
                    slideUpdateSt.setInt(7,version);
                    slideUpdateSt.setDate(8,dateofcreation);
                    
                    slideUpdateSt.setInt(9,slideId);
                    slideUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doSlideUpdate(String title, int slideId)" );   
                 }
   }
   
   static void doSlideTitleUpdate(String title, int slideId)
   {
             try { 
                    slideTitleUpdateSt.setString(1,title);
                    slideTitleUpdateSt.setInt(2,slideId);
                    slideTitleUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doSlideTitleUpdate(String title, int slideId)" );   
                 }
   }

    static void doSlideSubjectUpdate(String subject, int slideId)
    {
        try 
        { 
            prepStStrInt(slideSubjectUpdateSt,subject,slideId).executeUpdate();
        } catch( SQLException ex )
        {  
                         System.out.println( ex+"void doSlideSubjectUpdate("+subject+","+slideId+")" );   
        }
    }

   static void doTalkTitleUpdate(String title, int talkId)
   {
             try { 
                    talkTitleUpdateSt.setString(1,title);
                    talkTitleUpdateSt.setInt(2,talkId);
                    talkTitleUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doTalkTitleUpdate(String title, int talkId)" );   
                 }
   }

   static void doTalkFirstSlideUpdate(int slideid, int talkId)
   {
             try { 
                    talkFirstSlideUpdateSt.setInt(1,slideid);
                    talkFirstSlideUpdateSt.setInt(2,talkId);
                    talkFirstSlideUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doTalkFirstSlideUpdate(int slideId, int talkId)" );   
                 }
   }

    static void doTalkSubjectUpdate(String s, int talkId)
    {
             try { 
                    talkSubjectUpdateSt.setString(1,s);
                    talkSubjectUpdateSt.setInt(2,talkId);
                    talkSubjectUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doTalkSubjectUpdate(String s, int talkId)" );   
                 }
    }

    static void doTalkOriginalFileNameUpdate(String s, int talkId)
    {
             try { 
                    talkOriginalFileNameUpdateSt.setString(1,s);
                    talkOriginalFileNameUpdateSt.setInt(2,talkId);
                    talkOriginalFileNameUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doTalkOriginalFileNameUpdate(String s, int talkId)" );   
                 }
    }

    static void doTalkSourceFileNameUpdate(String s, int talkId)
    {
             try { 
                    talkSourceFileNameUpdateSt.setString(1,s);
                    talkSourceFileNameUpdateSt.setInt(2,talkId);
                    talkSourceFileNameUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doTalkSourceFileNameUpdate(String s, int talkId)" );   
                 }
    }


    static void doSlideSourceUpdate(String source, int slideId)
    {
        doSlideSourceUpdate(source,"","","",slideId);
    }

    static void doSlideSourceUpdate(String source, String title, String subject, String annotation,  int slideId)
    {
        try 
        { 
            slideSourceUpdateSt.setString(1,source);
            slideSourceUpdateSt.setInt(2,slideId);
            slideSourceUpdateSt.executeUpdate();
            
            TreeSet words = SlideExtractor.indexWords(source+" "+title+" "+subject+" "+annotation);
            
            doSlideIndexEmpty(slideId);
            doSlideIndexUpdate(slideId,words);
            
            doSqlUpdate("insert into searchindex select wordid,slideid from wordindex, tempsearchindex where wordindex.word=tempsearchindex.word");
            doSqlUpdate("delete from tempsearchindex where true");
            
        } 
        catch( SQLException ex )
        {  
            System.out.println( ex+"void doSlideSourceUpdate(String source, int slideId)" );   
        }
    }
   
    static void doSlideIndexEmpty(int slideId)
    {
        doSqlUpdate("delete from searchindex where slideid="+slideId);
    }
    
    static void deleteSlide(int slideId)
    {
        doSlideIndexEmpty(slideId);
        doSqlUpdate("delete from talksfirstslide where slideid="+slideId);
        doSqlUpdate("delete from slidebelongstotalk where slideid="+slideId);
        doSqlUpdate("delete from searchindex where slideid="+slideId);
        //doSqlUpdate("delete from slideispartoftalk where slideid="+slideId); not used
        doSqlUpdate("delete from slideorder where slideid="+slideId);
        doSqlUpdate("delete from slides where slideid="+slideId);
    }
    
    static void doSlideIndexUpdate(int slideId,TreeSet ts)
    {
        doSlideWordIndexUpdate(ts);
        doSlideSearchIndexUpdate(slideId,ts);
    }

    static void doSlideWordIndexUpdate(TreeSet ts)
    {
        ts=new TreeSet(ts);
        StringBuilder sb =new StringBuilder();
        sb.append("insert ignore into wordindex (word) values ");
        sb.append("(\"evilworkar0und\")");
        Iterator it = ts.iterator();
        while(it.hasNext())
        {
            sb.append(",");
            sb.append("(\""+(String)it.next()+"\")"); 
            it.remove();
        }
        sb.append(";");
        doSqlUpdate(sb.toString());
        //System.out.println(sb.toString());
    }

    static void doSlideSearchIndexUpdate(int slideId,TreeSet ts)
    {
        ts=new TreeSet(ts);
        StringBuilder sb =new StringBuilder();
        sb.append("insert ignore into tempsearchindex (word,slideid) values");
        sb.append("(\"evilworkar0und\","+slideId+")");
        Iterator it = ts.iterator();
        while(it.hasNext())
        {
            sb.append(",");
            sb.append("(\""+(String)it.next()+"\","+slideId+")"); 
            it.remove();
        }
        sb.append(";");
        doSqlUpdate(sb.toString());
        //System.out.println(sb.toString());
    }

   static void doSlideAnnotationUpdate(String source, int slideId)
   {
             try { 
                    slideAnnotationUpdateSt.setString(1,source);
                    slideAnnotationUpdateSt.setInt(2,slideId);
                    slideAnnotationUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doSlideAnnotationUpdate(String source, int slideId)" );   
                 }
   }
   
   static void doSlideAAnnotationUpdate(String source, int slideId)
   {
             try { 
                    slideAAnnotationUpdateSt.setString(1,source);
                    slideAAnnotationUpdateSt.setInt(2,slideId);
                    slideAAnnotationUpdateSt.executeUpdate();
                 } catch( SQLException ex )
                 {  
                         System.out.println( ex+"void doSlideAAnnotationUpdate(String source, int slideId)" );   
                 }
   }
   
   
   
    static ILL getSlideIdFromWord(String word)
    {
        Constants.lastSearch=word;
        int starPos = word.indexOf('*');
        boolean a = starPos!=-1;
        boolean b = word.indexOf('%')!=-1;
        if(a)word=word.replace('*','%');
        if(b)return getSlideIdFromWord(word,SEARCH_FULLTEXT);    
        if(a)return getSlideIdFromWord(word,SEARCH_WILDCARD);    
        return getSlideIdFromWord(word,SEARCH_STANDARD);    
        
    }
    
    static String theGetSlideIdFromWordStatement;
    static final int SEARCH_STANDARD = 1;
    static final int SEARCH_WILDCARD = 2;
    static final int SEARCH_FULLTEXT = 3;
    static final int SEARCH_CASEINSENSITIVITY = 4;
    static final int SEARCH_STANDARD_CIS = 5;
    static final int SEARCH_WILDCARD_CIS = 6;
    static final int SEARCH_FULLTEXT_CIS = 7;

    static synchronized ILL getSlideIdFromWord(String word,int searchMode)
    {
        ILL liste=null;
        try 
        {
            switch(searchMode)
            {
                case 2:
                    theGetSlideIdFromWordStatement = getSlideIdFromWordFrageWithWildCards;
                    break;
                case 3:
                    theGetSlideIdFromWordStatement = getSlideIdFromWordFrageFullSearch;
                    break;
                case 5:
                    theGetSlideIdFromWordStatement = getSlideIdFromWordFrageCIS;
                    break;
                case 6:
                    theGetSlideIdFromWordStatement = getSlideIdFromWordFrageWithWildCardsCIS;
                    break;
                case 7:
                    theGetSlideIdFromWordStatement = getSlideIdFromWordFrageFullSearchCIS;
                    break;
                case 1:
                default:
                    theGetSlideIdFromWordStatement = getSlideIdFromWordFrage;
            }
        
            getSlideIdFromWordSt = cn.createStatement();
            ResultSet  rs = getSlideIdFromWordSt.executeQuery( theGetSlideIdFromWordStatement.replaceFirst("\\?",word) );          
            ResultSetMetaData rsmd = rs.getMetaData();
            int t=-512;
            liste=new ILL();

                while( rs.next() )
                {
                    t=rs.getInt(1);
                    liste.add(t);
                }                    
                    
                rs.close();



      } 
      catch( SQLException ex )
      {  
                    System.out.println( ex );   
                    System.out.println("   int[] getSlideIdFromWord(String word)");
         
      }
        
      if(liste.size()>0)return liste;
      else
          if(searchMode<SEARCH_CASEINSENSITIVITY)return getSlideIdFromWord(word,searchMode+SEARCH_CASEINSENSITIVITY);
          else return liste;
      
   }
   
   

    public static void main( String[] argv )
    {
        System.out.println("Its all OK");
    } 
   
   
}
