/*
 * SlideCache.java
 *
 */

/**
 *
 *  This class implements a cache caching SlideRecords. This avoids calling
 *  the database engine redundantly.
 *
 * @author  Olle Nebendahl
 */

class SlideCache
{ 
    static java.util.TreeMap cache=new java.util.TreeMap();
    
    static synchronized SlideRecord getSlide(int slideId) //  replaces getCachedSlide
    {
        SlideRecord result = (SlideRecord)cache.get(new Integer(slideId));
        if(null==result)
        {
            result=SlideConnection.getSlide(slideId);
            put(result,slideId);
            return result;
        }
        return result.clone();
    }
    
    static synchronized void empty()
    {
        cache=new java.util.TreeMap();
    }
    
   
    static synchronized void cacheSlide(SlideRecord slide,int slideId)
    {
        put(slide.clone(),slideId);
    }
   
    private static void put(SlideRecord sr, int slideId)
    {
        cache.put(new Integer(slideId),sr);
    }
}
