#define SMBMSG$K_STRUCTURE_LEVEL   1
#define SMBMSG$K_STRUCTURE_LEVEL_1 1

struct smbmsg$r_request_header {
	unsigned short smbmsg$w_request_code;
#define SMBMSG$K_PAUSE_TASK     1
#define SMBMSG$K_RESET_STREAM   2
#define SMBMSG$K_RESUME_TASK    3
#define SMBMSG$K_START_STREAM   4
#define SMBMSG$K_START_TASK     5
#define SMBMSG$K_STOP_STREAM    6
#define SMBMSG$K_STOP_TASK      7
#define SMBMSG$K_TASK_COMPLETE  8
#define SMBMSG$K_TASK_STATUS    9
#define SMBMSG$K_MAX_REQUEST_CODE 10
	unsigned char smbmsg$b_structure_level;
	unsigned char smbmsg$b_stream_index;
};
#define SMBMSG$S_REQUEST_HEADER sizeof (struct smbmsg$r_request_header)

struct smbmsg$r_item_header {
	unsigned short smbmsg$w_item_size;
	unsigned short smbmsg$w_item_code;
};
#define SMBMSG$S_ITEM_HEADER sizeof (struct smbmsg$r_item_header)

#define SMBMSG$K_ACCOUNTING_DATA        1
struct smbmsg$r_accounting_data {
	unsigned long smbmsg$l_pages_printed;
	unsigned long smbmsg$l_qio_puts;
	unsigned long smbmsg$l_rms_gets;
	unsigned long smbmsg$l_cpu_time;
};
#define SMBMSG$S_ACCOUNTING_DATA sizeof (struct smbmsg$r_accounting_data)

#define SMBMSG$K_ACCOUNT_NAME           2
#define SMBMSG$K_AFTER_TIME             3
#define SMBMSG$K_ALIGNMENT_PAGES        4
#define SMBMSG$K_BOTTOM_MARGIN          5
#define SMBMSG$K_CHARACTERISTICS        6

#define SMBMSG$K_CHECKPOINT_DATA        7
struct smbmsg$r_checkpoint_data {
	unsigned char smbmsg$b_filler;
	unsigned char smbmsg$b_checkpoint_level;
	unsigned short smbmsg$w_offset;
	unsigned long smbmsg$l_carcon;
	unsigned long smbmsg$l_page;
	unsigned long smbmsg$l_record_number;
	unsigned long smbmsg$q_user_key[2];
};
#define SMBMSG$S_USER_KEY 8
#define SMBMSG$S_CHECKPOINT_DATA (sizeof (struct smbmsg$r_checkpoint_data) - SMBMSG$S_USER_KEY)

#define SMBMSG$K_CONDITION_VECTOR       8
#define SMBMSG$K_DEVICE_NAME            9

#define SMBMSG$K_DEVICE_STATUS         10
struct smbmsg$r_device_status {
	unsigned long smbmsg$l_device_flags;
#define SMBMSG$V_LOWERCASE   0
#define SMBMSG$V_PAUSE_TASK  1
#define SMBMSG$V_REMOTE      2
#define SMBMSG$V_SERVER      3
#define SMBMSG$V_STALLED     4
#define SMBMSG$V_STOP_STREAM 5
#define SMBMSG$V_TERMINAL    6
#define SMBMSG$V_UNAVAILABLE 7
#define SMBMSG$M_LOWERCASE   (1 << SMBMSG$V_LOWERCASE)
#define SMBMSG$M_PAUSE_TASK  (1 << SMBMSG$V_PAUSE_TASK)
#define SMBMSG$M_REMOTE	     (1 << SMBMSG$V_REMOTE)
#define SMBMSG$M_SERVER      (1 << SMBMSG$V_SERVER)
#define SMBMSG$M_STALLED     (1 << SMBMSG$V_STALLED)
#define SMBMSG$M_STOP_STREAM (1 << SMBMSG$V_STOP_STREAM)
#define SMBMSG$M_TERMINAL    (1 << SMBMSG$V_TERMINAL)
#define SMBMSG$M_UNAVAILABLE (1 << SMBMSG$V_UNAVAILABLE)
};
#define SMBMSG$S_DEVICE_STATUS sizeof (struct smbmsg$r_device_status)

#define SMBMSG$K_ENTRY_NUMBER          11
#define SMBMSG$K_EXECUTOR_QUEUE        12
#define SMBMSG$K_FILE_COPIES           13
#define SMBMSG$K_FILE_COUNT            14
#define SMBMSG$K_FILE_SETUP_MODULES    15
#define SMBMSG$K_FIRST_PAGE            16
#define SMBMSG$K_FORM_LENGTH           17
#define SMBMSG$K_FORM_NAME             18
#define SMBMSG$K_FORM_SETUP_MODULES    19
#define SMBMSG$K_FORM_WIDTH            20
#define SMBMSG$K_FILE_IDENTIFICATION   21
#define SMBMSG$K_FILE_SPECIFICATION    22
#define SMBMSG$K_JOB_COPIES            23
#define SMBMSG$K_JOB_COUNT             24
#define SMBMSG$K_JOB_NAME              25
#define SMBMSG$K_JOB_RESET_MODULES     26
#define SMBMSG$K_LAST_PAGE             27
#define SMBMSG$K_LEFT_MARGIN           28
#define SMBMSG$K_LIBRARY_SPECIFICATION 29
#define SMBMSG$K_MAXIMUM_STREAMS       30
#define SMBMSG$K_MESSAGE_VECTOR        31
#define SMBMSG$K_NOTE                  32
#define SMBMSG$K_PAGE_SETUP_MODULES    33
#define SMBMSG$K_PARAMETER_1           34
#define SMBMSG$K_PARAMETER_2           35
#define SMBMSG$K_PARAMETER_3           36
#define SMBMSG$K_PARAMETER_4           37
#define SMBMSG$K_PARAMETER_5           38
#define SMBMSG$K_PARAMETER_6           39
#define SMBMSG$K_PARAMETER_7           40
#define SMBMSG$K_PARAMETER_8           41

#define SMBMSG$K_PRINT_CONTROL         42
struct smbmsg$r_print_control {
	unsigned long smbmsg$l_print_flags;
#define SMBMSG$V_DOUBLE_SPACE    0
#define SMBMSG$V_PAGE_HEADER     1
#define SMBMSG$V_PAGINATE        2
#define SMBMSG$V_PASSALL         3
#define SMBMSG$V_SEQUENCED       4
#define SMBMSG$V_SHEET_FEED      5
#define SMBMSG$V_TRUNCATE        6
#define SMBMSG$V_WRAP            7
#define SMBMSG$V_RECORD_BLOCKING 8
#define SMBMSG$M_DOUBLE_SPACE    (1 << SMBMSG$V_DOUBLE_SPACE)
#define SMBMSG$M_PAGE_HEADER     (1 << SMBMSG$V_PAGE_HEADER)
#define SMBMSG$M_PAGINATE        (1 << SMBMSG$V_PAGINATE)
#define SMBMSG$M_PASSALL         (1 << SMBMSG$V_PASSALL)
#define SMBMSG$M_SEQUENCED       (1 << SMBMSG$V_SEQUENCED)
#define SMBMSG$M_SHEET_FEED      (1 << SMBMSG$V_SHEET_FEED)
#define SMBMSG$M_TRUNCATE        (1 << SMBMSG$V_TRUNCATE)
#define SMBMSG$M_WRAP            (1 << SMBMSG$V_WRAP)
#define SMBMSG$M_RECORD_BLOCKING (1 << SMBMSG$V_RECORD_BLOCKING)
};
#define SMBMSG$S_PRINT_CONTROL sizeof (struct smbmsg$r_print_control)

#define SMBMSG$K_PRIORITY              43
#define SMBMSG$K_QUEUE                 44
#define SMBMSG$K_REFUSE_REASON         45
#define SMBMSG$K_RELATIVE_PAGE         46

#define SMBMSG$K_REQUEST_CONTROL       47
struct smbmsg$r_request {
	unsigned long smbmsg$l_request_flags;
#define SMBMSG$V_ALIGNMENT_MASK 0
#define SMBMSG$V_PAUSE_COMPLETE 1
#define SMBMSG$V_RESTARTING     2
#define SMBMSG$V_TOP_OF_FILE    3
#define SMBMSG$M_ALIGNMENT_MASK (1 << SMBMSG$V_ALIGNMENT_MASK)
#define SMBMSG$M_PAUSE_COMPLETE (1 << SMBMSG$V_PAUSE_COMPLETE)
#define SMBMSG$M_RESTARTING     (1 << SMBMSG$V_RESTARTING)
#define SMBMSG$M_TOP_OF_FILE    (1 << SMBMSG$V_TOP_OF_FILE)
};
#define SMBMSG$S_REQUEST sizeof (struct smbmsg$r_request)

#define SMBMSG$K_REQUEST_RESPONSE      48
#define SMBMSG$K_RIGHT_MARGIN          49
#define SMBMSG$K_SEARCH_STRING         50

#define SMBMSG$K_SEPARATION_CONTROL    51
struct smbmsg$r_separation_control {
	unsigned long smbmsg$l_separation_flags;
#define SMBMSG$V_FILE_BURST          0
#define SMBMSG$V_FILE_FLAG           1
#define SMBMSG$V_FILE_TRAILER        2
#define SMBMSG$V_FILE_TRAILER_ABORT  3
#define SMBMSG$V_JOB_FLAG            4
#define SMBMSG$V_JOB_BURST           5
#define SMBMSG$V_JOB_RESET           6
#define SMBMSG$V_JOB_RESET_ABORT     7
#define SMBMSG$V_JOB_TRAILER         8
#define SMBMSG$V_JOB_TRAILER_ABORT   9
#define SMBMSG$V_FIRST_FILE_OF_JOB  10
#define SMBMSG$V_LAST_FILE_OF_JOB   11
#define SMBMSG$M_FILE_BURST         (1 << SMBMSG$V_FILE_BURST)
#define SMBMSG$M_FILE_FLAG          (1 << SMBMSG$V_FILE_FLAG)
#define SMBMSG$M_FILE_TRAILER       (1 << SMBMSG$V_FILE_TRAILER)
#define SMBMSG$M_FILE_TRAILER_ABORT (1 << SMBMSG$V_FILE_TRAILER_ABORT)
#define SMBMSG$M_JOB_FLAG           (1 << SMBMSG$V_JOB_FLAG)
#define SMBMSG$M_JOB_BURST          (1 << SMBMSG$V_JOB_BURST)
#define SMBMSG$M_JOB_RESET          (1 << SMBMSG$V_JOB_RESET)
#define SMBMSG$M_JOB_RESET_ABORT    (1 << SMBMSG$V_JOB_RESET_ABORT)
#define SMBMSG$M_JOB_TRAILER        (1 << SMBMSG$V_JOB_TRAILER)
#define SMBMSG$M_JOB_TRAILER_ABORT  (1 << SMBMSG$V_JOB_TRAILER_ABORT)
#define SMBMSG$M_FIRST_FILE_OF_JOB  (1 << SMBMSG$V_FIRST_FILE_OF_JOB)
#define SMBMSG$M_LAST_FILE_OF_JOB   (1 << SMBMSG$V_LAST_FILE_OF_JOB)
};
#define SMBMSG$S_SEPARATION_CONTROL sizeof (struct smbmsg$r_separation_control)

#define SMBMSG$K_STOP_CONDITION        52
#define SMBMSG$K_TIME_QUEUED           53
#define SMBMSG$K_TOP_MARGIN            54
#define SMBMSG$K_UIC                   55
#define SMBMSG$K_USER_NAME             56
#define SMBMSG$K_MAX_ITEM_CODE         57

union smbmsg$r_item_data {
	struct smbmsg$r_accounting_data    smbmsg$accounting_data;
	struct smbmsg$r_checkpoint_data    smbmsg$checkpoint_data;
	struct smbmsg$r_device_status      smbmsg$device_status;
	struct smbmsg$r_print_control      smbmsg$print_control;
	struct smbmsg$r_request            smbmsg$request;
	struct smbmsg$r_separation_control smbmsg$separation_control;
	unsigned char  smbmsg$b_char_data[];
	unsigned short smbmsg$w_word_data[];
	unsigned long  smbmsg$l_longword_data[];
	struct { unsigned : 32; unsigned : 32; } smbmsg$q_quadword_data[];
};

struct smbmsg$r_message {
	struct smbmsg$r_item_header smbmsg$item_header;
	union  smbmsg$r_item_data   smbmsg$item_data;
};
