(* VDU implements the screen-driving routines used by DVItoVDU.
   InitVDU initializes the parameters for the VDU screen.
   After starting up, DVItoVDU breaks the screen into 2 parts:

   1. The DIALOGUE REGION will consist of the top 4 text lines on the screen.
      This region is used to display DVI and window status information,
      various kinds of messages and the command prompt.  DVItoVDU assumes
      text lines on the screen start at 1 and increase downwards.  The bottom
      text line on the screen is given by the parameter bottoml (also the total
      number of text lines).

   2. The WINDOW REGION is typically the remaining area of the screen and
      is used to display some sort of representation of the current DVI page.
      The user can move the window over any part of the current page,
      or even completely outside the page edges (but only just).
      The user can scale the page display by changing the width and height of
      the window region; windowwd and windowht are the initial, unscaled
      dimensions where one paper pixel equals one screen pixel.
      When addressing screen pixels, DVItoVDU assumes the top left pixel
      in the screen is at (0,0); horizontal coordinates increase to the right
      and vertical coordinates increase down the screen.  The top left pixel
      in the window region is at (windowh,windowv) in this coordinate scheme.

   The following diagram illustrates the screen coordinate system used by
   DVItoVDU and shows what the VDU parameters refer to.

                --> h increases to the right
   h,v=(0,0) *------------------------------------------------
             |                               DVIstatusl      | top text line = 1
       |     |              DIALOGUE REGION  windowstatusl   | (lines increase
       V     |                               messagel        |  downwards)
             |                               commandl        |
       v     * (windowh,windowv) ----------------------------|   ---
   increases |                                               |    |
     down    |                                               |    |
             |                                               |    |
             |                                               |    |
             |                WINDOW REGION                  | windowht
             |     contains windowwd * windowht pixels       |    |
             |                                               |    |
             |                                               |    |
             |                               bottoml         |    |
             -------------------------------------------------   ---

             |------------------ windowwd -------------------|

*)

VAR
   DVIstatusl,      (* DVI status line                                     *)
   windowstatusl,   (* window status line                                  *)
   messagel,        (* message line                                        *)
   commandl,        (* command line                                        *)
   bottoml,         (* bottom line; also number of text lines in screen    *)
   windowh,         (* horizontal coord for window's top left screen pixel *)
   windowv,         (* vertical coord for window's top left screen pixel   *)
   windowwd,        (* width of window in screen pixels                    *)
   windowht         (* height of window in screen pixels                   *)
      : INTEGER;

PROCEDURE InitVDU;                                  EXTERNAL;
PROCEDURE StartText;                                EXTERNAL;
PROCEDURE MoveToTextLine (line : INTEGER);          EXTERNAL;
PROCEDURE ClearTextLine  (line : INTEGER);          EXTERNAL;
PROCEDURE ClearScreen;                              EXTERNAL;
PROCEDURE StartGraphics;                            EXTERNAL;
PROCEDURE LoadFont (fontname : string;
                    fontsize : INTEGER;
                    mag, hscale, vscale : REAL);    EXTERNAL;
PROCEDURE ShowChar (screenh, screenv : INTEGER;
                    ch : CHAR);                     EXTERNAL;
PROCEDURE ShowRectangle (screenh, screenv,
                         width, height : INTEGER;
                         ch : CHAR);                EXTERNAL;
PROCEDURE ResetVDU;                                 EXTERNAL;
