.TH DVILJ2 1
.ad b
.SH NAME
dvilj2, dvilj2p, dvilj, dviljp, dvilj4, dvi3812 \- convert dvi files to HP
LaserJet or IBM 3812 format
.SH SYNOPSIS
\f3dvilj2\f1 [\f3-a\f2fontpath\f1] 
[\f3-b \f1] 
[\f3-c\f2copies\f1] 
[\f3-d\f2mode\f1]
[\f3-D\f1]
[\f3-E\f1] 
[\f3-e\f2output file\f1] 
[\f3-f\f2frompage\f1] 
[\f3-g\f1] 
[\f3-h\f2header file\f1] 
[\f3-l\f1] 
[\f3-M\f2flag\f1] 
[\f3-m\f2mag\f1] 
[\f3-p\f2pages\f1] 
[\f3-q\f1] 
[\f3-r\f1] 
[\f3-t\f2topage\f1] 
[\f3-s\f2pagesize\f1] 
[\f3-v\f1] 
[\f3-w\f1] 
[\f3-x\f2xoff(mm)\f1] 
[\f3-y\f2yoff(mm)\f1] 
[\f3-X\f2xoff(dots)\f1] 
[\f3-Y\f2yoff(dots)\f1] 
[\f3-z\f1] 
[\f2filename\f1]
.SH DESCRIPTION
Dvilj2 converts TeX-output .dvi files into HP PCL (i.e. HP Printer 
Control Language) commands suitable for printing on a HP LaserJet+,  
HP LaserJet II and fully compatible printers.
.br
Dvilj2p converts TeX-output .dvi files into HP PCL commands suitable
for printing on a HP LaserJet IIp, HP LaserJet III or HP Laserjet 2000
and fully compatible printers. This version uses a newer PCL command
set and provides landscape printing.
.br
Dviljp and dvilj are similar to dvilj2p and dvilj2 but they support
only 128 character fonts. They may be used for Laserjet clones which do
not support 256 character fonts.
.br
Dvilj4 is for the HP LasterJet IV printer familiy and fully compatible
clones. It implements a superset of the commands available for dvilj2p
and prints with an resolution of 600 dpi. In addition it provides support
for the printers builtin fonts using Karl Berry's coding scheme.
.br
Dvi3812 converts TeX-output .dvi files into PMP files, 
the native command language of the IBM 3812 page printer.
.br
All programs are generated from the same source dvi2xx.c.
They are usually called by a shell script or as a line printer filter.

.SH OPTIONS
.TP
\f3-a\f2fontpath\f1
directory to take fonts from (alternative to environment variable TEXPXL);
see below for details about the font directory structure
.TP
\f3-b\f1
.br
take paper for first page from alternate cassette (only 3812)
.TP
\f3-c\f2number\f1 
print each page \f2number\f1 times (including original)
.TP
\f3-d\f2number\f1 
print in duplex mode. The option -d\f21\f1 means long edge binding,
-d\f22\f1 stands for short edge binding. This option is only
selectable from \fIdvilj2p\fP, and is known to works on a LaserJet IId or a
LaserJet IIId or LaserJet IV.
.TP
\f3-D\f1
.br
Double-sided printing - see below; -D\f21\f1 prints odd sides only,
-D\f22\f1 is for even pages, a trailing \f2-\f1 suppresses printing of
empty padding pages.
.TP
\f3-E\f1
Switch printer into econo mode (dvilj4 only)
.TP
\f3-e\f2output file\f1
default output filename is the basename of dvi file and extension '.lj' 
for laserjet and '.pmp' for 3812. The '-e' option can be used to override
this default and to direct the output to a different file. 
If the output filename is set to '-` (option '-e-') the output is directed 
to stdout and can be directly piped into a spooler.
.TP
\f3-f\f2page number \f1
start printing at top of given page number
.TP
\f3-g\f1
.br
go - do not reset printer at start of job
.TP
\f3-h\f2header file\f1
headerfile to be copied before translation of dvi-file.
Used to send arbitrary commands to the laserprinter.
.TP
\f3-l\f1
.br
landscape - print output in landscape mode. This option is provided 
only for dvilj2p, dvilj4 and dvi3812.
.TP
\f3-M\f2flag\f1
Do not call MakeTeXPK. \f3-M\f21\f1 and \f3-M\f1 are equivalent,
\f3-M\f20\f1 switches to the default behavior (like no \f3-M\f1
specified). This flag is only valid if dvi2xx was compiled with
support for MakeTeXPK.
.TP
\f3-m\f2magnification\f1
Specifiy the magnification to use. The following are available:
.br
\f3-m#\f2usermag\f1  e.g. \f3#1200\f1
.br
\f3-m0\f1  equivalent to \f3-m#1000\f1
.br
\f3-mh\f1  equivalent to \f3-m#1095\f1
.br
\f3-m1\f1  equivalent to \f3-m#1200\f1
.br
\f3-mq\f1  equivalent to \f3-m#1250\f1
.br
\f3-m2\f1  equivalent to \f3-m#1440\f1
.br
\f3-m3\f1  equivalent to \f3-m#1728\f1
.br
\f3-m4\f1  equivalent to \f3-m#2074\f1
.br
\f3-m5\f1  equivalent to \f3-m#2488\f1
.TP
\f3-p\f2number of pages\f1   
print given number of pages
.TP
\f3-q\f1   
.br
quiet operation
.TP
\f3-r\f1   
.br
toggle reverse/not reverse order for output.
By default reverse=FALSE for 3812, reverse=TRUE for laserjet.
.TP
\f3-s\f2pagesize \f1
Spezify pagesize (LJ-family only!)
.br
\f3-s1\f1:  executive         (7.25in * 10.5in)
.br
\f3-s2\f1:  letter             (8.5in * 11in)
.br
\f3-s3\f1:  legal              (8.5in * 14in)
.br
\f3-s26\f1: A4                 (210mm * 297mm)
.br
\f3-s80\f1: monarch          (3.875in * 7.5in)
.br
\f3-s81\f1: commercial-10    (4.125in * 9.5in)
.br
\f3-s90\f1: international DL   (110mm * 220mm)
.br
\f3-s91\f1: international C5   (162mm * 229mm)
.br
All values are from the LJ II technical reference manual.
If the -s commandline option is omitted no clipping is performed
at the bottom of the page.
.TP
\f3-t\f2page number \f1
print to end of given page number
.TP
\f3-v\f1   
.br
verbose mode, list used fonts
.TP
\f3-w\f1   
.br
print no warnings 
.TP
\f3-x\f2offset\f1 
global x-offset in mm on output page
relative to 1 inch/1 inch origin
.TP
\f3-y\f2offset\f1 
global y-offset in mm on output page
relative to 1 inch/1 inch origin
.TP
\f3-X\f2offset\f1 
global x-offset in dots on output page 
(to set 1 inch/1 inch origin)
.TP
\f3-Y\f2offset\f1 
global y-offset in dots on output page
(to set 1 inch/1 inch origin)
.TP
\f3-z\f1   
.br
print a test page with the page counter at end of job 
(only for laserjet)
.TP
.br
If no arguments are specified a short help file is displayed.
.PP
.SH font directory structure
The specified fontpath may contain more than directory names. Under
Unix the direcory names are separated by a ':', under MSDOS by a ';'.
The paths are searched from left to right. For each directory in the 
searchpath the following font naming conventions are tried:
.br 6
-
dpi<resolution>/<fontname>.pk
(eg: ./dpi300/cmr10.pk)
.br
-
dpi<resolution>/<fontname>.pxl
(eg: ./dpi300/cmr10.pxl)
.br
-
pxl<magnification>/<fontname>.pk
(eg: ./pxl1500/cmr10.pk)
.br
-
pxl<magnification>/<fontname>.pxl
(eg:./pxl1500/cmr10.pxl)
.br
-
<fontname>.<resolution>pk
(eg: ./cmr10.300pk)
.br
-
<fontname>.<resolution>pxl
(eg: ./cmr10.300pxl)
.br
-
<fontname>.<resolution>
(eg: ./cmr10.300)
.PP
.SH \especial commands
Two TeX '\especial' commands are implemented:
.TP
\f3\especial{file=<filename>}\f1
copy specified file to the printer; either vector- or bitmap-graphics PMP 
commands (for laserjet and 3812)
.TP
\f3\especial{orientation=<value>}\f1
set page orientation to 0, 1, 2, 3;
rotate following output to landscape mode etc.
(3812 only).
.TP 0
others:
There are a few other special commands implented for the LJ-series,
which should only be used in connection with the distributed style 
files (eg graybox.sty). They are likely to be changed in forthcoming 
versions.
.PP
.SH Double Page Printing
The command line option -D causes the printer to print
in doublepage mode, that is - roughly speaking - printing first
the even pagen and then the odd pages of a document.
If -D is used to print both even and odd pages (-D is used
without the optional \f21\f1 or \f22\f1) 
the following will happen after
half of the pages is printed:
.TP 6
\f33812: \f1
the printer beeps, shows message U1. An operator
has to refill the printed pages into the paper tray and to
push the continue button on the printer.
.TP
\f3LJ:\f1
the printer stops, shows message "FEED" and switches
on manual feed led. The printer continues when either
the printed pages are fed into the manual page feeder,
or the operator pushes the continue button (after placing first
the printed pages into the paper tray).
.PP
If -D1 was specified only odd pages will be printed, -D2 can be used
for even pages. A trailing `-' (as in -D-, -D1- or -D2-) supresses
printing of empty pages which are generated for padding otherwise.
.PP
The driver allows the -D option for both print-directions (front-to-back 
or back-to-front printing). It tries to be clever in certain cases:
when a document has an odd number of pages it inserts in the
right place an empty page
when a document starts with page 0 the driver inserts an empty
page after the 0-page
when a piece of a document is printed that starts with
an even page-number it prints this page at the backside
of the first page to ensure that the odd sides are always
on the frontside. The 0-page is treated like an odd page.
.PP     
The doubleside option works for all LJs, not only for the
new D model with does doubleside-printing (actually, i don't
know wether it makes much sense on the new LJ II D at all).
.PP   
Caveat on the doubleside-option: When it is used frequently
or on very large files, it might become necessary to clean
the printer much more frequently.
.PP
The command line option -pX can be used to abort printing
after the output of X pages (can lead to strange results together
with -D). I personally dislike this option. The secure way of
printing a part of a document is using -f (from) and -t (to).
.PP
.SH ENVIRONMENT
The environment variable TEXPXL can be used to specify one or
more paths to the raster fonts (.pk, .pxl). The path separator
under Unix is ':', under MSDOS ';'. GF-fonts can be used
when the source is compiled without the preprocessor switch
USEPIXEL set.
.PP
Dvilj4 reads .tfm files and uses the contents of the 
environment variable TFMFONTS (if not specified TEXFONTS) as 
search path.
.PP
.SH AUTHOR
Gustaf Neumann, Wirtschaftsuniversitaet Wien
.br
neumann@wu-wien.ac.at

