import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.RootDoc;

/**
 * Dieses Doclet wandelt die geparsten Javadoc-Inhalte in Tex-Dateien im Format des javadoc-Packages um.
 * 
 * Erforderliche CommandLineOption ist:  -dest zielpfad der Ausgabedatei
 * 
 * @author Jolle
 * @since 13.05.2008
 * @version 1.0
 */

public class TexGen extends Doclet{
	/**
	 * In dieser Variable wird der Zielpfad der generierten Dateien gespeichert.
	 * 
	 * 
	 * Die Variable wird gesetzt, wenn die Commandlineparameter berprft werden, und
	 * gelesen, wenn die Ausgabedateien geschrieben werden sollen.
	 * 
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	private static String destpath = null;
	
	/**
	 * Funktion, die zum Starten der Verarbeitung vom Javadoc-Parser aufgerufen wird.
	 * @author Jolle
	 * @param root das geparste RootDoc-Element mit allen Informationen
	 * @return true, wenn erfolgreich; false wenn abgebrochen wurde
	 * @since version 1.0 vom 13.05.2008
	 */
	public static boolean start(RootDoc root)  {
		long starttime = System.currentTimeMillis();
		File zielpfad = new File(destpath);
		zielpfad.mkdir();
		String[] dateipfade = new String[root.classes().length];
		int dateipfadarrayzaehler = 0;
		
		for(ClassDoc cd : root.classes()){
			try {
				String dateiname =  (cd.containingPackage().name().length()>0?cd.containingPackage().name():"") + cd.name() + ".tex";
				dateiname = dateiname.replace('_','-');
				dateipfade[dateipfadarrayzaehler++] = dateiname;
				
				String filename = zielpfad.getAbsolutePath() + (zielpfad.getAbsolutePath().endsWith("/")||zielpfad.getAbsolutePath().endsWith("\\")?"":"/")+ dateiname;
				
				ClassWriter cw = new ClassWriter( filename );
				root.printNotice(filename);
				
				cw.print(cd);
			} catch (FileNotFoundException e) {
				root.printError(e.getMessage());
				return false;
			} catch (IOException e) {
				root.printError(e.getMessage());
				return false;
			}
		}
		
		root.printNotice( "Generation finished for " +root.classes().length + " classes in " + (System.currentTimeMillis()-starttime) +"ms");
    	return true;
    }
	
	/**
	 * Methode, die die Anzahl an Parameter zu einer Commandlineoption zurckgibt
	 * @author Jolle
	 * @param option Name der Option (beginnend mit "-")
	 * @return 0, wenn Option nicht vorhanden; ansonsten ein Wert >= 1
	 * @since version 1.0 vom 13.05.2008
	 */
	public static int optionLength(String option) {
		if( option.equals("-dest")) return 2;
		return 0;
	}

	/**
	 * Funktion, die die angegebenen Commandlineoptionen berprft
	 * @author Jolle
	 * @param options In dem Optionsfeld sind alle Tags mit ihren Parametern enthalten 
	 * @param reporter Ein Objekt, das zur Ausgabe von Meldungen genutzt werden kann
	 * @return true, wenn Optionsprfung erfolgreich; false wenn Fehler gefunden
	 * @since version 1.0 vom 13.05.2008
	 */
	public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
		boolean foundTagOptionDest = false;
		
	    for (String[] opt : options) {
	    	if (opt[0].equals("-dest")) {
	        	if (foundTagOptionDest) {
		            reporter.printError("Only one -dest option allowed.");
		            return false;
		        }
	        	else {
	        		destpath = opt[1];
	        		foundTagOptionDest = true;
	        	}
		    }
		}
		
	    if (!foundTagOptionDest) {
		   destpath = "testgendoc";
		}
		
		return foundTagOptionDest;
	}
	
}
