/* This file is part of the CJK package for LaTeX2e.

   This file is part of the NTU2CJK package.
*/

/* Read in the output of vmusage.ps, then modify the %%VMusage field
   in Type 1 font.
*/
#include <stdio.h>

#ifdef MSDOS
#define READ_WRITE_BIN "rb+"
#else
#define READ_WRITE_BIN "r+"
#endif

int main(int argv, char* argc[]) {
  char vmstr[25];
  FILE *pfa;
  int  i;

  if (argv==1) {
    fprintf(stderr,"Usage: vmusage PFA_file | vmmodify PFA_file\n");
    return 1;
  }

  if ((pfa=fopen(argc[1],READ_WRITE_BIN)) == NULL) {
    fprintf(stderr,"%s: open error!\n", argc[1]);
    return 1;
  }

  for(i=0;i<25;i++) vmstr[i] = 0;
  fgets(vmstr,25,stdin);        /* read VM string "%%VMusage: <min> <max>" */
  i = 24; vmstr[i--] = 0;
  while (vmstr[i]==0 || vmstr[i]=='\n') vmstr[i--] = ' ';

  while (!feof(pfa)) {
    if ('\n'==fgetc(pfa) && '%'==fgetc(pfa) && '%'==fgetc(pfa) &&
        'V'==fgetc(pfa) && 'M'==fgetc(pfa) && 'u'==fgetc(pfa)) {
      fseek(pfa,-5L,SEEK_CUR);
      fputs(vmstr,pfa);
      break;
    }
  }
  fclose(pfa);
  return 0;
}
