unit tc_io;

{$I options.inc}

interface

uses dos,graph,tc_glob;

procedure recompile;

procedure save(macro,recomp:boolean);
{Speichert ein Bild bzw. ein Macro}

procedure load(macro,startup,recomp:boolean);
{Laedt ein Bild bzw. ein Macro}

implementation
uses tc_draw;
{$ifopt N+}
 type real=extended;
{$endif}

var tex_name,mac_name,file_name:pathstr;
    tex_file:text;

procedure get_name(path:pathstr; suff:extstr; var name:pathstr; loading:boolean);
{GH}
var ende:boolean;
    attr:word;
    d:dirstr; n:namestr; e:extstr;
begin
fsplit(name,d,n,e);
if d='' then d:=path; if (d<>'') and (d[length(d)]<>'\') then d:=d+'\';
if loading or (n='') then n:='*';
if e='' then e:=suff; if e='' then e:='.*';
name:=fexpand(d+n+e);
message('Filename:'); get_str(msg_line,name,ende);
if ende or (name='') then file_name:=''
else begin
   file_name:=fexpand(name);
   if file_name[length(file_name)]<>'\' then begin
      assign(tex_file,file_name); getfattr(tex_file,attr);
      if (doserror=0) and (attr and directory<>0) then
         file_name:=file_name+'\*'+e;
   end;
end;
end; {get_name}

procedure recompile;
{JW}
var
 f:searchrec;
 dir_list:array[0..255] of string[12];
 i,count:byte;
begin
 get_name(opt.tex_path,opt.tex_suff,tex_name,false);
 if file_name <> ''
 then begin
  findfirst(tex_name,readonly+archive,f);
  count:=0;
  while (doserror=0) and (count < 255) do begin
   dir_list[count]:=f.name;
   FindNext(F);
   inc(count);
  end;
  for i:= 0 to count-1 do begin
   file_name:=dir_list[i];
   load(false,false,true);
   save(false,true);
  end;
 end
 else
  message('');
end;


function fileselect(file_name:pathstr):pathstr;
{GH}
const maxdirsize=256;
type dirrec=record
        attr:byte;
        name:string[12];
     end;
var dirlist:array[1..maxdirsize] of dirrec;
    f:searchrec; d:dirstr; n:namestr; e:extstr;
    count,first,i,j,wahl:integer;
    ende,found,ch_dir:boolean;

begin
 fileselect:=''; fsplit(file_name,d,n,e);
 ch_dir:=true; wahl:=1;
 found:=(pos('*',file_name)=0) and (pos('?',file_name)=0);
 repeat
  if not found
  then begin
   if ch_dir
   then begin
    funk[0]:=file_name;
    ch_dir:=false; count:=0; first:=1;
    findfirst(d+'*.*',directory,f);
    while (doserror=0) and (count<maxdirsize) do begin
     if (f.attr and directory)<>0
     then begin
      inc(count);
      dirlist[count].attr:=f.attr;
      dirlist[count].name:=f.name;
     end;
     FindNext(F);
    end;
    findfirst(file_name,readonly+archive,f);
    while (doserror=0) and (count<maxdirsize) do begin
     inc(count);
     dirlist[count].attr:=f.attr;
     dirlist[count].name:=f.name;
     FindNext(F);
    end;
   end;
   funk[1]:=''; i:=2;
   while (i<max_func) and (first+i-2<=count) do begin
    funk[i]:=dirlist[first+i-2].name; inc(i);
   end;
   funk[i]:='';
   if wahl>i
   then
    wahl:=i;
   menu(i,wahl);
   if wahl=i
   then begin
    first:=first+max_func-2;
    if first>=count
    then begin
     first:=count-max_func+3;
     if first<1
     then
      first:=1;
    end;
   end
   else
    if wahl=0
    then begin
     fileselect:='';
     exit;
    end
    else
     if wahl=1
     then
      if first<=max_func-1
      then
       first:=1
      else
       first:=first-max_func+2
     else
      if (dirlist[first+wahl-2].attr and directory)<>0
      then begin
       if dirlist[first+wahl-2].name<>'.'
       then begin
        if dirlist[first+wahl-2].name='..'
        then begin
         j:=length(d)-1;
         while d[j]<>'\' do
          dec(j);
         d[0]:=chr(j);
        end
        else
         d:=d+dirlist[first+wahl-2].name+'\';
        file_name:=d+n+e;
        ch_dir:=true;
       end
      end
      else begin
       found:=true;
       file_name:=d+dirlist[first+wahl-2].name;
      end;
  end;
 until found;
 fileselect:=file_name;
end; {fileselect}

function max(a,b,c:real):real;
{GH}
begin
if a>b then if a>c then max:=a
                   else max:=c
       else if b>c then max:=b
                   else max:=c
end;

function min2(a,b:real):real;
{JW}
begin
 if a<b
 then
  min2:=a
 else
  min2:=b;
end;

function vorz(a:real):real;
{JW}
begin
 if a < 0
 then
  vorz:=-1
 else
  vorz:=1;
end;

procedure write_emline(var mx,my:real;xx,yy:real;var pointnum:integer);
{JW}
const
 genauigkeit=0.12;
var
 q,min,dx,dy,vx,vy,dqx,dqy:real;
 i,f:word;
begin
 if opt.only_emtex {and (mx <> xx) and (my <> yy)}
 then begin
  inc(pointnum);
  write(tex_file,'\emline{',mx:1:2,'}{',my:1:2,'}{',pointnum,'}{');
  inc(pointnum);
  writeln(tex_file,xx:1:2,'}{',yy:1:2,'}{',pointnum,'}');
  mx:=xx;
  my:=yy;
 end
 else begin
  dqx:=xx-mx;
  dqy:=yy-my;
  vx:=vorz(dqx);
  vy:=vorz(dqy);
  min:=min2(abs(dqx),abs(dqy));
  if min > genauigkeit
  then begin
   f:=round(min/genauigkeit+0.5);
   dx:=(xx-mx)/f;
   dy:=(yy-my)/f;
(*   for i:= 1 to f-1 do begin
    if abs(dx) > abs(dy)
    then
     writeln(tex_file,'\put(',mx:1:2,',',my:1:2,
                    '){\line(',vx:0:0,',',0,'){',abs(dx):1:2,'}}')
    else
     writeln(tex_file,'\put(',mx:1:2,',',my:1:2,
                    '){\line(',0,',',vy:0:0,'){',abs(dy):1:2,'}}');
    mx:=mx+dx;
    my:=my+dy;
   end;*)
   if abs(dx) > abs(dy)
   then
    writeln(tex_file,'\multiput(',mx:1:2,',',my:1:2,
                   ')(',dx:1:2,',',dy:1:2,
                   '){',f,'}{\line(',vx:0:0,',',0,'){',abs(dx):1:2,'}}')
   else
    writeln(tex_file,'\multiput(',mx:1:2,',',my:1:2,
                   ')(',dx:1:2,',',dy:1:2,
                   '){',f,'}{\line(',0,',',vy:0:0,'){',abs(dy):1:2,'}}');
  end
  else begin
   dx:=xx-mx;
   dy:=yy-my;
   if abs(dx) > abs(dy)
    then
     writeln(tex_file,'\put(',mx:1:2,',',my:1:2,
                    '){\line(',vx:0:0,',',0,'){',abs(dx):1:2,'}}')
    else
     writeln(tex_file,'\put(',mx:1:2,',',my:1:2,
                    '){\line(',0,',',vy:0:0,'){',abs(dy):1:2,'}}');
  end;
  mx:=xx;
  my:=yy;
 end;
end;

procedure write_reduced_emlines(var mx,my,qx,qy  :real;
                              t,xx,yy,start:real;
                          var pointnum     :integer);
{JW}
{Fat EMlinien mit fast gleicher Steigung zusammen}
var
 s1,s2:real;
begin
 if (t <> start)
 then
  if not opt.reduce
  then
   write_emline(mx,my,qx,qy,pointnum)
  else
  if (abs(xx-mx) > 0.01) and (abs(yy-my) > 0.01)
  then begin
   s1:=(qy-my)/(qx-mx);
   s2:=(yy-qy)/(xx-qx);
   if abs(s1-s2) > opt.stdiff
   then begin
    write_emline(mx,my,qx,qy,pointnum);
   end
  end;
 qx:=xx;
 qy:=yy;
end;

procedure write_emline_bezier(ptr:ptr_obj_type;var pointnum:integer);
{JW}
var x,y,sc,scp,xb,xa,yb,ya,mx,my,xx,yy,qx,qy,t,dt:real;
begin
 with ptr^ do begin
  sc:=num/2;
  if sc<1 then sc:=1;
  scp:=sc+1;
  xb:=2*(width-x_pos);
  xa:=((xx_pos-x_pos)-xb)/sc;
  yb:=2*(height-y_pos);
  ya:=((yy_pos-y_pos)-yb)/sc;
  xx:=x_pos;
  yy:=y_pos;
  mx:=xx;
  my:=yy;
  dt:=max(sqrt(scp)/opt.quality,5,0);
  t:=dt;
  while t<scp do begin
   x:=((t*xa+xb)/sc)*t;
   y:=((t*ya+yb)/sc)*t;
   xx:=x+x_pos;
   yy:=y+y_pos;
   write_reduced_emlines(mx,my,qx,qy,t,xx,yy,dt,pointnum);
   t:=t+dt;
  end;
  write_emline(mx,my,xx_pos,yy_pos,pointnum);
 end;
end; {emline_bezier}

procedure write_kreis(ptr:ptr_obj_type;min_w,min_h:real;var pointnum:integer);
{JW}
const
 pid=2*pi;
 a=1;
 b=1;
var
 x,y,sc,scp,xb,xa,yb,ya,mx,my,xx,yy,qx,qy,t,dt:real;
begin
 with ptr^ do begin
  if not fill and (rad >= 7){mm:maxrad}
  then begin
   mx:=x_pos-min_w;
   my:=y_pos-min_h;
   writeln(tex_file,'%\circle(',mx:1:2,',',my:1:2,'){',2*rad:1:2,'}');
   dt:=pid/(12+rad/4)/opt.quality;
   t:=dt;
   my:=my+rad;
   while t < pid do begin
    x:=rad*sin(t);
    y:=rad*cos(t);
    xx:=x+x_pos;
    yy:=y+y_pos;
    write_reduced_emlines(mx,my,qx,qy,t,xx,yy,dt,pointnum);
    t:=t+dt;
   end;
   write_emline(mx,my,x_pos-min_w,y_pos-min_h+rad,pointnum);
   writeln(tex_file,'%\end');
  end
  else begin
   write(tex_file,'\put(',x_pos-min_w:1:2,',',y_pos-min_h:1:2,'){');
   write(tex_file,'\circle');
   if fill
   then
    write(tex_file,'*');
   writeln(tex_file,'{',2*rad:1:2,'}}');
  end;
 end;
end;

procedure save(macro,recomp:boolean);
{JW,GH}
label 98,99;
var obj_ptr:ptr_obj_type;
    w1,h1,w2,h2,max_w,max_h,min_w,min_h:real;
    pointnum:integer;
    d:dirstr; n:namestr; e:extstr;
    f:searchrec;
    noerase:boolean;
begin

if not recomp
then begin
 if root=nil then begin
    message('No objects, ENTER !');
    repeat until yes_no(#13,#0);
    goto 99;
 end;
 if macro then get_name(opt.mac_path,opt.mac_suff,mac_name,false)
    else get_name(opt.tex_path,opt.tex_suff,tex_name,false);
 if file_name='' then goto 99;
 msg_line:=msg_line+24;
end;
noerase:=false;

fsplit(tex_name,d,n,e);
findfirst(d+n+'.pbk',readonly+archive,f);
if doserror=0
then begin
 message('Backup-File Exists');
 message('Overwrite [y/n]?');
 if yes_no('y','n')
 then begin
  assign(tex_file,d+n+'.pbk');
  erase(tex_file);
 end
 else begin
  noerase:=true;
  goto 98;
 end;
end;

if doserror=0
then begin
 findfirst(file_name,readonly+archive,f);
 if doserror=0
 then begin
  assign(tex_file,file_name);
  rename(tex_file,d+n+'.pbk');
 end;
end;
98:
assign(tex_file,file_name);
{$I-} reset(tex_file); {$I+}
if (ioresult=0) and not recomp
then begin
   close(tex_file);
   message('File already exists!');
   message('Overwrite [y/n]?');
   if not yes_no('y','n') then goto 99;
end;
message('Saving'); message(file_name);
{$I-} rewrite(tex_file); {$I+}
if ioresult<>0 then begin
   message('Error, ENTER !'); repeat until yes_no(#13,#0);
   goto 99;
end;
obj_ptr:=root; max_w:=-maxlongint; max_h:=-maxlongint;
min_w:=maxlongint; min_h:=maxlongint;
while obj_ptr<>nil do with obj_ptr^ do begin
  if (not macro) or picked then begin
   case art of
      txt,putaux: begin
         w1:=x_pos; h1:=y_pos;
         w2:=x_pos; h2:=y_pos;
      end;
      box: begin
         w1:=x_pos+width; h1:=y_pos+height;
         w2:=x_pos; h2:=y_pos;
      end;
      lin,vec: begin
         if width>x_pos then begin
            w1:=width; w2:=x_pos;
         end else begin
            w1:=x_pos; w2:=width;
         end;
         if height>y_pos then begin
            h1:=height; h2:=y_pos;
         end else begin
            h2:=height; h1:=y_pos;
         end;
      end;
      circ: begin
         w1:=x_pos+rad; h1:=y_pos+rad;
         w2:=x_pos-rad; h2:=y_pos-rad;
      end;
      oval: begin
         w1:=x_pos+width/2; h1:=y_pos+height/2;
         w2:=x_pos-width/2; h2:=y_pos-height/2;
      end;
      bezier,
      bezvec: begin
         w1:=max(x_pos,width,xx_pos);
         w2:=-max(-x_pos,-width,-xx_pos);
         h1:=max(y_pos,height,yy_pos);
         h2:=-max(-y_pos,-height,-yy_pos);
      end;
      aux: begin
         w1:=-maxlongint; h1:=-maxlongint;
         w2:=maxlongint; h2:=maxlongint;
      end;
   end; {case}
   if w1>max_w then max_w:=w1; if h1>max_h then max_h:=h1;
   if w2<min_w then min_w:=w2; if h2<min_h then min_h:=h2;
  end;
  obj_ptr:=obj_ptr^.next;
end;
if macro then begin
   max_w:=max_w-min_w; max_h:=max_h-min_h;
end else begin
   min_w:=0; min_h:=0;
end;
(*steigung:boolean;     {Linien mit bel. Steigung?}
  only_emtex:boolean;   {EMLinien werden durch \put...\line... ersetzen?}
  bezier:boolean;       {bezier-kurven mit bezier.sty oder EMLinien}
  quality:real;         {Qualitt von bezier durch emline}
  reduce:boolean;       {Verbundene EMlinien bei gleicher Steigung
                         zusammen fassen}
  stdiff:real;          {Steigungs-Differenz fr REDUCE = TRUE}
  snapping:boolean;     {Schnapp-Funktion an oder aus}
  snap_asp:integer;     {Rasterbreite fuer Schnapp-Funktion}
  zoom_fac:real;        {Vergrerungsfaktor}
*)

 writeln(tex_file,'%TexCad Options');
 if opt.steigung
 then writeln(tex_file,kommando[cgrade].kom,'{\on}')
 else writeln(tex_file,kommando[cgrade].kom,'{\off}');
 if opt.only_emtex
 then writeln(tex_file,kommando[clines].kom,'{\on}')
 else writeln(tex_file,kommando[clines].kom,'{\off}');
 if opt.bezier
 then writeln(tex_file,kommando[cbezmac].kom,'{\on}')
 else writeln(tex_file,kommando[cbezmac].kom,'{\off}');
 if opt.reduce
 then writeln(tex_file,kommando[creduce].kom,'{\on}')
 else writeln(tex_file,kommando[creduce].kom,'{\off}');
 if opt.snapping
 then writeln(tex_file,kommando[csnap].kom,'{\on}')
 else writeln(tex_file,kommando[csnap].kom,'{\off}');
 writeln(tex_file,kommando[cqual].kom,'{',opt.quality:1:2,'}');
 writeln(tex_file,kommando[cgdiff].kom,'{',opt.stdiff:1:2,'}');
 writeln(tex_file,kommando[csnapasp].kom,'{',opt.snap_asp,'}');
 writeln(tex_file,kommando[czoom].kom,'{',opt.zoom_fac:1:2,'}');

if opt.only_emtex
then writeln(tex_file,'\special{em:linewidth ',opt.linewidth,'}');
writeln(tex_file,'\unitlength ',opt.unitlength,#13#10,
        '\linethickness{',opt.linewidth,'}',#13#10,
        '\begin{picture}(',max_w:1:2,',',max_h:1:2,')');
obj_ptr:=root; pointnum:=0;
while obj_ptr<>nil do with obj_ptr^ do begin
 if art=aux then writeln(tex_file,inhalt^)
 else
 if (not macro) or picked then
  if ((art=lin) or (art = vec)) and em
  then begin {emlinie}
    w1:=x_pos-min_w;
    h1:=y_pos-min_h;
    w2:=width-min_w;
    h2:=height-min_h;
    if art = vec
    then begin
     writeln(tex_file,'%\vector(',w1:1:2,',',h1:1:2,')(',
                                  w2:1:2,',',h2:1:2,')');
     get_slope(w2-w1,h2-h1,h_slope,v_slope,true);
     writeln(tex_file,'\put(',w2:1:2,',',h2:1:2,
                          '){\vector(',h_slope,',',v_slope,'){0.2}}');
    end
    else
    if not opt.only_emtex
    then
     writeln(tex_file,'%\emline(',w1:1:2,',',h1:1:2,')(',
                                  w2:1:2,',',h2:1:2,')');
    write_emline(w1,h1,w2,h2,pointnum);
    if (art = vec) or not opt.only_emtex
    then
     writeln(tex_file,'%\end');
  end else
   case art of
    bezier:
     begin
      if not opt.bezier
      then begin
       writeln(tex_file,'%\bezier{',round(num):1,'}(',x_pos:1:2,',',y_pos:1:2,
          ')(',width:1:2,',',height:1:2,')(',xx_pos:1:2,',',yy_pos:1:2,')');
       write_emline_bezier(obj_ptr,pointnum);
       writeln(tex_file,'%\end');
      end
      else
       writeln(tex_file,'\bezier{',round(num):1,'}(',x_pos:1:2,',',y_pos:1:2,
          ')(',width:1:2,',',height:1:2,')(',xx_pos:1:2,',',yy_pos:1:2,')');
     end;
    bezvec:
     begin
      writeln(tex_file,'%\bezvec{',round(num):1,'}(',x_pos:1:2,',',y_pos:1:2,
         ')(',width:1:2,',',height:1:2,')(',xx_pos:1:2,',',yy_pos:1:2,')');
      writeln(tex_file,'\put(',xx_pos:1:2,',',yy_pos:1:2,'){\vector(',
                       h_sl,',',v_sl,'){0.2}}');
      if not opt.bezier
      then
       write_emline_bezier(obj_ptr,pointnum)
      else
       writeln(tex_file,'\bezier{',round(num):1,'}(',x_pos:1:2,',',y_pos:1:2,
          ')(',width:1:2,',',height:1:2,')(',xx_pos:1:2,',',yy_pos:1:2,')');
      writeln(tex_file,'%\end');
     end;
    circ:
     begin
      write_kreis(obj_ptr,min_w,min_h,pointnum);
     end;
    aux: write(tex_file,inhalt^);
    else begin
     write(tex_file,'\put(',x_pos-min_w:1:2,',',y_pos-min_h:1:2,'){');
     case art of
      txt: if length(inhalt^) < 50
           then
            write(tex_file,'\makebox(0,0)[',adjust,']{',inhalt^,'}')
           else begin
            writeln(tex_file,'\makebox(0,0)[',adjust,']');
            write(tex_file,'{',inhalt^,'}')
           end;
      box: if solid
           then
            write(tex_file,'\rule{',width:1:2,'\unitlength}{',height:1:2,
                           '\unitlength}')
           else begin
            if dash
            then
             write(tex_file,'\dashbox{',dash_dimen:1:2,'}(')
            else
             write(tex_file,'\framebox(');
           write(tex_file,width:1:2,',',height:1:2,')[',adjust,']');
           if inhalt<>nil
           then begin
            if length(inhalt^) >= 50
            then
             writeln(tex_file);
            write(tex_file,'{',inhalt^)
           end
           else
            write(tex_file,'{');
           write(tex_file,'}');
        end;
      lin,
      vec: begin
            if art=lin
            then
             write(tex_file,'\line(')
            else
             write(tex_file,'\vector(');
            write(tex_file,h_slope,',',v_slope,'){',len:1:2,'}');
         end;
      oval: write(tex_file,'\oval(',width:1:2,',',height:1:2,')[',part,']');
      putaux: write(tex_file,inhalt^);
     end; {case}
     writeln(tex_file,'}');
    end;
   end;
 obj_ptr:=obj_ptr^.next;
end; {while}
writeln(tex_file,'\end{picture}'); close(tex_file);
if not noerase
then begin
 {$I-}
 assign(tex_file,d+n+'.pbk');
 erase(tex_file);
 {$I+}
 if ioresult <> 0
 then;
end;
if not macro then saved:=true;
99: message('');
end; {save}

function which_command(com:string;var art:obj_art_type;options:boolean):kom_type;
{JW}
var
 start,ende,i:kom_type;
begin
 art:=aux;
 if options then begin
  start :=cunit;
  ende  :=cputaux;
 end
 else begin
  start := cmakebox;
  ende  := caux;
 end;

 for i:= start to ende do
  if kommando[i].kom = com
  then begin
    art:=kommando[i].art;
    break
  end;
 if art = aux
 then
  which_command := caux
 else
  which_command := i;
end;

procedure load(macro,startup,recomp:boolean);
{JW,GH}
label 99;
var d:dirstr; n:namestr; e:extstr;
    h_opt:options_type;
    line_buf,com,arg:string;
    line,line_len,p:integer;
    ch:char; succ,stop:boolean;
    dum1,dum2:real;
    obj_ptr:ptr_obj_type;
    kommando:kom_type;
    mode,arg_len,q:byte;
    option:obj_art_type;
procedure error(msg:string);
{JW,GH}
var buf:pointer;
    bufsize:word;
    h:string;
    i:byte;
begin
   setviewport(0,0,max_x,65,clipon); bufsize:=imagesize(0,0,max_x,65);
   getmem(buf,bufsize); getimage(0,0,max_x,65,buf^);
   clearviewport; graph.line(0,65,max_x,65);
   str(line:4,h);
   case mode of
    0: begin
        h:='Line '+h+': '+line_buf;
        outtextxy(0,0,h);
        outtextxy((p+9)*8,12,'^');
       end;
    1: begin
        h:='Line '+h+': '+arg;
        outtextxy(0,0,h);
        outtextxy((q+9)*8,12,'^');
       end;
   end;
   msg:=msg+'!'; outtextxy(0,24,msg+' in '+file_name);
   outtextxy(0,42,'TeXcad terminates.');
   if yes_no(#13,#27)
   then
    buf:=buf;
{   outtextxy(0,42,'TeXcad terminates. Save picture [y/n]?');
   if yes_no('y','n') then begin
      setviewport(0,0,max_x,65,clipon);
      putimage(0,0,buf^,normalput); freemem(buf,bufsize);
      message(''); message('Save picture,');
      save(false);
   end;}
   halt;
end; {error}

procedure read_line;
{GH}
begin
   if eof(tex_file) then  error('Unexpected end of file')
   else begin
      if eoln(tex_file) then readln(tex_file);
      read(tex_file,line_buf); line_len:=length(line_buf); inc(line);
   end;
   p:=1;
end; {read_line}

procedure read_ch;
{JW,GH}
begin
 if mode = 0
 then begin
   if p>line_len
    then read_line;
   ch:=line_buf[p];
   inc(p);
 end
 else begin
  if q > arg_len
  then
   ch:=chr(255)
  else begin
   ch:=arg[q];
   inc(q);
  end;
 end;
end; {read_ch}

procedure seek_ch(x:char);
{JW,GH}
begin
 while ch <> x do
  if ch=' '
  then read_ch
  else error(''''+x+''' expected');
 read_ch;
end; {seek_ch}

procedure read_word;
{JW}
begin
 if ch = '\'
 then begin
  com:=com+'\';
  read_ch;
 end;
 if ch <> chr(255)
 then
  repeat com:=com+ch; read_ch;
  until (ch<'a') or (ch>'z');
end;

procedure read_com;
{JW}
begin
   com:='';
   while ch = ' ' do read_ch;
   if ch = '%'
   then begin
    com:='%';
    read_ch;
   end;
   if ch='\'
   then
    read_word;
end; {read_com}

procedure read_real(var r:real);
{JW,GH}
var neg:boolean;
    i:integer;
begin
   r:=0;
   while ch=' ' do read_ch;
   if (ch<>'-') and ((ch<'0') or (ch>'9'))
      then error('Number expected');
   if ch='-' then begin
      neg:=true; read_ch;
   end else neg:=false;
   while (ch>='0') and (ch<='9') do begin
      r:=10*r+ord(ch)-ord('0'); read_ch;
   end;
   if ch='.' then begin
      i:=1; read_ch;
      while (ch>='0') and (ch<='9') do begin
         i:=i*10; r:=r+(ord(ch)-ord('0'))/i; read_ch;
      end;
   end;
   if neg then r:=-r;
end; {read_real}

procedure read_coords(var x,y:real);
{GH}
begin
   seek_ch('('); read_real(x);
   seek_ch(','); read_real(y);
   seek_ch(')');
end; {read_coords}

procedure read_slope(var slope:integer);
{JW,GH}
begin
   {read_ch;} while ch=' ' do read_ch;
   if (ch<>'-') and ((ch<'0') or (ch>'9'))
      then error('Number expected')
   else begin
      if ch='-'
      then begin
        read_ch;
        slope:=-ord(ch)+ord('0');
      end
      else
       slope:=ord(ch)-ord('0');
      read_ch;
   end;
end; {read_slope}

procedure read_arg(op,cl:char; var arg1:string);
{JW,GH}
var count:integer;
    arg2  :string;
begin
   seek_ch(op); arg2 := ''; count:=1;
   repeat
{      if ch='\' then begin
         arg2:=arg2+ch; read_ch;
      end else}
      if ch=op then count:=count+1
         else if ch=cl then count:=count-1;
      if count>0 then arg2:=arg2+ch;
      read_ch;
   until (count=0) or (ch = chr(255));
   if count <> 0
   then
    error(''''+cl+''' expected');
   arg1:=arg2;
end; {read_arg}

procedure read_real_arg(var wert:real);
begin
 seek_ch('{'); read_real(wert); seek_ch('}');
end;

procedure search_endcom(endcom:string);
{JW}
begin
 if com[1] = '%'
 then begin
  repeat
   read_line;
  until pos(endcom,line_buf) <> 0;
  read_line;
  ch:=line_buf[p];
  inc(p);
 end;
end;

begin {load} {$V-}
 mode := 0;
 if not recomp
 then begin
  if (not macro) and (not saved)
  then begin
   message('Picture not saved!');
   message('Load anyway [y/n]?');
   if not yes_no('y','n')
   then goto 99;
  end;
  if macro then get_name(opt.mac_path,opt.mac_suff,mac_name,not startup)
     else get_name(opt.tex_path,opt.tex_suff,tex_name,not startup);
  file_name:=fileselect(file_name);
  if file_name='' then goto 99;
 end;
 if macro
 then mac_name:=file_name
 else tex_name:=file_name;
 msg_line:=msg_line+18;
 message('Loading'); message(file_name);
 assign(tex_file,file_name); {$I-} reset(tex_file); {$I+}
 if ioresult<>0
 then begin
   message('Error, ENTER !');
   repeat until yes_no(#13,#0);
   goto 99;
 end;
 if not macro
 then begin
   fsplit(file_name,d,n,e); opt_name:=d+n+'.opt'; load_opt(h_opt,succ);
   if succ then begin
      opt:=h_opt; h_mag:=opt.zoom_fac*3; v_mag:=h_mag*asp;
   end;
   delete_object_list;
   {release(heap_bottom); root:=nil; cur_obj:=nil;}
   redraw(true);
 end;
 pict_port; line:=0; p:=1; line_len:=0;
 read_ch;
 stop:=false;
 repeat
   repeat read_com;
   kommando:=which_command(com,option,true);
   if recomp and not(kommando in [cunit,cthick,cspec])
   then
    kommando := caux;
   if kommando = cunit
   then
    begin
      read_real(dum1); str(dum1:1:2,opt.unitlength);
      while ch=' ' do read_ch;
      while (ch>='a') and (ch<='z') do begin
         opt.unitlength:=opt.unitlength+ch; read_ch;
      end;
    end
   else
   if (kommando = caux) and (com <> '\begin')
   then begin
    read_line;
    read_ch;
   end
   else begin
    read_arg('{','}',arg);
    arg_len:=length(arg);
    q:=1;
    ch:=' ';
    mode := 1;
    case kommando of
     cspec   : if pos('em:linewidth',arg)<>0
               then opt.linewidth:=copy(arg,14,20);
     cthick  : opt.linewidth:=arg;
     cqual   : begin
                read_real(dum1);
                opt.quality:=dum1;
               end;
     cgdiff  : begin
                read_real(dum1);
                opt.stdiff:=dum1;
               end;
     csnapasp: begin
                read_real(dum1);
                opt.snap_asp:=round(dum1);
               end;
     czoom   : begin
                read_real(dum1);
                opt.zoom_fac:=dum1;
               end;
     else
      if com <> '\begin'
      then begin
       read_com;
       case kommando of
        cgrade :opt.steigung  :=com='\on';
        clines :opt.only_emtex:=com='\on';
        cbezmac:opt.bezier    :=com='\on';
        creduce:opt.reduce    :=com='\on';
        csnap  :opt.snapping  :=com='\on';
        else
         read_ch;
       end;
      end;
    end;
    mode := 0;
    ch:=line_buf[p-1];
   end;
(*      if com='\unitlength'  then begin
         read_real(dum1); str(dum1:1:2,opt.unitlength);
         while ch=' ' do read_ch;
         while (ch>='a') and (ch<='z') do begin
            opt.unitlength:=opt.unitlength+ch; read_ch;
         end;
      end
      else
      if com='\special' then begin
         read_arg('{','}',arg);
         if pos('em:linewidth',arg)<>0 then
            opt.linewidth:=copy(arg,14,20);
      end
      else
      if com='\linethickness'then begin
       read_arg('{','}',arg);
       opt.linewidth:=arg;
      end
      else
       if com <> '\begin'
       then
        read_ch;*)
   until com='\begin';
(*   read_arg('{','}',arg);*)
 until (arg='picture');
 read_coords(dum1,dum2);
repeat
 read_com; new(obj_ptr);
 with obj_ptr^ do begin
  kommando:=which_command(com,art,false);
  case kommando of
   cemline1:begin
             picked:=macro; em:=true;
             read_real_arg(x_pos);
             read_real_arg(y_pos);
             read_arg('{','}',arg);
             read_real_arg(width);
             read_real_arg(height);
             read_arg('{','}',arg);
             if macro
             then begin
              x_pos :=x_pos+x0;
              y_pos :=y_pos +y0;
              width :=width+x0;
              height:=height+y0;
             end;
             draw_line(obj_ptr);
           end;
   cemline2,
   cvector2:begin
            picked:=macro;
            em:=true;
            read_coords(x_pos,y_pos);
            read_coords(width,height);
            if macro
            then begin
             x_pos :=x_pos+x0;
             y_pos :=y_pos+y0;
             width :=width+x0;
             height:=height+y0;
            end;
            draw_line(obj_ptr);
            search_endcom('%\end');
           end;
   cbezier1,
   cbezier2,
   cbezvec:begin
            picked:=macro;
            read_real_arg(num);
            read_coords(x_pos,y_pos);
            read_coords(width,height);
            read_coords(xx_pos,yy_pos);
            if macro
            then begin
             x_pos :=x_pos +x0;
             y_pos :=y_pos +y0;
             xx_pos:=xx_pos+x0;
             yy_pos:=yy_pos+y0;
             width :=width +x0;
             height:=height+y0;
            end;
            draw_bezier(obj_ptr);
            search_endcom('%\end');
           end;
   ccircle2:begin
             picked:=macro;
             fill:=false;
             read_coords(x_pos,y_pos);
             read_real_arg(rad);
             rad:=rad/2;
             draw_circ(obj_ptr);
             search_endcom('%\end');
            end;
   cend1   :begin
             read_arg('{','}',arg);
             stop:=arg='picture';
            end;
   caux    :begin
             picked:=false; new(inhalt); inhalt^:=com;
             while p<=line_len do begin
              inhalt^:=inhalt^+ch;
              read_ch;
             end;
             inhalt^:=inhalt^+ch;
             read_ch;
            end;
   cput   :begin
            picked:=macro;
            read_coords(x_pos,y_pos);
            if macro
            then begin
             x_pos:=x_pos+x0;
             y_pos:=y_pos+y0;
            end;
            read_arg('{','}',arg);
            arg_len:=length(arg);
            q:=1;
            ch:=' ';
            mode := 1;
            read_com;
            kommando:=which_command(com,art,false);
            case kommando of
             cmakebox:begin {text}
                       read_coords(dum1,dum2);
                       read_arg('[',']',adjust);
                       new(inhalt);
                       read_arg('{','}',inhalt^);
                       draw_text(obj_ptr);
                      end;
             cframebox,
             cdashbox:begin {box}
                       solid:=false;
                       if com='\dashbox'
                       then begin
                        dash:=true;
                        read_real_arg(dash_dimen);
                       end
                       else
                        dash:=false;
                       read_coords(width,height);
                       read_arg('[',']',adjust);
                       read_arg('{','}',arg);
                       if arg<>''
                       then begin
                        new(inhalt);
                        inhalt^:=arg;
                       end
                       else
                        inhalt:=nil;
                       draw_box(obj_ptr);
                    end;
             crule:begin
                    solid:=true; dash:=false; inhalt:=nil;
                    seek_ch('{'); read_real(width); read_word; {com;} seek_ch('}');
                    seek_ch('{'); read_real(height); read_word;{com;} seek_ch('}');
                    draw_box(obj_ptr);
                   end;
             cline,
             cvector1:begin
                      em:=false;
                      seek_ch('('); read_slope(h_slope);
                      seek_ch(','); read_slope(v_slope); seek_ch(')');
                      read_real_arg(len);
                      if h_slope<>0
                      then begin
                       if h_slope>0
                       then
                        width:=x_pos+len
                       else
                        width:=x_pos-len;
                       if v_slope<>0
                       then
                        height:=y_pos+len/abs(h_slope)*v_slope
                       else
                        height:=y_pos;
                      end
                      else begin
                       width:=x_pos;
                       height:=y_pos+len*v_slope;
                      end;
                      draw_line(obj_ptr);
                     end;
             ccircle1:begin
                      if ch='*'
                      then begin
                       fill:=true;
                       read_ch;
                      end
                      else
                       fill:=false;
                      read_real_arg(rad);
                      rad:=rad/2;
                      draw_circ(obj_ptr);
                     end;
             coval:begin
                    read_coords(width,height);
                    lux:=x_pos-width/2; luy:=y_pos-height/2;
                    read_arg('[',']',part);
                    draw_oval(obj_ptr);
                   end;
             caux :begin
                    kommando := cputaux;
                    art:=putaux;
                   { picked:=false;} new(inhalt); inhalt^:=arg;
                    draw_unknown_put(obj_ptr);
                   end;
            end;
            mode := 0;
            ch:=line_buf[p-1];
           end
  end;
{#########################################################################}
  if stop
  then
   dispose(obj_ptr)
  else begin
   if root=nil
   then
    root:=obj_ptr
   else
    cur_obj^.next:=obj_ptr;
   cur_obj:=obj_ptr;
   cur_obj^.next:=nil;
  end;
 end; {with}
until stop;
close(tex_file); saved:=not macro;
99: message('');
end; {load}

var i:integer;

begin
   tex_name:=''; mac_name:='';
   for i:=1 to paramcount do begin
      if copy(paramstr(i),1,2)<>'-g' then begin
         tex_name:=paramstr(i); load(false,true,false);
      end;
   end;
end.
