unit mouse;
{Aufrufe der Funktionen des Mouse-Interrupts 33H, (c) GH Juni 1990}

interface

uses crt,dos;

var m_ok:boolean; {Maus ok?}
    m_xpos,m_ypos, {Koordinaten des Mousecursors}
    pr,rel, {Anzahl Tastendrcke bzw -loslasser}
    max_xpos,max_ypos,min_xpos,min_ypos:integer; {Bewegungsbereich der Mouse}
{Das Unit kommuniziert ber diese globalen Variablen mit dem
 aufnehmenden Programm}

procedure init_mouse;
{Initialisieren der Mouse}

procedure get_mouse_pos;
{Position des Mouse-Cursors abfragen}

procedure set_mouse_pos(x,y:integer);
{Position des Mouse-Cursors neu setzen}

procedure get_pressed_info(key:integer);
{Drck-Information ber Mouse-Taste Nummer 'key' erfragen:
 anz=Anzahl Tastendrcke, x,y=Koordinaten beim letzten Tastendruck}

procedure get_released_info(key:integer);
{Loslass-Information ber Mouse-Taste Nummer 'key' erfragen:
 anz=Anzahl Tastenloslasser, x,y=Koordinaten beim letzten Tastenloslassen}

procedure set_mouse_window(x1,y1,x2,y2:integer);
{Bewegungsbereich des Mouse-Cursors festlegen:
 x1,y1=linke obere Ecke, x2,y2=rechte untere Ecke}

procedure set_mouse_speed(x_mickey,y_mickey:integer);
{x_mickey,y_mickey=Anzahl Mickeys die einem horizontalen bzw.
 vertikalen Bildpunkt entsprechen}

implementation

var reg:registers; {Zum Aufrufen des Mouse-Interrupts 33H}

procedure init_mouse;
{GH}
begin
   with reg do begin
      ax:=0; intr($33,reg); m_ok:=ax=65535;
   end;
   m_xpos:=0; m_ypos:=0; pr:=0; rel:=0;
end; {init_mouse}

procedure get_mouse_pos;
{GH}
begin
   with reg do begin
      ax:=3; intr($33,reg);
      m_xpos:=cx div 8; m_ypos:=dx div 8;
   end;
end; {get_mouse_pos}

procedure set_mouse_pos(x,y:integer);
{GH}
begin
   m_xpos:=x; m_ypos:=y;
   with reg do begin
      ax:=4; cx:=8*x; dx:=8*y;
      intr($33,reg);
   end;
end; {set_mouse_pos}

procedure get_pressed_info(key:integer);
{GH}
begin
   with reg do begin
      ax:=5; bx:=key; intr($33,reg);
      pr:=bx; m_xpos:=cx div 8; m_ypos:=dx div 8;
   end;
end; {get_pressed_info}

procedure get_released_info(key:integer);
{GH}
begin
   with reg do begin
      ax:=6; bx:=key; intr($33,reg);
      rel:=bx; m_xpos:=cx div 8; m_ypos:=dx div 8;
   end;
end; {get_released_info}

procedure set_mouse_window(x1,y1,x2,y2:integer);
{GH}
begin
   min_xpos:=x1; max_xpos:=x2;
   min_ypos:=y1; max_ypos:=y2;
   with reg do begin
      ax:=7; cx:=8*x1; dx:=8*x2; intr($33,reg);
      ax:=8; cx:=8*y1; dx:=8*y2; intr($33,reg);
   end;
end; {set_mouse_window}

procedure set_mouse_speed(x_mickey,y_mickey:integer);
{GH}
begin
   with reg do begin
      ax:=15; cx:=x_mickey; dx:=y_mickey; intr($33,reg);
   end;
end; {set_mouse_speed}

begin
   init_mouse;
   if not m_ok then begin
      writeln('Warning: no mouse functions !');
      delay(1000);
   end;
end. {unit mouse}
