/*
  This is the file basic.h of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/

/* this file will be included in ttf.h */


#ifndef __TTF_BASIC_H
#define __TTF_BASIC_H

#include <stdio.h>


typedef unsigned char BYTE;
typedef signed char CHAR;
typedef unsigned short USHORT;
typedef signed short SHORT;
typedef unsigned long ULONG;
typedef signed long LONG;
typedef ULONG Fixed;
typedef USHORT FUnit;
typedef signed short FWord;
typedef USHORT uFWord;
typedef USHORT F2Dot14;

typedef short fixp; /* May use long to prevent overflow */ 
/* Fix point: S_############.## bit, range +-4096 with 1/4 precision */

#ifdef DEBUG
#define TTF_ALLOC(type, size, function) \
          ((type *)ttf_malloc(sizeof(type) * (size), (function)))
#define TTF_REALLOC(pointer, type, size, function) \
          ((type *)ttf_realloc((pointer), sizeof(type) * (size), (function)))
#define TTF_FREE(pointer, function) (ttf_free((pointer), (function)))
#else
#define TTF_ALLOC(type, size, function) \
          ((type *)ttf_malloc(sizeof(type) * (size)))
#define TTF_REALLOC(pointer, type, size, function) \
          ((type *)ttf_realloc((pointer), sizeof(type) * (size)))
#define TTF_FREE(pointer, function) (ttf_free(pointer))
#endif


BYTE get_BYTE(FILE *fp);
USHORT get_USHORT(FILE *fp);
SHORT get_SHORT(FILE *fp);
ULONG get_ULONG(FILE *fp);
Fixed get_Fixed(FILE *fp);
FWord get_FWord(FILE *fp);
uFWord get_uFWord(FILE *fp);
SHORT get_F2Dot14(FILE *fp);

#if 0
CHAR get_CHAR(FILE *fp);
LONG get_LONG(FILE *fp);
FUnit get_FUnit(FILE *fp);
#endif

#define sign(a) ((a) < 0 ? -1 : 1)
#define round(a) ((int)((a) + sign(a) * .5))
#define __max(a, b) ((a) > (b) ? (a) : (b))

#ifdef MSDOS
#define WRITE_BIN "wb"
#define WRITE_TXT "wt"
#define READ_BIN  "rb"
#define READ_TXT  "rt"
#else
#define WRITE_BIN "w"
#define WRITE_TXT "w"
#define READ_BIN  "r"
#define READ_TXT  "r"
#endif /* MSDOS */

#endif /* __TTF_BASIC_H */


/* end of basic.h */
