#ifdef USEPXL

#ifndef lint
static char sccsid[] = "@(#)pxl.c	3.1\t11/16/89";
#endif lint

#include <stdio.h>
#include "struct.h"
#include "defs.h"

#define  PXLID         1001
#ifndef FALSE
#define FALSE	0
#endif FALSE

extern void Fatal();
extern char *malloc();

extern int G_temporary;
extern font_entry *fontptr;

void
LoadPixel(pxlfp, cp)
FILE *pxlfp;
char_entry *cp;
{
    unsigned char *pr;
    register int nints;

    nints = ((cp->width + 31) >> 5) * 4 * cp->height;
    if ((pr = malloc(nints)) == NULL)
	Fatal("Unable to allocate memory for char\n");
    (void) fread(pr, 1, nints, pxlfp);
    cp->where.address.pixptr = pr;

    return;
}

int
Scanpxl(fptr, pxlfp)
register font_entry *fptr;
register FILE *pxlfp;
{
    int checksum;
    int i;
    char_entry *cp;

    if ((i = NoSignExtend(pxlfp, 4)) != PXLID)
	Fatal("PXL ID = %d, can only process PXL ID = %d files", i, PXLID);
    (void) fseek(pxlfp, -20L, 2);
    checksum = NoSignExtend(pxlfp, 4);
    fptr->magnification = NoSignExtend(pxlfp, 4);
    fptr->designsize = NoSignExtend(pxlfp, 4);

    (void) fseek(pxlfp, NoSignExtend(pxlfp, 4) * 4L, 0);

    for (i = FIRSTPXLCHAR; i <= LASTPXLCHAR; i++) {
	cp = &(fptr->ch[i]);
	cp->width = NoSignExtend(pxlfp, 2);
	cp->height = NoSignExtend(pxlfp, 2);
	cp->xOffset = SignExtend(pxlfp, 2);
	cp->yOffset = SignExtend(pxlfp, 2);
	cp->where.isloaded = G_temporary;
	if((cp->where.address.fileOffset = NoSignExtend(pxlfp, 4) * 4) == 0)
	    cp->where.address.fileOffset = NONEXISTANT;
	cp->tfmw = ((float) NoSignExtend(pxlfp, 4) *
	  (float) fptr->s) / (float) (1 << 20);
    }
    return(checksum);
}


/**********************************************************************/
/*****************************  EmitPXL  ******************************/
/**********************************************************************/
void
EmitPXL(c, ce, cmd)
int c;
char * cmd;
char_entry *ce;
{
    int   nwpl, nbpl;
    register int i, j, cc;
    register unsigned char *sl;
    float cw;

    EMITS("[<");
    cc = 2;
	nbpl = (ce->width + 7) >> 3;
	nwpl = (ce->width + 31) >> 5;
	for (i = ce->height - 1; i >= 0; i--) {
	    sl = ce->where.address.pixptr + i * nwpl;
	    for (j = 0; j < nbpl; j++, sl++) {
		if (cc > 78) {
		    EMITS("\n  ");
		    cc = 2;
		}
		EMITH(*sl);
		cc += 2;
	    }
	}
    cw = (float) ce->tfmw / (float) hconv / (double) fontptr->ps_scale;

#ifdef BUILTIN
	if (fontptr->dic_pack == TRUE) c = ce->pschar;
#endif /* BUILTIN */
	EMIT(outfp, "> %d %d %d %d %.3f] %d %s\n",
	  nbpl << 3, ce->height, ce->xOffset,
	  (((int) ce->height) - ce->yOffset) - 1, cw, c, cmd);
#ifdef STATS
	Snbpxl += nbpl * ce->height;
	fontptr->nbpxl += nbpl * ce->height;
	Sonbpx += (ce->width * ce->height + 7) >> 3;
	Sndc += 1;
#endif STATS
}

#endif USEPXL
