.TH CC2TEX 1 "SUN UTILITY"
.SH NAME
cc2tex \- Pseudo-Chinese latex utility
.SH SYNOPSIS
.B cc2tex -asc 
.IR filename 

.B cc2tex 
.IR filename 
.SH DESCRIPTION
The \fIcc2tex\fP program is a utility to help the user to put the Chinese character string
into latex format. The default is the standard output. According to user command, cc2tex first groups
the Chinese characters into a Postscript file, then includes the
file into latex by using the psfig command. It can successfully
typeset the Chinese character string within one line. But it can
not typeset a long Chinese text or a paper written in Chinese because
the way it is implemented. 

.PP
Please refer user's manual cc2texdoc.tex for detail.

.SH HOW TO RUN
When you edit your latex file, you can put your Chinese text into it 
in two ways. One is directly type in the Chinese character if you are
using a Chinese editor which enters Chinese character internal code according
to GB encoding. We call this file format as a
cc2tex raw file format. The other way is to 
enter the internal code of this Chinese text directly when you are
using a 7-bit editor such as vi. We call this file format as a cc2tex
file format. The cc2tex accept both cc2tex raw file or cc2tex file, and
produces the latex acceptable file directly to the standard output device.
.nf
              cc2tex cc2texdoc.tex >! cc2tex.tex
.fi
.LP
At the same time, it produces some cctex*.ps files which contain
the Chinese character images. 

The pre-condition of running the cc2tex is that you should have the psfig
utility in your latex system, and include the psfig utility in your latex file
by using the command \input{psfig} at the beginning of your file.
You must either have a directory called /usr/lib/ccfonts
which contains necessary  Chinese character font files or you set the
font library directory by using the environment variable CCFONT. 
.nf
              setenv CCFONT ~/lib/ccfonts
.fi

.SH OPTIONS
For the convenience of using the 7-bit
editor, you can use command
.nf
              cc2tex -asc cc2texdoc.tex >! cc2tex.tex
.fi
.LP
to change the cc2tex raw file format to a cc2tex file format.
.LP
If you put Chinese character directly,
without using %cctext{cc=...},
the program will add the 
%cctext{cc=d1a9c4e0} for you, d1a9c4e0 is the
internal code for that Chinese character string.
.LP
If you put Chinese character strings like this,
%cctext{cc=
.IB
Chinese character
, ccfname=clib.24, height=10pt}, The program only changes the
8-bits Chinese character to its internal code string representation as
the following. 
%cctext{cc=d1a9c4e0, ccfname=clib.24, height=10pt}.
.LP
When you use -idraw as the option of the command as follows:
.nf
\centerline{cc2tex -idraw cc2texdoc.tex >! cc2tex.c}
.fi
cc2tex will generate idraw format PostScript file instead of
pure PostScript. idraw is a MacDraw like drawing tool which
in the package INTERVIEWS distributed by Stanford university.
This option is only useful when you need to import Chinese
characters in your idraw output.
.LP
Option -nops is disable the output of those cctex.ps files.

.SH COMMAND SETTING
Cc2tex accepts two different commands, one is %ccglob{...}, the
other is %cctext{...}. Command ccglob is used to set the global typesetting
parameter, cctext is used to specify the local Chinese character strings,
and local parameter of the setting. If there is no local setting, then
the global setting is used. 
"+" before %cctext{..} will deactive the %cctext{...}.
If you put a line like +%cctext{...} , cc2tex will not process this
command. 
For example, the command 
%cctext{cc=d1a9c4e0, ccfname=clib.24, height=10pt}
will put the Chinese character XUE NI
at the place where this command is. The parameters are:
.TP 8
.B \fIcc=d1a9c4e0\fP
define the Chinese character to be printed. 
The d1a9c4e0 is the internal code of the Chinese characters 
XUE NI. You also can put
the two Chinese characters directly by a Chinese editor, then
use cc2tex -asc to change it to cc2tex file format.  That means by using
the -asc option, cc2tex changes the 8-bits internal codes to an ASCII string
like d1a9c4e0 above.
This option specifies a Chinese font to be used when display Chinese text.
This font should be the same height and twice the width as the normal
ASCII font.
.TP 8
.B \fIccfname=clib.24\fP
specify the font type to be displayed. There are
several different font types available. They are:
.nf
	elib.65, a vector font
	alib.24, a 24x24 point font 
	blib.24, a 24x24 point font
	clib.24, a 24x24 point font
	dlib.24, a 24x24 point font
	flib.24, a 24x24 point complex font 
	clib.16, a 16x16 point font
	flib.16, a 16x16 point complex font
.fi
.LP
Please note that 16  font is only working for the vertical direction.
.TP 8
.B  \fIheight=10pt\fP
Specify the image height. Same as psfig.
.TP 8
.B \fIwidth=3cm\fP
Specify the image width, Same as psfig.
.TP 8
.B \fIinterval=12\fP
Specify the interval between two Chinese characters.
The interval is compared to the basic font size..TP 8
.B \fIrotate=90\fP
Specify the Chinese character string rotate.
.TP 8
.B \fIdirection=1\fP
Specify the direction of Chinese character string
being printed.
.TP 8
.B \fIlinewd=1.2\fP
Specify the line width in vector font drawing.

.SH "ENVIRONMENT VARIABLE"
.IP CCFONT
\fIcc2tex\fP will try to locate the file containing the font files at
/usr/lib/ccfonts or the directory specified by environment CCFONT.

.SH AUTHORS
.PP
Wu Zhi Biao <wuzhibia@iscs.nus.sg> Department of Information System &
Computer Science, National University of Singapore, Republic of Singapore, 0511.

