---
myst:
  html_meta:
    keywords: LaTeX,formules mathématiques,HTML,équations,pages web,pages HTML,hypertexte"
---
# Comment afficher des maths sur une page web ?

La page [](/5_fichiers/formats/xml/convertir_du_latex_en_html) explique comment
convertir un document (La)TeX en fichier HTML.

Les nombreuses fontes désormais accessibles sur le web ainsi que les nouveaux
standards web et leurs possibilités permettent désormais d’afficher
correctement des formules mathématiques sur le web.

##  Technologies des polices de caractères 
La représentation directe des
mathématiques dans les navigateurs était entravée par la gamme limitée de
symboles dans les polices disponibles. Cependant, tous les systèmes
d'exploitation modernes incluent désormais des polices _OpenType_ avec de vastes
collections de symboles. Comme désormais, il est possible d’indiquer au
navigateur web où trouver une fonte particulière, on peut créer une page web
en spécifiant des polices particulière, et le rendu de la page ne dépendre
plus du fait que le lecteur ait préinstallé les polices appropriées. 
La page [](/5_fichiers/formats/fontes/fontes_opentype_pour_les_mathematiques) explique
que le format OpenType contient une partie réservée aux mathématiques et que
quelques fontes OpenType fournissent les caractères mathématiques. 

## L’interprétation directe d’un sous ensemble de commandes mathématiques LaTeX en Javascript

La rapidité des moteurs modernes Javascript permet de générer des pages web
contenant des morceaux de code (La)TeX qui sont transformées par le navigateur
web du lecteur. 

Les deux outils principaux sont les suivants.

- [MathJax](https://www.mathjax.org/) est la bibliothèque Javascript la plus
  utilisée pour le rendu des mathématiques dans une page web. Il supporte
  plusieurs types d’entrées, en particulier un sous ensemble de la syntaxe
  mathématique de LaTeX. Il peut être configuré pour produire différents types
  de sorties comme MathML, SVG ou (le plus souvent) de l’HTML et du CSS. Alors
  que normalement il est utilisé comme une bibliothèque Javascript exécutée du
  côté du navigateur du lecteur, il est aussi possible (en utilisant
  [Node.js](https://nodejs.org/)) de réaliser les conversions en avance et de
  servir les pages HTML avec le rendu mathématique déjà produit. 

  [MathJax](https://www.mathjax.org/) permet de télécharger une copy de la
  bibliothèque et de l’installer sur *votre* serveur. MathJax est un logiciel
  libre. 
- [KaTeX](https://khan.github.io/KaTeX/) est une nouvelle bibliothèque
  Javascript alternative. Son but principal est d’être plus simple et plus
  rapide que MathJax. Cette bibliothèque supporte moins de formats d’entrées et
  de sorties, et traite moins de structure LaTeX que ne le fait MathJax. 


## Écrire directement en XML

La conversion de (La)TeX en XML est tout à fait possible (par exemple avec
[TeX4ht](ctanpkg:tex4ht)) et les travaux se poursuivent dans ce domaine. 

L’autre solution, qui consiste à rédiger son document directement en XML (et
donc à produire des documents immédiatement adaptés au Web, voir même prêt à
l’emploi) et à utiliser (La)TeX pour la composition et la production d’un
fichier PDF, est également bien avancée. Une des techniques consiste, pour cela,
à [transformer le source XML en LaTeX](/5_fichiers/formats/xml/convertir_du_sgml_en_latex) 
en utilisant une feuille de style XSLT ou le code d’une bibliothèque XML, 
puis à utiliser simplement LaTeX. On peut aussi 
[composer directement à partir du source XML](/5_fichiers/formats/xml/utiliser_latex_pour_lire_du_xml). 

La représentation directe en MathML est un standard pour la représentation des
mathématiques sur le Web. Le support MathML est fourni pour la plupart des
navigateur (quitte à installer un plugin). Les formules écrites en MathML dans
la page peuvent être rendue par MathJax, avec une sortie identique à son rendu
TeX. MathJax utilise d’ailelurs une variante de MathML comme format
intermédiaire.


## Autres approches 

- [GELLMU Project](https://www.albany.edu/~hammond/gellmu/) propose une autre
  approche. Le document de base *article* est un document XML qui a une syntaxe
  proche de LaTeX, même si ce n’est pas tout à fait du LaTeX, et est fourni
  avec des traducteurs qui produisent à la fois du PDF (via *pdflatex*) et du
  XHTML+MathML. Une telle approche évite les limites inhérentes à la conversion
  «traditionnelle» de (La)TeX, dont les pièges peuvent être évité avec une
  syntaxe proche de LaTeX adaptée. 
- Les images SVG sont aussi devenues un standard pour les représentations
  graphiques sur le web. Ainsi, il est aussi possible de représenter des
  formules en SVG.
- [MathTeX](ctanpkg:mathtex) est aussi une alternative intéressante. Il s’agit
  d’un script CGI sur votre serveur qui produit à la volée des images PNG ou
  JPEG à partir d’une balise `<img>` dont la syntaxe est quelque chose comme :

  ```html
  <img src="/cgi-bin/mathtex.cgi?f(x)=\int\limits_{-\infty}^xe^{-t^2}dt />
  ```

  [Mathtex](ctanpkg:mathtex) est l’héritier du package précédent <ctanpkg:mimetex> par le même auteur.

:::{sources}
[Math on the Web](faquk:FAQ-mathml)
:::
