---
myst:
  html_meta:
    keywords: LaTeX, programmation, macros, commandes, définir des macros, définir des commandes, 
              catcodes, caractères actifs, commande à un seul caractère, macro à un seul caractère
---

# Comment changer un caractère en commande ?

## Avec les commandes de base

Un caractère isolé peut jouer le rôle de commande. De fait, [Plain TeX](/1_generalites/glossaire/plain_tex)
et LaTeX définissent tous deux le caractère `~` comme un espace insécable. 
Un caractère est rendu définissable, ou "actif", 
en passant son [code de catégorie](/2_programmation/syntaxe/catcodes/start), 
ou catcode, à `\active` (valeur 13) :

```{noedit}
\catcode`\_=\active
```

Tout caractère peut, en principe, être activé de cette manière et défini comme une commande :

```{noedit}
\def_{\_}
```

Ce dernier cas pourrait d'ailleurs être considéré comme une réponse un peu trop simple 
à la question "[](/3_composition/texte/symboles/caracteres/tiret)". 

Il faut cependant se méfier :
- si `~` est réputé actif, d'autres caractères peuvent être assez inattendus dans ce rôle 
  et interagir mal avec d'autres commandes ;
- en définissant un caractère actif, vous empêchez son utilisation à d'autres fins. 

Au final, peu de caractères sont donc susceptibles d'être disponible pour cela. 
S'il vous prenait l'envie de le faire, par exemple pour définir le caractère `z` 
en tant que commande, il faudrait indiquer quelque chose comme :

```{noedit}
\catcode`\z=\active
\def z{... chut, je dors...}%
```

Chaque `z` suivant dans le texte serait remplacé par un court texte. 
Ce serait une très mauvaise idée pour la plupart des documents, 
mais il pourrait y avoir des applications spéciales. Notez que, dans `\def z`, 
`z` n'est plus interprété comme une lettre et l'espace n'est donc pas nécessaire : 
`\defz` aurait donc fait l'affaire mais nous avons choisi ici de conserver l'espace 
pour le peu de clarté que cela apporte. Certaines extensions LaTeX facilitent de telles définitions, 
comme <ctanpkg:shortvrb> avec sa commande `\MakeShortVerb`.

TeX utilise les catcodes pour interpréter les caractères qu'il reçoit. 
*La modification de la valeur d'un catcode n'affecte pas les caractères qui ont déjà été lus*. 

Par conséquent, il est préférable que les caractères aient des catcodes fixes pour tout un document. 
Si les catcodes sont modifiés à des fins particulières (c'est ce que fait la commande `\verb`), 
les caractères modifiés ne seront pas interprétés correctement à la suite 
lorsqu'ils apparaîtront dans l'argument d'une autre commande 
(comme, par exemple, le montre la question 
"[](/4_domaines_specialises/sciences/informatique/verbatim/pourquoi_verbatim_ne_fonctionne_pas_toujours)").
Un exemple notable est celui de l'extension <ctanpkg:doc> qui traite les 
[fichiers de source documentée](/1_generalites/documentation/documents/documents_extensions/fichiers_sources_dtx) 
(ou fichiers `.dtx`) en utilisant l'extension <ctanpkg:shortvrb> 
pour définir `|`...`|` comme un raccourci pour `\verb|`...`|`. 
Mais `|` est également utilisé dans les préambules des 
[environnements de table](/3_composition/tableaux/construire_un_tableau), 
de sorte que les tableaux dans les fichiers `.dtx` ne peuvent avoir une séparation verticale 
entre les colonnes qu'en employant des mesures spéciales.

Une autre conséquence est que les assignations de catcode faites dans les commandes 
ne fonctionnent souvent pas comme prévu (voir la question 
"[](/2_programmation/macros/caracteres_actifs_dans_les_arguments_d_une_macro)"). 
Ce sera le cas pour la définition suivante :

```{noedit}
\def\faute{%
\catcode`_=\active
\def_{\textunderscore\-}%
}
```


## Quelques variantes

### Une définition globale

La commande `\faute` données ci-dessus ne fonctionne pas 
car elle tente de définir un caractère ordinaire `_`  : lorsque la commande est utilisée, 
le changement de catégorie ne s'applique pas au caractère de soulignement déjà présent 
dans la définition de la commande. Au lieu de cela, on peut utiliser :

```{noedit}
\begingroup
\catcode`_=\active
\gdef\correcte{%    notez la \gdef globale
  \catcode`_=\active
  \def_{\textunderscore\-}%
}
\endgroup
```


### Une définition avec `\lowercase`

Une façon "astucieuse" de créer une telle définition isolée dépend des propriétés curieuses de `\lowercase` : 
elle change les caractères sans modifier leurs catcodes. 
Puisqu'il existe toujours *un* caractère actif (`~`), 
nous pouvons tromper `\lowercase` en lui faisant modifier une définition
sans jamais changer explicitement de catcode :

```{noedit}
\begingroup
  \lccode''\~=''\_
  \lowercase{\endgroup
    \def~{\textunderscore\-}%
  }%
```

Les deux définitions précédentes ont le même effet général 
(le caractère est défini comme une commande, mais le caractère ne reste pas actif), 
à ceci près que la première définit une commande de type `\global`.


### Une définition avec les mathématiques

Pour les caractères actifs qui ne sont utilisés qu'en 
[mode mathématique](/4_domaines_specialises/mathematiques/passer_en_mode_mathematique),
il est préférable de laisser au caractère son catcode ordinaire, 
mais de lui attribuer un *code mathématique* actif spécial, comme dans la définition suivante :

```{noedit}
\begingroup
  \lccode''~=''x
  \lowercase{\endgroup
    \def~{\times}%
  }%
\mathcode`x=8000
```

Le caractère spécial ne nécessite pas d'être redéfini chaque fois qu'il est rendu actif --- 
la définition de la commande persiste même si le catcode du caractère revient à sa valeur d'origine ; 
la définition redevient accessible si le caractère redevient actif.

:::{sources}
[Defining characters as macros](faquk:FAQ-activechars)
:::
