#include "ListDir.h"
#include <iostream>

using namespace std;

int main(int argc, char ** argv)
{
   bool  ok = (argc >= 2);
   if (!ok)
   {
      cerr << "Usage: " << argv[0] << " <dir1> [<dir2> ...]" << endl;
   }
   else
   {
      for (int  i = 1;  i < argc;  ++i)
      {
         const char* dir = argv[i];
         ListDir  listDir(dir);
         unsigned n = listDir.nItems();
         cout << "dir=" << dir << ", n=" << n << endl;
         for (unsigned i = 0;  i != n;  ++i)
         {
            cout << "[" << i << "] " << listDir.item(i) << endl;
         }
      }
   }
   return !ok;
} // main

