# -*- python -*-
# $Id: OpenFont.py,v 1.7 2000/12/25 20:45:06 yotam Exp $
import string;
import GDK;
import GTK;
import gtk;
import gnome.ui;

# import lsp;
import match;
import goods;
import osgoods;
import gtkgoods;
import gnomegoods;

eTFM = 0;
ePK  = 1;
suffix = ('tfm', 'pk');

class dialog(gnome.ui.GnomeDialog):
   "Open Font Dialog"
   
   def __init__(self, loadCB=None, tfmPath="", pkPath="", app=None):
      gnome.ui.GnomeDialog.__init__(self, 
         'TFMPK - Open Font', 
         gnome.uiconsts.STOCK_PIXMAP_OPEN, 
         gnome.uiconsts.STOCK_BUTTON_OK, 
         gnome.uiconsts.STOCK_PIXMAP_CLOSE);
      self._loadCB = loadCB; # so we can delegate to app methods.
      self._origPath = {};
      # self._path = {};
      self._origPath[eTFM] = tfmPath;
      self._origPath[ePK] = pkPath;
      for k in [eTFM, ePK]:
         if self._origPath[k] == None or self._origPath[k] == "":
            path = osgoods.cmdOutput("kpsepath " + suffix[k]);
            self._origPath[k] = string.replace(path, "!", "");
         # self._path[k] = self._origPath[k];
         # print "path (%s) = %s." % (suffix[k], self._origPath[k]);
      self._app = app;
      # print "Open.dialog: tfmPath=%s, pkPath=%s" % (tfmPath, pkPath)
      self._matcher = None;
      self.connect('clicked', self.callback);
      self.connect("delete_event", gtkgoods.delete_keep)
      # self.connect("destroy", gtkgoods.destroy_keep,"abc")
      self.set_geometry_hints(base_height=300,
                              min_width=300,
                              min_height=300,
                              max_width=gtkgoods.MaxScreenSize, 
                              max_height=gtkgoods.MaxScreenSize);
      #
      self.notebook = notebook = gtkgoods.MyNoteBook()
      notebook.set_tab_pos(GTK.POS_TOP)
      # notebook.connect('event', self.notebook_cb);
      self.vbox.pack_start(notebook);

      pageList = self.makePageList(notebook.newPage("List"));
      pageFiles = self.makePagePair(notebook.newPage("(.tfm,.pk)"));
      pagePaths = self.makePagePaths(notebook.newPage("Paths"));

      # self.makePageList(pageList);
      pageList.show();
      pageFiles.show();
      pagePaths.show();
      notebook.show();
      
      # How to get the current cursor????
      self.normalCursor = gtk.cursor_new(GDK.LEFT_PTR);
      self.watchCursor  = gtk.cursor_new(GDK.WATCH);
      

   def makePageList(self, page):
      vbox = gtk.GtkVBox();
      vbox.set_border_width(6);
      page.add(vbox);
      flist = self.fontList = gtk.GtkCList(1, ["Fonts"]);
      flist.show()
      flist.connect('event', self.flist_cb)
      swin = gtk.GtkScrolledWindow()
      swin.set_policy(GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC);
      swin.add(flist);
      swin.show();
      vbox.pack_start(swin);
      gen = gtk.GtkButton("[Re]Generate");
      gen.show();
      gen.connect('clicked', self.genList);
      if self._app != None:
         self._app.setTip(gen,
"""Generate list of matched pairs of
foo.tfm and foo.<nnn>pk files
that are in the  tfm/pk paths.
It will some time depending on the
content of these paths.""");
      gtkgoods.PackCenteredInVBox(vbox, gen, ypad=4);
      vbox.show();
      return page;

   def makePagePair(self, page):
      vbox = gtk.GtkVBox();
      title = gtk.GtkLabel("Select Pair of Files");
      title.show();
      vbox.pack_start(title, expand=0, fill=0, padding=6);
      table = gtk.GtkTable(2, 2);
      self.pairBop = goods.nonelist(2);
      self.pairEnt = goods.nonelist(2);
      self.pairBop[eTFM] = gtk.GtkButton("tfm...");
      self.pairBop[ePK] = gtk.GtkButton("pk...");
      self.pairBop[eTFM].show();
      self.pairBop[ePK].show();
      self.pairEnt[eTFM] = gtk.GtkEntry();
      self.pairEnt[ePK] = gtk.GtkEntry();
      self.pairEnt[eTFM].show();
      self.pairEnt[ePK].show();
      self.fileSel = None;
      for i in (eTFM, ePK):
         b = self.pairBop[i];
         b.connect('clicked', self.bop_cb);
         e = self.pairEnt[i];
         table.attach(b, 0, 1, i, i+1, xoptions=0, yoptions=0,
                                           xpadding=5, ypadding=5);
         table.attach(e, 1, 2, i, i+1, xpadding=5, ypadding=5);
      table.show();
      vbox.pack_start(table, expand=1, fill=1, padding=4);
      vbox.show();
      page.add(vbox);
      return page;
   
   def makePagePaths(self, page):
      vbox = gtk.GtkVBox();
      title = gtk.GtkLabel("Edit paths for list generation");
      title.show();
      vbox.pack_start(title, expand=0, fill=0, padding=6);
      table = gtk.GtkTable(2, 2);
      self.pathLbl = goods.nonelist(2);
      self.pathEnt = goods.nonelist(2);
      self.pathLbl[eTFM] = gtk.GtkLabel("TFM");
      self.pathLbl[ePK] = gtk.GtkLabel("PK");
      self.pathLbl[eTFM].show();
      self.pathLbl[ePK].show();
      self.pathEnt[eTFM] = gtk.GtkEntry();
      self.pathEnt[ePK] = gtk.GtkEntry();
      self.pathEnt[eTFM].show();
      self.pathEnt[ePK].show();
      self.resetPaths(1957);
      for i in (eTFM, ePK):
         l = self.pathLbl[i];
         e = self.pathEnt[i];
         table.attach(l, 0, 1, i, i+1, xoptions=0, yoptions=0,
                                           xpadding=5, ypadding=5);
         table.attach(e, 1, 2, i, i+1, xpadding=5, ypadding=5);
      table.show();
      vbox.pack_start(table, expand=1, fill=1, padding=4);
      bReset = gtk.GtkButton("Reset");
      bReset.connect('clicked', self.resetPaths);
      bReset.show();
      if self._app != None:
         self._app.setTip(bReset, "Reset TFM and PK paths\nto original values");
      gtkgoods.PackCenteredInVBox(vbox, bReset, ypad=4);
      vbox.show();
      page.add(vbox);
      return page;
   
   def genList(self, button):
      self.get_window().set_cursor(self.watchCursor);
      gtkgoods.gflush();
      tfmPath = self.pathEnt[eTFM].get_text();
      pkPath = self.pathEnt[ePK].get_text();
      self._matcher = match.Matcher(tfmPath, pkPath);
      sortFntList = self._matcher.fonts.keys();
      sortFntList.sort();
      t = ["dum"];
      self.fontList.clear();
      for fntName in sortFntList:
         resultions = self._matcher.fonts[fntName][1].keys();
         resultions.sort(lambda x, y: (int(x) - int(y)));
         for res in resultions:
            t[0] = fntName + " @ " + res;  # string vs. numeric order!? bad
            self.fontList.append(t);
            self.fontList.thaw();
      cursor = gtk.cursor_new(GDK.LEFT_PTR);
      self.get_window().set_cursor(self.normalCursor);
     

   def loadFromList(self, i, parent=None):
      if i < 0:
         gnomegoods.warn("No font selected to load");
      else:
	 t0 = self.fontList.get_text(i, 0);
         (name, res) = string.split(t0, ' @ ');
         # print ("name=%s, res=%s\n" % (name, res));
         tfm_pks = self._matcher.fonts[name];
         tfmfn = tfm_pks[0];
         pkfn = tfm_pks[1][res];
         # print ("tfmfn=%s, pkfn=%s" % (tfmfn, pkfn));
	 if self._loadCB != None:
	    self._loadCB(tfmfn, pkfn)

   def flist_cb(self, clist, event):
      # print "list_cb:";
      # print "list_cb:, clist=", clist;
      # print "list_cb:, event=", event;
      # print "list_cb:, event.type=", event.type
      # print "list_cb:, event.dir=", dir(event)
      # print "focus_row=", self.fontList.focus_row
      if event.type == GDK._2BUTTON_PRESS:
         self.loadFromList(self.fontList.focus_row, clist);

   def bop_cb(self, button):
      self.itp = 0;
      if button == self.pairBop[1]:
         self.itp = 1;
      i = self.itp;
      if self.fileSel == None:
         self.fileSel = gtk.GtkFileSelection("Select File");
         # self.fileSel.connect("destroy", gtkgoods.destroy_keep)
         self.fileSel.connect("delete_event", gtkgoods.delete_keep)
         self.fileSel.hide_fileop_buttons();
         self.fileSel.ok_button.connect("clicked", self.fs_ok)
         self.fileSel.cancel_button.connect("clicked", self.fs_cancel)
      types = ("tfm", "pk");
      self.fileSel.set_title("TFMPK - Select .%s File" % types[i]);
      # patterns = ("*.tfm", "*.*pk");
      # self.fileSel.complete(patterns[i]);
      self.fileSel.show();
      self.fileSel.map();
      self.fileSel.get_window()._raise();
      gtk.grab_add(self.fileSel);

   def fs_ok(self, obj=None):
      gtk.grab_remove(self.fileSel);
      self.fileSel.hide();
      self.pairEnt[self.itp].set_text(self.fileSel.get_filename());
   def fs_cancel(self, obj=None):
      gtk.grab_remove(self.fileSel);
      self.fileSel.hide();


   def resetPaths(self, button):
      for k in [eTFM, ePK]:
         self.pathEnt[k].set_text(self._origPath[k]);

   def callback(self, button, no):
      pg = self.notebook.get_current_page();
      if no == 0 or no == 1:
         if pg == 0:
            i = -1;
            selection = self.fontList.selection;
            if len(selection) > 0:
               i = selection[i];
            self.loadFromList(i, button);
         elif pg == 1:
            if self._loadCB != None:
               tfmfn = self.pairEnt[eTFM].get_text();
               pkfn  = self.pairEnt[ePK].get_text();
               self._loadCB(tfmfn, pkfn);
      if no == 1 or no == 2:
         self.hide()

   def notebook_cb(self, w, e):
      if e.type == GDK.BUTTON_RELEASE:
         print "notebook_cb: page=", w.get_current_page();

if __name__ == '__main__':
   print "Testing OpenFont";
   import sys;
   print "Importing sys";
   dlg = dialog();
   dlg.show();
   gtk.mainloop();
   sys.exit(0);
