# -*- python -*-
# Font is a class for TFMPK application
# to hold the tfm & pk data and GUI components showing them.
# $Id: Font.py,v 1.10 2001/03/07 20:47:07 yotam Exp $

import os.path;
import re;
import string;
import GDK;
import GTK;
import gtk;
import gnome.ui;
import gnome.uiconsts;

# local
import tfm;
import pk;
import goods;
import gtkgoods;
import gnomegoods;
import osgoods;
import canvases;
import Focus;

# Enumerations for Font Windows
winMetrics = 0;
winFaces   = 1;
winFocus   = 2;
winAbout   = 3;
nWidnows   = 4;
# Meta-Names
winNames = ["metric", "face", "focus", "about"];

# Following enumerations used in indices
# to next dimFmtLabels and nTFM tuples.
eWidth  = 0;
eHeight = 1;
eDepth  = 2;
eItalic = 3;
eLigKern = 4;
eKern    = 5;
eExten   = 6;
nLists   = 7;

# List labels
dimFmtLabels = (
   'Widths[%d]',
   'Heights[%d]',
   'Depths[%d]',
   'Italics[%d]',
   'LigKerns[%d]',
   'Kerns[%d]',
   'Extens[%d]',
);

# List labels
dimLabels = (
   'Widths',
   'Heights',
   'Depths',
   'Italics',
   'LigKerns',
   'Kerns',
   'Extens',
);

# # entries in TFM's header
nTFM = (tfm.nw, tfm.nh, tfm.nd, tfm.ni, tfm.nl, tfm.nk, tfm.ne);

# Unbounded tfm methods
tfmMethods = (
   tfm.tfm.width,
   tfm.tfm.height,
   tfm.tfm.depth,
   tfm.tfm.italic,
   tfm.tfm.ligkern,
   tfm.tfm.kern,
   tfm.tfm.exten
);

# Get a compact space for integer display. Logarithm for the poor.
def decFmtLen(n):
   iFmt = "%d";     iLen = 10; # default for the rich
   if n < 10:
      iFmt = "%1d"; iLen = 1;
   elif n < 100:
      iFmt = "%2d"; iLen = 2;
   elif n < 1000:
      iFmt = "%3d"; iLen = 3;
   return (iFmt, iLen);

# Scrolled Clist
class ScrolledList(gtk.GtkScrolledWindow):
   def __init__(self, titles):
      gtk.GtkScrolledWindow.__init__(self);
      self.clist = gtk.GtkCList(len(titles), titles);
#


# Scrolled list with index
class ScrolledIList(ScrolledList):
   def __init__(self, title):
      ScrolledList.__init__(self, ["", title]);
      self.set_policy(GTK.POLICY_NEVER, GTK.POLICY_AUTOMATIC);
      self.add(self.clist);
      self._title = title;
      self._slist = [];
      self.sMax = len(title);
   def sappend(self, s):
      self._slist.append(s);
      self.sMax = max(self.sMax, len(s));
   def format(self, alignDot=1):
      n = len(self._slist);
      (iFmt, iLen) = decFmtLen(n);
      if alignDot:
         pass; # later
      self.clist.set_column_title(0, str(n));
      # print "n=%d, iFmt=%s, iLen=%d" % (n, iFmt, iLen)

      # Kludge to get fixed fonts in the lists.
      ffStyle = gtkgoods.getFFStyleFrom(self.clist);

      # We want to allign the decimal point
      decPtPos = 0;
      ss = []
      for mode in (0,1):
         for i in xrange(0, n):
            s = self._slist[i];
            dp = string.find(s, '.');
            if dp == -1:
               dp = string.len(s);
            if mode:
               indent = decPtPos - dp;
               if indent:
                  dsFmt = "%%%ds%%s" % indent;
                  self._slist[i] = dsFmt % ("", s);
            else:
               decPtPos = max(decPtPos, dp);

      for i in xrange(0, n):
         self.clist.append([iFmt % i, self._slist[i]]);
	 self.clist.set_row_style(i, ffStyle);
      self.clist.set_column_auto_resize(0, 1);
      self.clist.set_column_auto_resize(1, 1);
      self.clist.show();
#

class Font:
   def __init__(self, app, tfmfn, pkfn):
      self._app = app;
      self._tfmfn = tfmfn;
      self._pkfn  = pkfn;
      self.makename();
      self._tfm = tfm.tfm(tfmfn);
      self._pk = pk.pk(pkfn);
      self._ok = self._tfm.ok() and self._pk.ok();
      if self._ok:
         tfmcs = self._tfm.checksum();
         pkcs  = self._pk.checksum();
         self._ok = (tfmcs == pkcs);
         if not self._ok:
            gnomegoods.warn(
"""TFM file %s checksum = %d
 PK  file %s checksum = %d
are not equal""" % (tfmfn, tfmcs, pkfn, pkcs));
      else:
         if not self._tfm.ok():
            gnomegoods.warn("Loading TFM file \"%s\" failed" % tfmfn);
         else:
            gnomegoods.warn("Loading PK file \"%s\" failed" % pkfn);
      # print "Font: init ok=", self._ok;
      if self._ok:
         self.gui();
         self.select(self._pk.charfirst());

   def __del__(self):
      self.close();

   def close(self):
      for wi in [winMetrics, winFocus, winFaces, winAbout]:
         dlg = self.dialogs[wi];
         # print "dlg=", dlg;
         if dlg != None:
            dlg.destroy();
            self.dialogs[wi] = None;

   def tfm(self):
      return self._tfm;

   def pk(self):
      return self._pk;

   def reload(self):
      self._tfm = tfm.tfm(tfmfn);
      self._pk = tfm.tfm(pkfn);
      self._ok = self._tfm.ok() and self._pk.ok();

   def ok(self):
     return self._ok;

   # Because char selection is triggered from faces (into focus)
   # create Focus before. Better to initiate initial selection
   # from this module!!
   def gui(self):
      self.dialogs = goods.nonelist(nWidnows);
      self.dialogs[winMetrics] = self.metricsDialog();
      self.dialogs[winFocus]   = Focus.Focus(self, "%s - Focus" % self._name);
      self.dialogs[winFaces]   = self.facesDialog();
      self.dialogs[winAbout]   = self.aboutDialog();
      for wi in [winMetrics, winFocus, winFaces, winAbout]:
         dlg = self.dialogs[wi];
         # dlg.connect("destroy", gtkgoods.destroy_keep)
         dlg.connect("delete_event", gtkgoods.delete_keep)
         if wi != winAbout or self._app.snap:
            dlg.show();
            
   def snap(self, shellfile, basename):
      for wi in [winMetrics, winFocus, winFaces, winAbout]:
         dlg = self.dialogs[wi];
         gtkgoods.snapshot(shellfile, dlg, "%s-%s" % (basename, winNames[wi]));
      
   def show(self, winIndex):
      dlg = self.dialogs[winIndex];
      dlg.show();
      dlg.map();
      # kludge
      dlg.get_window()._raise();

   def showFontWins(self):
      for wi in [winAbout, winMetrics, winFaces, winFocus]:
         dlg = self.dialogs[wi];
         dlg.show();
         # kludge
         dlg.get_window()._raise();

   def hideFontWins(self):
      for wi in [winAbout, winMetrics, winFaces, winFocus]:
         dlg = self.dialogs[wi];
         dlg.hide();

   # Make a name base on tfm and pk file names
   def makename(self):
      # print "Font.name: _tfmfn=", self._tfmfn;
      # print "Font.name: _pkfn=", self._pkfn;
      tfmbase = os.path.basename(self._tfmfn);
      pkbase = os.path.basename(self._pkfn);
      pkpat = re.compile("^([^\.]+)\.([0-9]+)pk$");
      match = pkpat.match(pkbase);
      self._name = "(%s,%s)" % (tfmbase,pkbase);
      if match:
         fontname = match.group(1);
         fonttfm = fontname + ".tfm";
         # print "... matched!, fontname=%s, tfmbase=%s" % (fontname, tfmbase)
         if fonttfm == tfmbase:
            self._name = "%s@%s" % (fontname, match.group(2));
   def name(self):
      return self._name;
   # Build the Metrics dialog
   def metricsDialog(self):
      dlg = gtk.GtkWindow(title=("%s - Metrics" % self._name));
      dlg.set_geometry_hints(base_width=300, base_height=400,
                             min_width=300,  min_height=400,
                             max_width=gtkgoods.MaxScreenSize,
                             max_height=gtkgoods.MaxScreenSize);

      # Is there a shorter way for the next 3 lines?
      self.slists = [];
      for i in range(0,nLists):
         self.slists.append(None);

      lengths = self._tfm.lengths();
      #################################
      # Fixed word actual sizes - lists
      for eList in (eWidth, eHeight, eDepth, eItalic, eKern):
         n = lengths[nTFM[eList]];
         # title = dimFmtLabels[eList] % n;
         title = dimLabels[eList];
         l = ScrolledIList(title);
         tfmMethod = tfmMethods[eList];
         for i in xrange(0, n):
            v = tfmMethod(self._tfm, i);
            si = str(i);
            sv = "%.3f" % (tfm.fixedFactor * v);
            # print "si=%s, sv=%s" % (si, sv);
            l.sappend(sv);
         l.format();
         l.show();
         self.slists[eList] = l;
      #
      ##############
      # LigKern list
      l = self.ligkernList(lengths[nTFM[eLigKern]]);
      self.slists[eLigKern] = l;
      #
      ############
      # Exten list
      l = self.extenList(lengths[nTFM[eExten]]);
      l.show();
      self.slists[eExten] = l;
      #
      # ------------------- ##################
      fbdims = gtk.GtkFrame("Basic Dimensions");
      fbdims.set_border_width(6);
      hbox = gtk.GtkHBox(spacing=3);
      hbox.set_border_width(4);
      for i in (eWidth, eHeight, eDepth, eItalic):
         hbox.pack_start(self.slists[i], padding=3);
      hbox.show();
      fbdims.add(hbox);
      fbdims.show();
      # -------------------- ##############
      fcompos = gtk.GtkFrame("Compositions");
      fcompos.set_border_width(6);
      hbox = gtk.GtkHBox(spacing=3);
      hbox.set_border_width(4);
      for i in (eLigKern, eKern, eExten):
         slist = self.slists[i];
         rows = slist.clist.rows;
         if rows:
            hbox.pack_start(slist, padding=3);
      hbox.show();
      fcompos.add(hbox);
      fcompos.show();
      vbox = gtk.GtkVBox();
      vbox.pack_start(fbdims);
      vbox.pack_start(fcompos);
      vbox.show();
      dlg.add(vbox);
      return dlg;

   # Kern List
   def ligkernList(self, n):
      # The format of LigKern displayed row:
      #  [index] [nextchar] [L/K] [Lig-Char index / Kern Index] [Stop]
      #    nextchar: char-index char(if printable)
      #    [L/K]:    Ligature or Kerning
      titles = [str(n), "Own", "Next", "T", "i", "."];
      sw = ScrolledList(titles);
      l = sw.clist;
      sw.set_policy(GTK.POLICY_NEVER, GTK.POLICY_AUTOMATIC);
      if self._app != None:
         for bi in range(0, len(titles)):  # Change to buttons for tool-tips
            b = gtk.GtkButton(titles[bi]);
            b.show();
            l.set_column_widget(bi, b);
         self._app.setTip(l, "Ligature / Kerning - Programs");
         self._app.setTip(l.get_column_widget(0),
                          "Ligature / Kerning - Entry Index");
         self._app.setTip(l.get_column_widget(1),
                          "Ligature / Kerning - The first owner character " +
                          "having this entry as its " +
                          "Ligature/Kerning program start.\n" +
                          "A '+' is appended if there is more than one owner.");
         self._app.setTip(l.get_column_widget(2),
                          "Ligature / Kerning - (if) Next character");
         self._app.setTip(l.get_column_widget(3),
                          "L=Ligature or K=Kerning");
         self._app.setTip(l.get_column_widget(4),
                          "Index of kerning or ligature alternative character");
         self._app.setTip(l.get_column_widget(5),
                          "Ligature / Kerning -\n ';' = End of Program");

      sw.add(l);
      ffStyle = gtkgoods.getFFStyleFrom(l);
      for i in xrange(0, n):
         lk = self._tfm.ligkern(i);
         owners = self._tfm.ligkernowners(i);
         # print "i=", i, ", owners=", owners;
         ownerDisp = "";
         if len(owners) > 0:
            ownerDisp = goods.charDisplay(owners[0]);
            if len(owners) > 1:
               ownerDisp = ownerDisp + '+';
         nextChar = lk[tfm.ligkern_byte_next];
         ncDisp = goods.charDisplay(nextChar);
         # kernFlag = ((lk[tfm.ligkern_byte_op] & 0x80) != 0);
         kernFlag = tfm.kernflag(lk);
         T = "LK"[kernFlag];
         rem = lk[tfm.ligkern_byte_reminder];
         stopFlag = tfm.stopflag(lk);
         stop = " ;"[stopFlag];
         l.append([str(i), ownerDisp, ncDisp, T, "%3d" % rem, stop]);
	 l.set_row_style(i, ffStyle);
      for c in range(0, len(titles)):
         l.set_column_auto_resize(c, 1);
      l.show();
      sw.show();
      l.connect('event', self.cbLigKern);
      return sw;

   # Exten List List
   def extenList(self, n):
      titles = [str(n), "Top", "Mid", "Bot", "Rep"];
      sw = ScrolledList(titles);
      sw.set_policy(GTK.POLICY_NEVER, GTK.POLICY_AUTOMATIC);
      l = sw.clist;
      gtkgoods.clistSetFixedFont(l);

      if self._app != None:
         for bi in range(0, len(titles)):  # Change to buttons for tool-tips
            b = gtk.GtkButton(titles[bi]);
            b.show();
            l.set_column_widget(bi, b);
         self._app.setTip(l, "Ligature / Kerning - Programs");
         self._app.setTip(l.get_column_widget(0),
                          "Extensible Character - index");
         for (i,part) in ((1, "Top"), (2, "Middle"), (3, "Bottom"),
                          (4, "Repeat")):
            self._app.setTip(l.get_column_widget(i),
                             "Extensible Character - The %s component" % part);
      ffStyle = gtkgoods.getFFStyleFrom(l);
      row = ["", "", "", "", ""]; # 1+4
      (iFmt, iLen) = decFmtLen(n);
      for i in range(0, n):
         row[0] = iFmt % i;
         exten = self._tfm.exten(i);
         for bi in range(0,4):
            row[bi + 1] = goods.charDisplay(exten[bi]);
         if (exten[tfm.exten_mid] == 0): # No middle part
            row[tfm.exten_mid + 1] = "";
         l.append(row);
         l.set_row_style(i, ffStyle);
      for c in range(0, 5):
         l.set_column_auto_resize(c, 1);

      sw.add(l);
      l.show();
      l.connect('event', self.cbExten);
      sw.show();
      return sw;

   # Build the Faces dialog
   def facesDialog(self):
      dlg =  gtk.GtkWindow(title=("%s - Faces" % self._name));
      dlg.set_geometry_hints(min_width=500,  min_height=200,
                             max_width=gtkgoods.MaxScreenSize,
                             max_height=gtkgoods.MaxScreenSize,
                             base_width=720, base_height=480);
      dlg.set_default_size(720, 480);
      sw = self.sw = gtk.GtkScrolledWindow();
      sw.set_policy(GTK.POLICY_ALWAYS, GTK.POLICY_ALWAYS);
      canv = self.canvFaces = canvases.Faces(self);
      canv.show();
      sw.add(canv);
      sw.show();
      vbox = gtk.GtkVBox();
      vbox.pack_start(sw);
      hbox = gtk.GtkHBox();
      om = gtk.GtkOptionMenu();
      menu = gtk.GtkMenu();
      group = None;
      mi = gtk.GtkRadioMenuItem(group, "Natural Bitmaps");
      self.miNaturalBitmap = mi;
      mi.connect('event', self.cbFacesSize);
      group = mi;
      menu.append(mi);
      mi.show();
      mi = gtk.GtkRadioMenuItem(group, "Resize to Fit");
      self.miShrink2Fit = mi;
      mi.connect('event', self.cbFacesSize);
      menu.append(mi);
      mi.show();
      om.set_menu(menu);
      om.show();
      hbox.pack_start(om, expand=1, fill=0, padding=3);
      hbox.show();
      vbox.pack_start(hbox, expand=0, fill=0, padding=3);
      vbox.show();
      dlg.add(vbox);
      return dlg;

   # Build the textual general information about a font's files.
   def aboutDialog(self):
      dlg =  gtk.GtkWindow(title=("%s - About" % self._name));
      dlg.set_geometry_hints(base_width=300, base_height=200,
                             min_width=300,  min_height=100,
                             max_width=gtkgoods.MaxScreenSize,
                             max_height=gtkgoods.MaxScreenSize);
      sw = self.sw = gtk.GtkScrolledWindow();
      sw.set_policy(GTK.POLICY_ALWAYS, GTK.POLICY_ALWAYS);
      text = gtk.GtkText();
      gtkgoods.widgetSetFixedFont(text);
      text.set_line_wrap(0);
      sw.add(text);
      sw.show();
      text.delete_text(0, -1);
      lengths = self._tfm.lengths();
      tfmHeader = "";
      for (n,s) in [(tfm.lf, "lf"),
                    (tfm.lh, "lh"),
                    (tfm.bc, "bc"),
                    (tfm.ec, "ec"),
                    (tfm.nw, "nw"),
                    (tfm.nh, "nh"),
                    (tfm.nd, "nd"),
                    (tfm.ni, "ni"),
                    (tfm.nl, "nl"),
                    (tfm.nk, "nk"),
                    (tfm.ne, "ne"),
                    (tfm.np, "np")]:
         v = lengths[n];
         tfmHeader = tfmHeader + ("    %s = %3d\n" % (s, v));
         xHeader = "";
         for wi in range(2, lengths[tfm.lh]):
            w = self._tfm.header(wi);
            xw = "\n                     %08x" % w;
            xHeader = xHeader + xw;
            pkds = self._pk.designsize();
      content = (
'''Files:
  %s
  %s
TFM:
  Header:
%s
  Extra Header( ): \"%s\"
              (?): \"%s\"%s
  Design Size:     0x%x /(2^{20}) = %g
  Check Sum:       %u
PK:
  id:              %d
  comment:         \"%s\"
  Design Size:     0x%x /(2^{20}) = %g
  hppp:            %d
  vppp:            %d
  Check Sum:       %u
''' % (self._tfmfn, self._pkfn,
       tfmHeader,
       self._tfm.extraheader(), self._tfm.qextraheader(), xHeader,
       self._tfm.headdesignsize(), self._tfm.designsize(),
       self._tfm.checksum(),
       self._pk.id(),
       self._pk.comment(),
       pkds, pkds * tfm.fixedFactor,
       self._pk.hppp(),
       self._pk.vppp(),
       self._pk.checksum()
      ));

      text.insert_defaults(content);
      text.show();
      rect = gtkgoods.getTextRect(text.get_style().font, content, 1, 1);
      # print "aboutDialog: rect=", rect;
      text.set_usize(rect[0] + 24, rect[1] + 24);
      text.set_position(0);
      text.thaw();
      vbox = gtk.GtkVBox(spacing=4);
      vbox.pack_start(sw, padding=3);
      vbox.show();
      dlg.add(vbox);
      return dlg;

   def selectedChar(self):
      return self._selectedChar;

   def getSelection(self):
      return self._selectedChar;

   def select(self, c):
      self._selectedChar = c;
      info = self._tfm.charinfo(c);
      for (el, ei) in ((eWidth,  'width_index'),
                       (eHeight, 'height_index'),
                       (eDepth,  'depth_index'),
                       (eItalic, 'italic_index')):
         ri = info[ei];
         # print "el=", el, ", ei=", ei, ", ri=", ri;
         gtkgoods.clistSelectShowRow(self.slists[el].clist, ri);
      tag = info['tag'];
      reminder = info['reminder'];
      # print "tag=%d, reminder=%d" % (tag, reminder);
      if tag == tfm.lig_tag:
         gtkgoods.clistSelectShowRow(self.slists[eLigKern].clist, reminder);
      elif tag == tfm.ext_tag:
         gtkgoods.clistSelectShowRow(self.slists[eExten].clist, reminder);
      self.dialogs[winFocus].selectChar(c)
      self.canvFaces.drawSelect(c)


   # Callbacks:
   def cbLigKern(self, w, e):
      if e.type == GDK.BUTTON_RELEASE:
         gtk.idle_add(self.cbLigKernPost, w);

   def cbLigKernPost(self, w):
      sel = w.selection;
      if len(sel):
         lki = sel[0];
         lk = self._tfm.ligkern(lki);
         if tfm.kernflag(lk):
            rem = lk[tfm.ligkern_byte_reminder];
            gtkgoods.clistSelectShowRow(self.slists[eKern].clist, rem);
            self.dialogs[winFocus].setKernEntry(lki);

   def cbExten(self, w, e):
      if e.type == GDK.BUTTON_RELEASE:
         gtk.idle_add(self.cbExtenPost, w);

   def cbExtenPost(self, w):
      sel = w.selection;
      if len(sel):
         ei = sel[0];
         self.dialogs[winFocus].extenShow.showExten(ei);

   def cbFacesSize(self, w, e):
      # print "cbFacesSize, w=", w;
      if e.type == GDK.BUTTON_RELEASE:
         if w == self.miNaturalBitmap:
            self.sw.set_policy(GTK.POLICY_ALWAYS, GTK.POLICY_ALWAYS);
            self.canvFaces.draw(self._selectedChar);
         elif w == self.miShrink2Fit:
            self.sw.set_policy(GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC);
            self.canvFaces.draw2fit(self._selectedChar)
         # print "self.canvFaces: alloc=", self.canvFaces.get_allocation();
         # win = w.get_window();
         # print "win.cls=", win.__class__;
         # print "win.__dict__=", w.get_window().__class__.__dict__;
         # print "width=", win.width;

