/*********************************************************************/
/*  bibView: Administration of BibTeX-Databases                      */
/*           (Verwaltung von BibTeX-Literaturdatenbanken)            */
/*                                                                   */
/*  Module:  ComboBoP.h                                              */
/*                                                                   */
/*             - Combo Box Widget                                    */
/*               Text widget with selection list                     */
/*                                                                   */
/*  Author:  Holger Martin,  martinh@informatik.tu-muenchen.de       */
/*           Peter M. Urban, urban@informatik.tu-muenchen.de         */
/*                                                                   */
/*  History:                                                         */
/*    11.22.91  HM   created                                         */
/*                                                                   */
/*  Copyright 1991 Martin, Urban                                     */
/*    See ./Copyright for complete rights and liability information. */
/*                                                                   */
/*********************************************************************/


#ifndef ComboBoxP_h
#define ComboBoxP_h

#include "ComboBo.h"

#define XtCSelectMenu "SelectMenu"
#define XtCShowDotFiles "ShowDotFiles"
#define XtCBellLevel "BellLevel"
#define XtCName "Name"           /* NEU: Label fuer Eingabefeld */
#define XtCRcList "RcList"       /* NEU: LISTE */


typedef struct {
    /* resources */
    XtCallbackList      select_callback;
    String              select_menu;
    XtCallbackList      cancel_callback;
    Dimension           margin;
    int                 number_rows;
    Boolean             show_dot_files;
    int                 bell_level;
    String              name;        /* NEU */
    RcListNode          *rclist;     /* NEU */
 
    /* private data */
    Widget              viewport_widget;
    Widget              list_widget;
    Widget		filename_widget;
    Widget              select_widget;
    Widget              path_widget;
    Widget		cancel_widget;	
    Widget              name_widget;    /* NEU */
    Widget              shell_widget;
    String              *listList;
    char                currentDir[MAXPATHLEN];
    Boolean             watchingChanges;
    ComboBoxStruct nomination;
} ComboBoxPart;

typedef struct _ComboBoxRec {
    CorePart		core;
    ComboBoxPart	comboBox;
} ComboBoxRec;

typedef struct {
    XtPointer		extension;
} ComboBoxClassPart;

typedef struct _ComboBoxClassRec {
    CoreClassPart	        core_class;
    ComboBoxClassPart	comboBox_class;
} ComboBoxClassRec, *ComboBoxClass;

extern ComboBoxClassRec comboBoxClassRec;

#endif /* ComboBoxP_h */

