{$N-,V-,W-,G+}
Unit SMapi;

interface

Uses
  WinTypes,WinProcs,WObjects,Strings;

type
  { C equivalence }
  LHANDLE   = Longint;
  LPLHANDLE = ^LHandle;
  TFLAGS    = Longint;
  LPVOID    = Pointer;
const
	lhSessionNull: LHANDLE = 0;

type
  { Describes attachments }
  TMapiFileDesc = record
  	ulReserved  : Longint; { Reserved for future use. Must be 0. }
	  flFlags     : TFLAGS;  { Flags                               }
	  nPosition   : Longint; { Attachment position in message body }
	  lpszPathName: PChar;   { Full path name of attached file     }
	  lpszFileName: PChar;   { Original filename (optional)        }
	  lpFileType  : PChar;   { Attachment file type (reserved)     }
  end;
  PMapiFileDesc = ^TMapiFileDesc;
const
  { File attachment types to send }
 	MAPI_OLE				= $00000001;   { OLE attachment        }
 	MAPI_OLE_STATIC	= $00000002;   { Static OLE attachment }

type
  { Recipient information }
  TMapiRecipDesc = record
    ulReserved  : Longint; { Reserved for future use               }
    ulRecipClass: Longint; { Recipient class:                      }
                           { MAPI_TO, MAPI_CC, MAPI_BCC, MAPI_ORIG }
    lpszName    : PChar;   { Recipient name                        }
    lpszAddress : PChar;   { Recipient address (optional)          }
    ulEIDSize   : Longint; { Count in bytes of size of pEntryID    }
    lpEntryID   : Pointer; { System-specific recipient reference   }
  end;
  PMapiRecipDesc  = ^TMapiRecipDesc;
  PPMapiRecipDesc = ^PMapiRecipDesc;
const
  { Recipient types }
  MAPI_ORIG = 0;            { Recipient is message originator   }
  MAPI_TO   = 1;            { Recipient is a primary recipient  }
  MAPI_CC   = 2;            { Recipient is a copy recipient     }
  MAPI_BCC  = 3;            { Recipient is blind copy recipient }

type
  { MAPI message type }
  TMapiMessage = record
    ulReserved        : Longint;         { Reserved for future use (M.B. 0) }
    lpszSubject       : PChar;           { Message Subject                  }
    lpszNoteText      : PChar;           { Message Text                     }
    lpszMessageType   : PChar;           { Message Class                    }
    lpszDateReceived  : PChar;           { in YYYY/MM/DD HH:MM format       }
	  lpszConversationID: PChar;		       { conversation thread ID           }
    flFlags           : TFLAGS;          { unread,return receipt            }
    lpOriginator      : PMapiRecipDesc;  { Originator descriptor            }
    nRecipCount       : Longint;         { Number of recipients             }
    lpRecips          : PMapiRecipDesc;  { Recipient descriptors            }
    nFileCount        : Longint;         { # of file attachments            }
    lpFiles           : PMapiFileDesc;   { Attachment descriptors           }
  end;
  PMapiMessage   = ^TMapiMessage;
  PPMapiMessage = ^PMapiMessage;
const
  { Message status }
  MAPI_UNREAD            = $00000001;
  MAPI_RECEIPT_REQUESTED = $00000002;
  MAPI_SENT              = $00000004;

const
  MAPI_LOGON_UI        = $00000001; { Display logon UI }
  MAPI_NEW_SESSION     = $00000002; { Do not use default. }
  MAPI_DIALOG          = $00000008; { Display a send note UI }
  MAPI_UNREAD_ONLY     = $00000020; { Only unread messages }
  MAPI_ENVELOPE_ONLY   = $00000040; { Only header information }
  MAPI_PEEK            = $00000080; { Do not mark as read. }
  MAPI_GUARANTEE_FIFO  = $00000100;	{ use date order }
 	MAPI_BODY_AS_FILE    = $00000200;
  MAPI_AB_NOMODIFY     = $00000400;	{ Don't allow mods of AB entries }
 	MAPI_SUPPRESS_ATTACH = $00000800;	{ header + body, no files }
 	MAPI_FORCE_DOWNLOAD  = $00001000;	{ force download of new mail during MAPILogon }

{ Error codes }

  SUCCESS_SUCCESS                 = 0;
  MAPI_USER_ABORT                 = 1;
  MAPI_E_FAILURE                  = 2;
  MAPI_E_LOGIN_FAILURE            = 3;
  MAPI_E_DISK_FULL                = 4;
  MAPI_E_INSUFFICIENT_MEMORY      = 5;
  MAPI_E_ACCESS_DENIED            = 6;
  MAPI_E_TOO_MANY_SESSIONS        = 8;
  MAPI_E_TOO_MANY_FILES           = 9;
  MAPI_E_TOO_MANY_RECIPIENTS      = 10;
  MAPI_E_ATTACHMENT_NOT_FOUND     = 11;
  MAPI_E_ATTACHMENT_OPEN_FAILURE  = 12;
  MAPI_E_ATTACHMENT_WRITE_FAILURE = 13;
  MAPI_E_UNKNOWN_RECIPIENT        = 14;
  MAPI_E_BAD_RECIPTYPE            = 15;
  MAPI_E_NO_MESSAGES              = 16;
  MAPI_E_INVALID_MESSAGE          = 17;
  MAPI_E_TEXT_TOO_LARGE           = 18;
 	MAPI_E_INVALID_SESSION          = 19;
 	MAPI_E_TYPE_NOT_SUPPORTED       = 20;
 	MAPI_E_AMBIGUOUS_RECIPIENT      = 21;
  MAPI_E_MESSAGE_IN_USE           = 22;
  MAPI_E_NETWORK_FAILURE          = 23;
 	MAPI_E_INVALID_EDITFIELDS       = 24;
 	MAPI_E_INVALID_RECIPS           = 25;
 	MAPI_E_NOT_SUPPORTED            = 26;

Var
  LoadedMAPIDLL: boolean;

function LoadMAPI: boolean;
procedure UnloadMAPIDLL;

{ DLL Interface routines }

function MAPILogon(ulUIParam: Longint; lpszName,lpszPassword: PChar;
                   flFlags: TFlags; ulReserved: Longint;
                   lplhSession: LPHANDLE): Longint;

function MAPILogoff(lhSession: LHANDLE; ulUIParam: Longint; flFlags: TFlags;
                    ulReserved: Longint): Longint;

function MAPISendMail(lhSession: LHANDLE; ulUIParam: Longint;
                      lpMessage: PMapiMessage; flFlags: TFlags;
                      ulReserved: Longint): Longint;

function MAPISendDocuments(ulUIParam: Longint;
                           lpszDelimChar,lpszFilePaths,lpszFileNames: PChar;
                           ulReserved: Longint): Longint;

function MAPIFindNext(lhSession: LHANDLE; ulUIParam: Longint;
                      lpszMessageType,lpszSeedMessageID: PChar;
                      flFlags: TFlags; ulReserved: Longint;
                      lpszMessageID: PChar): Longint;

function MAPIReadMail(lhSession: LHANDLE; ulUIParam: Longint;
                      lpszMessageID: PChar; flFlags: TFlags;
                      ulReserved: Longint;
                      var lppMessageOut: PMapiMessage): Longint;

function MAPISaveMail(lhSession: LHANDLE; ulUIParam: Longint;
                      pMessage: PMapiMessage; flFlags: TFlags;
                      ulReserved: Longint; lpszMessageID: PChar): Longint;

function MAPIDeleteMail(lhSession: LHANDLE; ulUIParam: Longint;
                        lpszMessageID: PChar; flFlags: TFlags;
                        ulReserved: Longint): Longint;

function MAPIFreeBuffer(pv: Pointer): Longint;
							
function MAPIAddress(lhSession: LHANDLE; ulUIParam: Longint;
					           lpszCaption: PChar; nEditFields: Longint;
					           lpszLabels: PChar; nRecips: Longint;
					           lpRecips: PMapiRecipDesc; flFlags: TFlags;
                     ulReserved: Longint; lpnNewRecips: PLongint;
                     var lppNewRecips: PMapiRecipDesc): Longint;

function MAPIDetails(lhSession: LHANDLE; ulUIParam: Longint;
					           lpRecip: PMapiRecipDesc; flFlags: TFlags;
                     ulReserved: Longint): Longint;

function MAPIResolveName(lhSession: LHANDLE; ulUIParam: Longint;
					               lpszName: PChar; flFlags: TFlags; ulReserved: Longint;
                         var lppRecip: PMapiRecipDesc): Longint;


implementation

type

  TMAPILogon         = function(ulUIParam: Longint; lpszName,lpszPassword: PChar;
                         flFlags: TFlags; ulReserved: Longint;
                         lplhSession: LPHANDLE): Longint;
  TMAPILogoff        = function(lhSession: LHANDLE; ulUIParam: Longint;
                         flFlags: TFlags; ulReserved: Longint): Longint;
  TMAPISendMail      = function(lhSession: LHANDLE; ulUIParam: Longint;
                         lpMessage: PMapiMessage; flFlags: TFlags;
                         ulReserved: Longint): Longint;
  TMAPISendDocuments = function(ulUIParam: Longint;
                         lpszDelimChar,lpszFilePaths,lpszFileNames: PChar;
                         ulReserved: Longint): Longint;
  TMAPIFindNext      = function(lhSession: LHANDLE; ulUIParam: Longint;
                         lpszMessageType,lpszSeedMessageID: PChar;
                         flFlags: TFlags; ulReserved: Longint;
                         lpszMessageID: PChar): Longint;
  TMAPIReadMail      = function(lhSession: LHANDLE; ulUIParam: Longint;
                         lpszMessageID: PChar; flFlags: TFlags;
                         ulReserved: Longint;
                         lppMessageOut: PPMapiMessage): Longint;
  TMAPISaveMail      = function(lhSession: LHANDLE; ulUIParam: Longint;
                         pMessage: PMapiMessage; flFlags: TFlags;
                         ulReserved: Longint; lpszMessageID: PChar): Longint;
  TMAPIDeleteMail    = function(lhSession: LHANDLE; ulUIParam: Longint;
                         lpszMessageID: PChar; flFlags: TFlags;
                         ulReserved: Longint): Longint;
  TMAPIFreeBuffer    = function(pv: Pointer): Longint;							
  TMAPIAddress       = function(lhSession: LHANDLE; ulUIParam: Longint;
					               lpszCaption: PChar; nEditFields: Longint;
					               lpszLabels: PChar; nRecips: Longint;
					               lpRecips: PMapiRecipDesc; flFlags: TFlags;
                         ulReserved: Longint; lpnNewRecips: PLongint;
                         lppNewRecips: PPMapiRecipDesc): Longint;
  TMAPIDetails       = function(lhSession: LHANDLE; ulUIParam: Longint;
					               lpRecip: PMapiRecipDesc; flFlags: TFlags;
                         ulReserved: Longint): Longint;
  TMAPIResolveName   = function(lhSession: LHANDLE; ulUIParam: Longint;
					               lpszName: PChar; flFlags: TFlags; ulReserved: Longint;
                         lppRecip: PPMapiRecipDesc): Longint;

{ Routines }

var
  MAPIModule: THandle;
  TriedIt: boolean;

  FMAPILogon         : TFarProc;
  FMAPILogoff        : TFarProc;
  FMAPISendMail      : TFarProc;
  FMAPISendDocuments : TFarProc;
  FMAPIFindNext      : TFarProc;
  FMAPIReadMail      : TFarProc;
  FMAPISaveMail      : TFarProc;
  FMAPIDeleteMail    : TFarProc;
  FMAPIFreeBuffer    : TFarProc;
  FMAPIAddress       : TFarProc;
  FMAPIDetails       : TFarProc;
  FMAPIResolveName   : TFarProc;

function LoadMAPI: boolean;
const
  SEM_NoOpenFileErrorBox = $8000;
var
  PrevErrorMode: word;
begin
  LoadMAPI:=false;
  if LoadedMAPIDLL then
  begin
    LoadMAPI:=true; Exit;
  end else if TriedIt then Exit;

  PrevErrorMode:=SetErrorMode(SEM_NoOpenFileErrorBox);
  MAPIModule:=LoadLibrary('MAPI.DLL');
  SetErrorMode(PrevErrorMode);
  if MAPIModule<22 then MAPIModule:=0
  else begin
    {    Commented out to save data space
    FMAPILogon         := GetProcAddress(MAPIModule,'MAPILogon');
    FMAPILogoff        := GetProcAddress(MAPIModule,'MAPILogoff');
    FMAPISendDocuments := GetProcAddress(MAPIModule,'MAPISendDocuments');
    FMAPIFindNext      := GetProcAddress(MAPIModule,'MAPIFindNext');
    FMAPIReadMail      := GetProcAddress(MAPIModule,'MAPIReadMail');
    FMAPISaveMail      := GetProcAddress(MAPIModule,'MAPISaveMail');
    FMAPIDeleteMail    := GetProcAddress(MAPIModule,'MAPIDeleteMail');
    FMAPIFreeBuffer    := GetProcAddress(MAPIModule,'MAPIFreeBuffer');
    FMAPIAddress       := GetProcAddress(MAPIModule,'MAPIAddress');
    FMAPIDetails       := GetProcAddress(MAPIModule,'MAPIDetails');
    FMAPIResolveName   := GetProcAddress(MAPIModule,'MAPIResolveName');
    }
    FMAPISendMail      := GetProcAddress(MAPIModule,'MAPISendMail');
    LoadMAPI:=true;
    LoadedMAPIDLL:=true;
  end;
  TriedIt:=true;
end;                     { LoadMAPI }

function MAPILogon(ulUIParam: Longint; lpszName,lpszPassword: PChar;
                   flFlags: TFlags; ulReserved: Longint;
                   lplhSession: LPHANDLE): Longint;
begin
  if LoadMAPI and (FMAPILogon<>Nil) then
    MAPILogon:=TMAPILogon(FMAPILogon)(ulUIParam,lpszName,lpszPassword,flFlags,
                         ulReserved,lplhSession)
  else MAPILogon:=MAPI_E_FAILURE;
end;

function MAPILogoff(lhSession: LHANDLE; ulUIParam: Longint; flFlags: TFlags;
                    ulReserved: Longint): Longint;
begin
  if LoadMAPI and (FMAPILogoff<>Nil) then
    MAPILogoff:=TMAPILogoff(FMAPILogoff)(lhSession,ulUIParam,flFlags,ulReserved)
  else MAPILogoff:=MAPI_E_FAILURE;
end;

function MAPISendMail(lhSession: LHANDLE; ulUIParam: Longint;
                      lpMessage: PMapiMessage; flFlags: TFlags;
                      ulReserved: Longint): Longint;
begin
  if LoadMAPI and (FMAPISendMail<>Nil) then
    MAPISendMail:=TMAPISendMail(FMAPISendMail)(lhSession,ulUIParam,
                      lpMessage,flFlags,ulReserved)
  else MAPISendMail:=MAPI_E_FAILURE;
end;

function MAPISendDocuments(ulUIParam: Longint;
                           lpszDelimChar,lpszFilePaths,lpszFileNames: PChar;
                           ulReserved: Longint): Longint;
begin
  if LoadMAPI and (FMAPISendDocuments<>Nil) then
    MAPISendDocuments:=TMAPISendDocuments(FMAPISendDocuments)(ulUIParam,
                           lpszDelimChar,lpszFilePaths,lpszFileNames,
                           ulReserved)
  else MAPISendDocuments:=MAPI_E_FAILURE;
end;

function MAPIFindNext(lhSession: LHANDLE; ulUIParam: Longint;
                      lpszMessageType,lpszSeedMessageID: PChar;
                      flFlags: TFlags; ulReserved: Longint;
                      lpszMessageID: PChar): Longint;
begin
  if LoadMAPI and (FMAPIFindNext<>Nil) then
    MAPIFindNext:=TMAPIFindNext(FMAPIFindNext)(lhSession,ulUIParam,
                      lpszMessageType,lpszSeedMessageID,
                      flFlags,ulReserved,lpszMessageID)
  else MAPIFindNext:=MAPI_E_FAILURE;
end;

function MAPIReadMail(lhSession: LHANDLE; ulUIParam: Longint;
                      lpszMessageID: PChar; flFlags: TFlags;
                      ulReserved: Longint;
                      var lppMessageOut: PMapiMessage): Longint;
begin
  if LoadMAPI and (FMAPIReadMail<>Nil) then
    MAPIReadMail:=TMAPIReadMail(FMAPIReadMail)(lhSession,ulUIParam,
                      lpszMessageID,flFlags,ulReserved,@lppMessageOut)
  else MAPIReadMail:=MAPI_E_FAILURE;
end;

function MAPISaveMail(lhSession: LHANDLE; ulUIParam: Longint;
                      pMessage: PMapiMessage; flFlags: TFlags;
                      ulReserved: Longint; lpszMessageID: PChar): Longint;
begin
  if LoadMAPI and (FMAPISaveMail<>Nil) then
    MAPISaveMail:=TMAPISaveMail(FMAPISaveMail)(lhSession,ulUIParam,
                      pMessage,flFlags,ulReserved,lpszMessageID)
  else MAPISaveMail:=MAPI_E_FAILURE;
end;

function MAPIDeleteMail(lhSession: LHANDLE; ulUIParam: Longint;
                        lpszMessageID: PChar; flFlags: TFlags;
                        ulReserved: Longint): Longint;
begin
  if LoadMAPI and (FMAPIDeleteMail<>Nil) then
    MAPIDeleteMail:=TMAPIDeleteMail(FMAPIDeleteMail)(lhSession,ulUIParam,
                        lpszMessageID,flFlags,ulReserved)
  else MAPIDeleteMail:=MAPI_E_FAILURE;
end;

function MAPIFreeBuffer(pv: Pointer): Longint;
begin
  if LoadMAPI and (FMAPIFreeBuffer<>Nil) then
    MAPIFreeBuffer:=TMAPIFreeBuffer(FMAPIFreeBuffer)(pv)
  else MAPIFreeBuffer:=MAPI_E_FAILURE;
end;

function MAPIAddress(lhSession: LHANDLE; ulUIParam: Longint;
					           lpszCaption: PChar; nEditFields: Longint;
					           lpszLabels: PChar; nRecips: Longint;
					           lpRecips: PMapiRecipDesc; flFlags: TFlags;
                     ulReserved: Longint; lpnNewRecips: PLongint;
                     var lppNewRecips: PMapiRecipDesc): Longint;
begin
  if LoadMAPI and (FMAPIAddress<>Nil) then
    MAPIAddress:=TMAPIAddress(FMAPIAddress)(lhSession,ulUIParam,
					           lpszCaption,nEditFields,lpszLabels,nRecips,
					           lpRecips,flFlags,ulReserved,lpnNewRecips,@lppNewRecips)
  else MAPIAddress:=MAPI_E_FAILURE;
end;

function MAPIDetails(lhSession: LHANDLE; ulUIParam: Longint;
					           lpRecip: PMapiRecipDesc; flFlags: TFlags;
                     ulReserved: Longint): Longint;
begin
  if LoadMAPI and (FMAPIDetails<>Nil) then
    MAPIDetails:=TMAPIDetails(FMAPIDetails)(lhSession,ulUIParam,
					           lpRecip,flFlags,ulReserved)
  else MAPIDetails:=MAPI_E_FAILURE;
end;

function MAPIResolveName(lhSession: LHANDLE; ulUIParam: Longint;
					               lpszName: PChar; flFlags: TFlags; ulReserved: Longint;
                         var lppRecip: PMapiRecipDesc): Longint;
begin
  if LoadMAPI and (FMAPIResolveName<>Nil) then
    MAPIResolveName:=TMAPIResolveName(FMAPIResolveName)(lhSession,ulUIParam,
					               lpszName,flFlags,ulReserved,@lppRecip)
  else MAPIResolveName:=MAPI_E_FAILURE;
end;

var
  OldExitProc: Pointer;

{$F+}
procedure UnloadMAPIDll;
begin
  ExitProc:=OldExitProc;
  if MAPIModule<>0 then FreeLibrary(MAPIModule);
  LoadedMAPIDLL:=false; MAPIModule:=0; TriedIt:=false;
end;
{$F-}

begin
  MAPIModule:=0; TriedIt:=false; LoadedMAPIDLL:=false;
  FMAPILogon         :=Nil; FMAPILogoff        :=Nil; FMAPISendMail      :=Nil;
  FMAPISendDocuments :=Nil; FMAPIFindNext      :=Nil; FMAPIReadMail      :=Nil;
  FMAPISaveMail      :=Nil; FMAPIDeleteMail    :=Nil; FMAPIFreeBuffer    :=Nil;
  FMAPIAddress       :=Nil; FMAPIDetails       :=Nil; FMAPIResolveName   :=Nil;

  OldExitProc:=ExitProc; ExitProc:=@UnloadMAPIDLL;
end.

