{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibinit2;

Interface

Uses
{$IFDEF WINDOWS}
  wobjects, wbibdisp,
{$ELSE}
  bibwindo, objects, bibdisp,
{$ENDIF}
  bibstrg, bibvars, bibutil, rc_strng;

Type
  ColorScrType = (autoColor,NoColor,YesColor);

procedure ShortWordsConfig(var cfg: text);
procedure FieldsConfig(var cfg: text);

procedure FlistMenuConfig(Var menu: FlistMenuType; Var FlistNum: byte;
                          Var MenuStrings: MenuStringType;
                          Var fchars: string; var cfg: text);
procedure RegistersConfig(var cfg: text);
procedure EntryConfig(var cfg: text; EditFieldsDef: byte; var HighField: integer);

{$IFNDEF WINDOWS}
procedure ColorsConfig(var cfg: text; var ColorScr: ColorScrType);
{$ENDIF}

Implementation


procedure GetRidOfComment(var line: string);
var
  tmp: Pstring;
begin
  New(tmp);
  tmp^:=line; UnTabify(tmp^); ChrDelL(tmp^,' ');
  if (tmp^<>'') and (tmp^[1] in CommentSet) then line:='';
  Dispose(tmp);
end;

procedure ShortWordsConfig(var cfg: text);
var
  line,tmp: string;
  nbr,i: integer;
  Index: byte;
begin
  readln(cfg,line); nbr:=1;
  while (not eof(cfg)) and (nbr>0) do
  begin
    UnTabify(line); GetRidOfComment(line); StrLwr(line);
    nbr:=1; i:=1; Index:=0;
    while (i<=length(line)) and (nbr>0) do
    begin
      if line[i]='\' then inc(i)
      else if line[i]=lbrace then inc(nbr)
      else if line[i]=rbrace then dec(nbr);
      if nbr=0 then Index:=i
      else inc(i);
    end;
    if index>0 then
    begin
      nbr:=0; line[0]:=Chr(index-1);
    end;
    index:=1;
    repeat
      tmp:=''; WrdToken(tmp,line,' ,;:.',index);
      if (tmp<>'') and (Narticles<MaxArticles) then
      begin
        inc(Narticles); Articles[Narticles]:=NewStr(tmp);
      end;
    until (tmp='') or (index=0);
    readln(cfg,line);
  end;    
end;                                 { ShortWordsConfig }

procedure FieldsConfig(var cfg: text);
var
  i,j,iaux,nbr: integer;
  Ind: byte;
  tmp,line,fname: string;
begin                                 { FieldsConfig }
  readln(cfg,line); nbr:=1;
  while (not eof(cfg)) and (nbr>0) do
  begin
    GetRidOfComment(line);
    ChrDelL(line,' ');
    nbr:=nbr+ChrQty(line,lbrace)-ChrQty(line,rbrace);
    iaux:=Pos(lbrace,line);
    if iaux<1 then
    begin
      fname:=line; line:=''; ChrDel(fname,rbrace);
    end else
    begin
      PStrCopy(fname,line,1,iaux-1); Delete(line,1,iaux);
      iaux:=Pos(rbrace,line);
      if iaux>1 then PStrCopy(line,line,1,iaux-1)
      else line:='';
    end;
    ChrDelL(fname,' '); ChrDelR(fname,' '); ChrDelL(line,' ');
    if (fname<>'') then
    begin
      iaux:=fieldlast+1;
      for i:=1 to fieldlast do if StrCmpI(fname,typefield^[i],1,1,255)=0 then iaux:=i;
      if (iaux<=maxfield) then
      begin
        typefield^[iaux]:=fname; StrLwr(TypeField^[iaux]);
      end;
      if iaux>fieldlast then fieldlast:=imin(iaux,maxfield);
      Ind:=1; fname:=''; WrdToken(fname,line,',;',Ind);
      while fname<>'' do
      begin
        ChrDelL(fname,' '); ChrDelR(fname,' '); tmp:=fname; StrLwr(tmp);
        with FieldParams^[iaux] do
        begin
          Capitalize :=Capitalize  or (Pos('cap',tmp)=1);
          Numeric    :=Numeric     or (Pos('num',tmp)=1);
          Authorlike :=Authorlike  or (Pos('author',tmp)=1);
          ProtectCase:=ProtectCase or (Pos('protectcase',tmp)=1);
          ProtectCap :=ProtectCap  or (Pos('protectcap',tmp)=1);
          if Pos('alt',tmp)=1 then
          begin
            i:=Pos('=',fname); j:=Pos(' ',fname);
            if (j>0) and ((i=0) or (j<i)) then i:=j;
            if i>0 then
            begin
              Delete(fname,1,i);
              while (fname<>'') and (fname[1] in [' ','=']) do delete(fname,1,1);
            end else fname:='';
            if (fname<>'') and (fname[1]='"') and (fname[length(fname)]='"')
              then fname:=Copy(fname,2,length(fname)-2);
            ChrDelL(fname,' '); ChrDelR(fname,' ');
            if fname<>'' then AltName:=NewStr(fname);
          end;
        end;
        if Ind=0 then fname:='' else WrdToken(fname,line,',;',Ind);
      end;
    end;
    readln(cfg,line);
  end;
  typefield^[StringIndex]:=StringFieldName;
  StrLwr(typefield^[StringIndex]);
end;                                  { FieldsConfig }

procedure FlistMenuConfig(Var menu: FlistMenuType; Var FlistNum: byte;
                          Var MenuStrings: MenuStringType;
                          Var fchars: string; var cfg: text);
var
  line,flist,tmp: string;
  i,nbr: integer;
  Index,Ind2: Byte;
  ok: Boolean;
  mnustr: ItemStringType;
begin                                 { FlistMenuConfig }
  fchars:='';
  FlistNum:=0;
  readln(cfg,line); nbr:=1;
  while (not eof(cfg)) and (nbr>0) do
  begin
    GetRidOfComment(line);
    ChrDelR(line,' '); ChrDelL(line,' ');
    nbr:=nbr+ChrQty(line,lbrace)-ChrQty(line,rbrace);
    ChrDel(line,rbrace);
    index:=0;
    WrdToken(flist,line,Concat('", ',lbrace),Index); ChrDel(flist,' ');
    if (flist<>'') and (Flistnum<MaxUserMenuItems) then
    begin
      Inc(Flistnum);
      menu[Flistnum,0]:=0;
      MnuStr:='';
      StrLwr(flist);
      Ind2:=0;
      WrdToken(tmp,flist,'+',Ind2);
      while tmp<>'' do
      begin
        ok:=false;
        i:=0;
        if tmp='_name' then
        begin
          Inc(menu[Flistnum,0]); ok:=true;
          menu[Flistnum,menu[Flistnum,0]]:=0;
        end;
        while (not ok) and (i<fieldlast) do
        begin
          inc(i);
          if tmp=typefield^[i] then
          begin
            Inc(menu[Flistnum,0]); ok:=true;
            menu[Flistnum,menu[Flistnum,0]]:=i;
          end;
        end;
        if not ok then FatalErrorRC(Str_MenuSpecError,tmp);
        if Ind2=0 then tmp:=''
        else WrdToken(tmp,flist,'+',Ind2);
      end;
      WrdToken(tmp,line,Concat('"',lbrace,rbrace),Index);
      if tmp<>'' then MnuStr:=tmp;
      ChrDelR(MnuStr,' '); ChrDelL(MnuStr,' ');
      WrdToken(tmp,line,Concat('''",; ',rbrace),Index);
      ChrDel(tmp,' ');
      if tmp<>'' then fchars:=Concat(fchars,tmp[1])
      else if MnuStr<>'' then
          fchars:=Concat(fchars,MnuStr[1])
      else fchars:=Concat(fchars,flist[1]);
      MenuStrings[FListnum]:=NewStr(MnuStr);
    end;
    readln(cfg,line);
  end;
end;                                 { FlistMenuConfig }

procedure RegistersConfig(var cfg: text);
var
  line,memline: string;
  memchr: char;
  i: integer;
  Finish, withquote: boolean;
begin                                 { RegistersConfig }
  line:='';
  repeat
    readln(cfg,line);
    GetRidOfComment(line);
    Untabify(line);  ChrDelL(line,' ');
    while (not eof(cfg)) and (line='') do
    begin
      readln(cfg,line);
      Untabify(line); GetRidOfComment(line);
      ChrDelL(line,' '); 
    end;
    if eof(cfg) or (Pos(rbrace,line)=1) then Exit;
    
    ChrDelR(line,' ');   
    memchr:=UpCase(line[1]); Delete(line,1,1); ChrDelL(line,' ');
    if (line<>'') and (line[1]='=') then
    begin
      Delete(line,1,1);  ChrDelL(line,' ');
    end;
    memline:=''; Finish:=false;
    i:=Pos('"',line);
    if i<>1 then     { No double quotes }
    begin
      if line<>'' then
      begin
        i:=2;
        while (i<=length(line)) do
          if (line[i]=' ') and (line[i-1]=' ') then delete(line,i,1)
          else inc(i);
        memline:=line;
      end;
    end else                           { With double quotes }
    begin
      Delete(line,1,i); ChrDelL(line,' ');
      repeat
        i:=1;
        while i<=length(line) do
        begin
          if (i<length(line)) and (line[i]='"') and (line[i+1]='"') then
            Delete(line,i,1)
          else if (line[i]='"') and ((i=length(line)) or (line[i+1]=' ')) then
          begin
            line[0]:=Chr(i-1); Finish:=true;
          end;
          inc(i);
        end;
        ChrDelR(line,' ');
        i:=2;
        while (i<=length(line)) do
          if (line[i]=' ') and (line[i-1]=' ') then delete(line,i,1)
          else inc(i);
        if memline='' then memline:=line
        else memline:=memline+' '+line;
        if not (eof(cfg) or finish) then
        begin
          readln(cfg,line);  Untabify(line);
          ChrDelR(line,' '); ChrDelL(line,' ');
        end;
      until finish or eof(cfg);
    end;
    if (memline<>'') and (memchr in ['0'..'9','A'..'Z']) then
    begin
      ReEscape(memline,lbrace+rbrace);
      if memchr in ['A'..'Z'] then
        PushBufferStack(memline[0],256,MemoryMode,
                        MemoryPos+Ord(memchr)-Ord('A'))
      else if memchr in ['0'..'9'] then
        PushBufferStack(memline[0],256,MemoryMode,
                        MemoryPos+Ord(memchr)-Ord('0')+26);
    end;
    line:='';
  until eof(cfg) or (Pos(rbrace,line)<>0);
end;                                  { RegistersConfig }
 
procedure EntryConfig(var cfg: text; EditFieldsDef: byte; var HighField: integer);
var
  line,tmp,tmp1,tmp2: string;
  brace,IsDef,IsIgnored: boolean;
  index,ind2,ind3,i: byte;
  fact: ShortInt;
begin                                  { EntryConfig }
  readln(cfg,line);    GetRidOfComment(line);
  ChrDel(line,' ');
  while (not eof(cfg)) and (Pos(rbrace,line)<>1) do
  begin
    StrLwr(line);
    if (line<>'') and (NumberOfTypes<maxfield) then
    begin
      brace:=(Pos(lbrace,line)>0);
      if brace then
      begin
        PStrCopy(tmp,line,Pos(lbrace,line)+1,255);
        StrCut(line,Pos(lbrace,line)-1);
      end;
      index:=0;
      for i:=1 to NumberOfTypes do if line=TypeEntry^[i] then index:=i;
      if index=0 then
      begin
        NumberOfTypes:=NumberOfTypes+1;
        TypeEntry^[NumberOfTypes]:=line;
        index:=NumberOfTypes;
      end;
      if brace then
      begin
        required^[index,0]:=0;
        fact:=1; IsIgnored:=false;
        repeat
          ind2:=1;
          brace:=(Pos(rbrace,tmp)>0);
          if brace then StrCut(tmp,Pos(rbrace,tmp)-1);
          while ind2<>0 do
          begin
            WrdToken(tmp1,tmp,' ,',ind2); IsDef:=false;
            if tmp1<>'' then
            begin
              StrLwr(tmp1);
              if Pos('<<',tmp1)=1 then IsIgnored:=true
              else if tmp1[1]='<' then fact:=-1;
              tmp2:=tmp1; ChrDel(tmp2,'<'); ChrDel(tmp2,'>');
              if (tmp2<>'') and (tmp2[length(tmp2)]='*') then
              begin
                IsDef:=true;
                Delete(tmp2,length(tmp2),1);
              end;
              ind3:=0;
              for i:=1 to fieldlast do if tmp2=typefield^[i] then ind3:=i;
              if ind3=0 then FatalErrorRC(Str_EntryTypeSpecError,tmp2);
              if Ind3>HighField then HighField:=Ind3;
              if IsDef and (EditFieldsDef=5) then
                EditFields^[NumberOfTypes]:=EditFields^[NumberOfTypes]+Chr(ind3);
              if (not IsIgnored) and (ind3>0) and (required^[index,0]<maxfield+1) then
              begin
                inc(required^[index,0]);
                required^[index,required^[index,0]]:=ind3;
                if fact=-1 then required^[index,required^[index,0]]:=
                  -required^[index,required^[index,0]];
              end;
              if Pos('>>',tmp1)>0 then IsIgnored:=false
              else if Pos('>',tmp1)>0 then fact:=1;
            end;
          end;
          if (not brace) and (not eof(cfg)) then readln(cfg,tmp);
        until (eof(cfg)) or brace;
      end;
    end;
    readln(cfg,line); ChrDel(line,' ');
    if (line<>'') and (line[1] in CommentSet) then line:='';
  end;
  StringTypeInd:=NumberOfTypes+1;
  TypeEntry^[StringTypeInd]:=StringTypeName;
  required^[StringTypeInd,0]:=0;
  PreambleTypeInd:=NumberOfTypes+2;
  TypeEntry^[PreambleTypeInd]:=PreambleTypeName;
  required^[PreambleTypeInd,0]:=0;
end;                     { EntryConfig }

{$IFNDEF WINDOWS}
procedure ColorsConfig(var cfg: text; var ColorScr: ColorScrType);
var
  index,NumIndex,i,att: byte;
  nbr,icode: integer;
  line,tmp,tmp1,tmp2,TokenStr: string;
  notparam: boolean;
  attrib: array[1..20] of Byte;
begin                                   { ColorsConfig }
  TokenStr:=lbrace+rbrace;
  nbr:=1;
  repeat
    line:='';
    readln(cfg,line); GetRidOfComment(line);
    StrLwr(line); ChrDelL(line,' ');
    nbr:=nbr+ChrQty(line,lbrace)-ChrQty(line,rbrace);
    if (length(line)>0) and IsAlpha(line[1]) then
    begin
      index:=1; tmp:=''; tmp1:='';
      WrdToken(tmp,line,TokenStr,index); ChrDel(tmp,' ');
      if tmp='monochrome' then ColorScr:=NoColor
      else if (tmp='color') or (tmp='colour') then ColorScr:=YesColor
      else if index<>0 then
        WrdToken(tmp1,line,TokenStr,index);
      if (tmp1<>'') and (ColorScr<>NoColor) then
      begin
        index:=1; NumIndex:=0;
        repeat
          repeat
            WrdToken(tmp2,tmp1,lbrace+rbrace+',;. ()<>[]',Index);
          until (tmp2='') or (Index=0) or (tmp2<>'on');
          if tmp2<>'' then
          begin
            Val(tmp2,att,icode);
            if icode>0 then
            begin
              att:=16;
              for i:=0 to 15 do if tmp2=Colors[i] then att:=i;
              if att<16 then icode:=0;
            end;
            if icode=0 then
            begin
              Inc(NumIndex); attrib[NumIndex]:=att;
            end;
          end;
        until (Index=0) or (tmp2='');
        if tmp='topmenu' then
        begin
          if NumIndex>1 then TopMenuRev:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then TopMenuNorm:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then TopMenuBright:=Attr(attrib[5],attrib[6]);
        end else if tmp='message' then
        begin
          if NumIndex>1 then MessageNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then MessageRev:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then MessageBright:=Attr(attrib[5],attrib[6]);
        end else if tmp='error' then
        begin
          if NumIndex>1 then ErrorNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then ErrorRev:=Attr(attrib[3],attrib[4]);
        end else if tmp='list' then
        begin
          if NumIndex>1 then ListNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then ListRev:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then ListBright:=Attr(attrib[5],attrib[6]);
          if NumIndex>7 then CScrBarFinsert:=Attr(attrib[7],attrib[8]);
        end else if tmp='dialog' then
        begin
          if NumIndex>1 then DialogNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then DialogRev:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then DialogBright:=Attr(attrib[5],attrib[6]);
        end else if tmp='menu' then
        begin
          if NumIndex>1 then MenuNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then MenuRev:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then MenuBright:=Attr(attrib[5],attrib[6]);
          MenuBorder:=MenuNorm;
        end else if tmp='edit' then
        begin
          if NumIndex>1 then EditNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then EditRev:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then EditBright:=Attr(attrib[5],attrib[6]);
          if NumIndex>7 then CScrBarEdField:=Attr(attrib[7],attrib[8]);
        end else if tmp='entry' then
        begin
          if NumIndex>1 then
          begin
            EntryNorm:=Attr(attrib[1],attrib[2]);
            EntryRev:=Attr(attrib[2],attrib[1]);
          end;
          if NumIndex>3 then EntryBright:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then EditBorder:=Attr(attrib[5],attrib[6]);
          if NumIndex>7 then CScrBarEntry:=Attr(attrib[7],attrib[8]);
          if NumIndex>9 then CScrBarEdit:=Attr(attrib[9],attrib[10]);
        end else if tmp='pattern' then
        begin
          if NumIndex>1 then PatternNorm:=Attr(attrib[1],attrib[2]);
          if NumIndex>3 then PatternBorder:=Attr(attrib[3],attrib[4]);
          if NumIndex>5 then CScrBarPatt:=Attr(attrib[5],attrib[6]);
        end else if Copy(tmp,1,5)='color' then   { Special colors }
        begin
          Delete(tmp,1,5); Val(tmp,i,icode);
          if (icode=0) and (i>2) and (i<=16) then
            SpecialColors[i]:=Attr(attrib[1],attrib[2]);
        end;
      end; 
    end;
  until (eof(cfg)) or (nbr<1);
  SpecialColors[1]:=EntryNorm; SpecialColors[2]:=EntryBright;
end;                                  { ColorsConfig }
{$ENDIF}
 
end.
