# Antora CLI

The command line interface (CLI) for Antora.
This package provides the `antora` command (i.e., bin script) to run Antora.
It does not include the site generator, which must be installed separately.

[Antora](https://antora.org) is a modular static site generator designed for creating documentation sites from AsciiDoc documents.
Its site generator aggregates documents from versioned content repositories and processes them using [Asciidoctor](https://asciidoctor.org).

To run Antora, you need both the CLI and a site generator.
Once these packages are installed, you can use the `antora` command to generate your site.

## How to Install

Let’s start by installing the CLI.

```sh
npm i -g @antora/cli
```

This package adds the `antora` command to your PATH.
You can check by running:

```sh
antora -v
```

Next, install a site generator.
The site generator provided by Antora will be sufficient for most users.

```sh
npm i -g @antora/site-generator
```

The `antora` command (specifically the implicit `generate` subcommand) will look for this package by default.

## How to Use

To run Antora, you’ll need a playbook file and at least one content (source) repository.
Consult the [quickstart](https://docs.antora.org/antora/latest/install-and-run-quickstart/) to find an example.

Once you have your content sources set up, point the `antora` command at your playbook file:

```sh
antora antora-playbook.yml
```

The `antora` command will output the generated site to the _build/site_ folder by default.

## Copyright and License

Copyright (C) 2017-present [OpenDevise Inc.](https://opendevise.com) and the [Antora Project](https://antora.org).

Use of this software is granted under the terms of the [Mozilla Public License Version 2.0](https://www.mozilla.org/en-US/MPL/2.0/) (MPL-2.0).
