/*
 * Copyright 2016 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
 
#ifndef SKSL_ASTNODE
#define SKSL_ASTNODE

#include <memory>
#include <string>

namespace SkSL {

/**
 * Represents a node in the abstract syntax tree (AST). The AST is based directly on the parse tree;
 * it is a parsed-but-not-yet-analyzed version of the program.
 */
struct ASTNode {
    virtual ~ASTNode() {}
     
    virtual std::string description() const = 0;
};

} // namespace

#endif
