.\" $XTermId: uxterm.man,v 1.3 2007/12/30 15:55:21 tom Exp $
.\"
.\" Copyright 2001, 2004 Branden Robinson
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" SOFTWARE IN THE PUBLIC INTEREST, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.TH uxterm 1 "2004-12-19" "Debian Project"
.SH NAME
uxterm \- X terminal emulator for Unicode (UTF-8) environments
.SH SYNOPSIS
.B uxterm
[
.I xterm-options
]
.SH DESCRIPTION
.B uxterm
is a wrapper around the
.BR xterm(1)
program that invokes the latter program with the \(oqUXTerm\(cq X resource
class set.
All arguments to
.B uxterm
are passed to
.B xterm
without processing; the
.B \-class
and
.B \-u8
options should not be specified because they are used by the wrapper.
See the
.B xterm
manual page for more information on
.IR xterm-options .
.PP
The environment's locale settings (see \(lqENVIRONMENT\(rq below) are
used to discern the locale's character set.
If no current locale can be determined, the locale \(oqen_US\(cq (the
English language as used in the territory of the United States) is assumed.
The
.BR locale(1)
utility is used to determine whether the system supports the selected
locale.
If it does not,
.B uxterm
will exit with an error and report the output of
.BR locale .
.PP
.B Note: uxterm
may produce unexpected results if the current locale is set to one in which
the UTF-8 character encoding is not supported, or if fonts using the ISO
10646-1 character set are not available.
In the Debian system, the \(oqxfonts\-base\(cq package provides the fonts
that
.B uxterm
uses by default.
To change the fonts
.B uxterm
uses, edit the
.I __apploaddir__/UXTerm
file.
.PP
A similar wrapper,
.BR koi8rxterm(1),
is available for KOI8-R environments.
.SH ENVIRONMENT
.TP
.B LC_ALL\fR, \fBLC_CTYPE\fR, \fBLANG
The values of these variables are checked, in order, to determine the
character set used by the current locale.
.SH AUTHOR
Thomas Dickey
.SH "SEE ALSO"
.BR locale(1),
.BR locale(7),
.BR koi8rxterm(1),
.BR xterm(1)
