/*
 * This file is part of MPlayer.
 *
 * MPlayer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MPlayer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with MPlayer; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MPLAYER_WSKEYS_H
#define MPLAYER_WSKEYS_H

#define wsUp            0x52 + 256
#define wsDown          0x54 + 256
#define wsLeft          0x51 + 256
#define wsRight         0x53 + 256
#define wsLeftCtrl      0xe3 + 256
#define wsRightCtrl     0xe4 + 256
#define wsLeftAlt       0xe9 + 256
#define wsRightAlt      0x7e + 256
#define wsLeftShift     0xe1 + 256
#define wsRightShift    0xe2 + 256
#define wsEnter         0x0d + 256
#define wsBackSpace     0x08 + 256
#define wsCapsLock      0xe5 + 256
#define wsTab           0x09 + 256
#define wsF1            0xbe + 256
#define wsF2            0xbf + 256
#define wsF3            0xc0 + 256
#define wsF4            0xc1 + 256
#define wsF5            0xc2 + 256
#define wsF6            0xc3 + 256
#define wsF7            0xc4 + 256
#define wsF8            0xc5 + 256
#define wsF9            0xc6 + 256
#define wsF10           0xc7 + 256
#define wsF11           0xc8 + 256
#define wsF12           0xc9 + 256
#define wsInsert        0x63 + 256
#define wsDelete        0xff + 256
#define wsHome          0x50 + 256
#define wsEnd           0x57 + 256
#define wsPageUp        0x55 + 256
#define wsPageDown      0x56 + 256
#define wsNumLock       0x7f + 256
#define wsEscape        0x1b + 256
#define wsGrayEnter     0x8d + 256
#define wsGrayPlus      0xab + 256
#define wsGrayMinus     0xad + 256
#define wsGrayMul       0xaa + 256
#define wsGrayDiv       0xaf + 256
#define wsGrayDecimal   0xae + 256
#define wsGray0         0xb0 + 256
#define wsGray1         0xb1 + 256
#define wsGray2         0xb2 + 256
#define wsGray3         0xb3 + 256
#define wsGray4         0xb4 + 256
#define wsGray5         0xb5 + 256
#define wsGray6         0xb6 + 256
#define wsGray7         0xb7 + 256
#define wsGray8         0xb8 + 256
#define wsGray9         0xb9 + 256
#define wsGrayHome      0x95 + 256
#define wsGrayLeft      0x96 + 256
#define wsGrayUp        0x97 + 256
#define wsGrayRight     0x98 + 256
#define wsGrayDown      0x99 + 256
#define wsGrayPgUp      0x9a + 256
#define wsGrayPgDn      0x9b + 256
#define wsGrayEnd       0x9c + 256
#define wsGray5Dup      0x9d + 256
#define wsGrayInsert    0x9e + 256
#define wsGrayDelete    0x9f + 256

#endif /* MPLAYER_WSKEYS_H */
