#if !defined(WINNT) && !defined(EMX)
/*
 * xmms.c: This file handles all the XMMS routines, in BitchX
 *
 * Written by Andr Camargo
 * basead in the code of Tom Zickel a.k.a. IceBreak on the irc
 * and Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 * Copyleft (1999) "CASSIUS IN THE HOUSE!" :)
 *
 */

#include "irc.h"
#include "struct.h"
#include "server.h"
#include "ircaux.h"
#include "output.h"
#include "misc.h"
#include "vars.h"
#include "status.h"
#include "hook.h"
#include "module.h"
#ifndef INIT_MODULE
#define INIT_MODULE
#endif
#include "modval.h"

#include <xmms/xmmsctrl.h>

#define cparse(s) convert_output_format(s, NULL, NULL)

int connect_xmms(void);
void mostra_som(char *, int);
void mostra_acao(char *);

static char xmms_prompt[]="%Ybx%gXMMS%y";
int xmms_running = 0;
int xmms_session = 0;

#define MODULE_NAME	"Xmms"
#define _MODULE_VERSION	"0.01"

BUILT_IN_DLL(xmms_cmd)
{
	char *arg;
	arg = next_arg(args, &args);

	if (!arg)
		arg = "-HELP";

	if (my_stricmp(arg, "-HELP") && !xmms_running)
		connect_xmms();

	if (!my_stricmp(arg, "-PLAY"))
	{
		if (connect_xmms())
		{
			if ((arg = next_arg(args, &args)))
				if (atoi(arg) < xmms_remote_get_playlist_length(xmms_session))
					xmms_remote_set_playlist_pos(xmms_session, atoi(args));
			xmms_remote_play(xmms_session);
			mostra_acao(" >  ");
		}		
	}
	else if (!my_stricmp(arg, "-PAUSE"))
	{
		if (connect_xmms())
		{
			if (!xmms_remote_is_paused(xmms_session))
				xmms_remote_pause(xmms_session);
			mostra_som(" || ", 1);
		}
	}
	else if (!my_stricmp(arg, "-NEXT"))
	{
		if (connect_xmms())
		{
			xmms_remote_playlist_next(xmms_session);
			mostra_acao(" >| ");
		}
	}
	else if (!my_stricmp(arg, "-PREV"))
	{
		if (connect_xmms())
		{
			xmms_remote_playlist_prev(xmms_session);
			mostra_acao(" >| ");
		}
	}
	else if (!my_stricmp(arg, "-STOP"))
	{
		if (connect_xmms())
		{
			xmms_remote_stop(xmms_session);
			mostra_acao(" >| ");
		}
	}
	else if (!my_stricmp(arg, "-LIST"))
	{
		int i;

		if (connect_xmms())
		{
			for (i = 0; i < xmms_remote_get_playlist_length(xmms_session); i++)
				mostra_som(" pl ", i);
		}
	}
	else if (!my_stricmp(arg, "-VOL"))
	{
		int v;

		if (connect_xmms())
		{
			if ((arg = next_arg(args, &args)))
			{
				v = atoi(arg);
				if (v > 100)
					v = 100;
				xmms_remote_set_main_volume(xmms_session, v);
    			}
    			else
    			{
      				v = xmms_remote_get_main_volume(xmms_session);
    			}
    			
    			put_it("%s: \033[1;37m[\033[1;34m%s\033[1;37m] %d%%", cparse(xmms_prompt), "vol ", v);
   		}
	}
	else if (!my_stricmp(arg, "-VOLUP"))
	{
		int vol;

		vol = xmms_remote_get_main_volume(xmms_session);
		vol = (vol + 10) > 100 ? 100 : vol + 10;
			xmms_remote_set_main_volume(xmms_session, vol);

	}
	else if (!my_stricmp(arg, "-VOLDOWN"))
	{
		int vol;

		vol = xmms_remote_get_main_volume(xmms_session);
		vol = (vol - 10) > 100 ? 100 : vol - 10;
			xmms_remote_set_main_volume(xmms_session, vol);

	}
	else if (!my_stricmp(arg, "-BALANCE"))
	{
		int bal;
		arg = next_arg(args, &args);

		bal = atoi(arg) > 100 ? 100 : atoi(arg);
		xmms_remote_set_balance(xmms_session, bal*2-100);
	}
	else if (!my_stricmp(arg, "-TOGSHUFFLE"))
	{
		xmms_remote_toggle_shuffle(xmms_session);
	}
	else if (!my_stricmp(arg, "-TOGREPEAT"))
	{
		xmms_remote_toggle_repeat(xmms_session);
	}
	else if (!my_stricmp(arg, "-HELP"))
	{
		put_it("%s: -PLAY            Play a song",cparse(xmms_prompt));
        	put_it("%s: -STOP            Make the XMMS Stop playing",cparse(xmms_prompt));
        	put_it("%s: -VOL             Set's the XMMS Volume (range from 0\% to 100\%)",cparse(xmms_prompt));
        	put_it("%s: -LIST            Show XMMS playlist songs",cparse(xmms_prompt));
        	put_it("%s: -PAUSE           Pause/resume the XMMS",cparse(xmms_prompt));
        	put_it("%s: -NEXT            Scream to XMMS: next song!",cparse(xmms_prompt));
        	put_it("%s: -PREV            Change to previous song in XMMS playlist",cparse(xmms_prompt));
		put_it("%s: -INFO            Show what song is selected in the playlist", cparse(xmms_prompt));
        	put_it("%s: -INFOCHANNEL     Tell to the people what you're listening...",cparse(xmms_prompt));
		put_it("%s: -SETTIME         Jump to time in playlist",cparse(xmms_prompt));
		put_it("%s: -VOLUP           Increase volume +10",cparse(xmms_prompt));
		put_it("%s: -VOLDOWN         Decrease volume -10",cparse(xmms_prompt));
		put_it("%s: -BALANCE         Set balance",cparse(xmms_prompt));
		put_it("%s: -TOGSHUFFLE      Toggle shuffle",cparse(xmms_prompt));
		put_it("%s: -QUIT            Quit XMMS",cparse(xmms_prompt));
	}
	else if (!my_stricmp(arg, "-INFO"))
	{
		if (connect_xmms())
			mostra_som("info", 1);
	}
	else if (!my_stricmp(arg, "-QUIT"))
	{
		if (connect_xmms())
			xmms_remote_quit(xmms_session);
	}
	else if (!my_stricmp(arg, "-SETTIME"))
	{
		if (connect_xmms())
		{
			if ((arg = next_arg(args, &args)))
			{
				int pos = xmms_remote_get_playlist_pos(xmms_session);
				int full_time = xmms_remote_get_playlist_time(xmms_session, pos);
				xmms_remote_jump_to_time(xmms_session, atoi(arg)*full_time/100);
			}
		}
	}
	else if (!my_stricmp(arg, "-INFOCHANNEL"))
	{
		if (connect_xmms())
		{
			char *target = NULL, *titulo;
			int i, t;

			target = get_current_channel_by_refnum(0);
			if (target)
			{
				char message[255];
				i = xmms_remote_get_playlist_pos(xmms_session);
				t = xmms_remote_get_playlist_length(xmms_session);
				titulo = xmms_remote_get_playlist_title(xmms_session, i);

       				sprintf(message, "\033[1;37m[\033[1;34mXMMS playing\033[1;37m]\033[0;37m\033[1;37m(\033[0;37m %4d/%4d \033[1;37m| \033[0;37m%s\033[1;37m \033[1;37m)\033[0;37m", i+1, t, titulo);

				set_display_target(target, LOG_ACTION);
				bitchsay(message);

				if (do_hook(SEND_ACTION_LIST, "%s %s", target, message))
				{
					if (strchr("&#", *target))
						put_it("%s", convert_output_format(fget_string_var(FORMAT_SEND_ACTION_FSET), "%s %s %s %s", update_clock(GET_TIME), get_server_nickname(from_server), target, message));
					else
						put_it("%s", convert_output_format(fget_string_var(FORMAT_SEND_ACTION_OTHER_FSET), "%s %s %s %s", update_clock(GET_TIME), get_server_nickname(from_server), target, message));
				}
				reset_display_target();
			}
		}
	}
}

int connect_xmms(void)
{
	xmms_running = xmms_remote_is_running(xmms_session);

	if (!xmms_running)
	{
		mostra_acao("load");
		system("xmms &");
	}
	return(xmms_running);
}

void mostra_som(char *msg, int i)
{
	if (i < 0)
		i = xmms_remote_get_playlist_pos(xmms_session);
	put_it("%s: \033[1;37m[\033[1;34m%s\033[1;37m]\033[0;37m\033[1;37m(\033[0;37m %4d/%4d \033[1;37m| \033[0;37m%s\033[1;37m \033[1;37m)\033[0;37m",
 		cparse(xmms_prompt), msg, i+1, xmms_remote_get_playlist_length(xmms_session), xmms_remote_get_playlist_title(xmms_session, i));
}

void mostra_acao(char *msg)
{
        put_it("%s: \033[1;37m[\033[1;34m%s\033[1;37m]", cparse(xmms_prompt), msg);
}

int Xmms_Cleanup(IrcCommandDll **interp, Function_ptr *global_table)
{
	if (xmms_running)
		xmms_remote_quit(xmms_session);
	remove_module_proc(COMMAND_PROC, MODULE_NAME, NULL, NULL);
	put_it("%s", convert_output_format("$G $0 $1 by Andr Camargo (plugin by DavidW2) unloaded","%s %s", MODULE_NAME, _MODULE_VERSION));
	return 2;
}

int Xmms_Init(IrcCommandDll **interp, Function_ptr *global_table)
{
	initialize_module(MODULE_NAME);
	add_module_proc(COMMAND_PROC, "Xmms", "Xmms", NULL, 0, 0, xmms_cmd, empty_string);
	put_it("%s", convert_output_format("$G $0 $1 by DavidW2 loaded", "%s %s", MODULE_NAME, _MODULE_VERSION));
	return 0;
}
#endif
