#include "displayMgrMDI.h"
#include "toplevel.h"

#include <assert.h>

#include <kaccel.h>
#include <klocale.h>

DisplayMgrMDI::DisplayMgrMDI()
{
}

DisplayMgrMDI::~DisplayMgrMDI()
{
    if ( m_topLevel )
        delete static_cast<MDITopLevel *>( m_topLevel );
}

void DisplayMgrMDI::newTopLevel( QWidget *w, bool show )
{
    topLevel()->addWidget( w, show );
}

void DisplayMgrMDI::removeTopLevel(QWidget *w )
{
    if ( !m_topLevel )
        return;

    assert( w );

    m_topLevel->removeWidget( w );

    if ( m_topLevel->widgets().count() == 0 )
    {
		if ( !m_topLevel->closing() )
			delete static_cast<MDITopLevel *>( m_topLevel );
        m_topLevel = 0;
    }
}

void DisplayMgrMDI::show(QWidget *w)
{
    if ( !m_topLevel )
        return;

    m_topLevel->tabWidget()->showPage( w );
}

void DisplayMgrMDI::raise(QWidget *w)
{
    assert( m_topLevel );

    m_topLevel->tabWidget()->showPage( w );
}


void DisplayMgrMDI::setCaption(QWidget *w, const QString& cap)
{
    assert( m_topLevel );

    w->setCaption(cap);

    m_topLevel->tabWidget()->setTabLabel( w, cap );
}

void DisplayMgrMDI::slotCycleTabsLeft()
{

    assert( m_topLevel );

    m_topLevel->previous();
}

void DisplayMgrMDI::slotCycleTabsRight()
{

    assert( m_topLevel );

    m_topLevel->next();
}


MDITopLevel *DisplayMgrMDI::topLevel()
{
    if ( !m_topLevel )
    {
        m_topLevel = new MDITopLevel;
        m_topLevel->show();

        KAccel *a = new KAccel( m_topLevel );
        a->insert( "cycle left", i18n("Cycle left"), QString::null, ALT+Key_Left, ALT+Key_Left, this, SLOT(slotCycleTabsLeft()) );
        a->insert( "cycle right", i18n("Cycle right"), QString::null, ALT+Key_Right, ALT+Key_Right, this, SLOT(slotCycleTabsRight()) );
    }

    return m_topLevel;
}

#include "displayMgrMDI.moc"
