/*
* edrop.h -- Declaration of class KExternDrop.
* Generated by newclass on Sat Nov 21 18:50:02 EST 1998.
*/
#ifndef SSK_EDROP_H
#define SSK_EDROP_H

#include<qstring.h>

#include"maildrop.h"

class KConfigBase;
class KDropCfgDialog;
class KProcess;

/**
* Monitors any process that displays numeric information.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: edrop.h,v 1.3 2002/06/29 15:20:38 gioele Exp $
*/
class KExternDrop : public KMailDrop
{
	Q_OBJECT

private:
	QString _command;
	KProcess *_process;

public:
	KExternDrop () : KMailDrop(), _process( 0 ) {}
	virtual ~KExternDrop () { stopMonitor(); }

	virtual bool startMonitor();
	virtual bool stopMonitor();

	virtual bool running();
	
	virtual void recheck () {}
	virtual bool valid () { return (_command.length() > 0); }

	virtual QString type () const { return QString::fromUtf8("process"); }
	virtual KMailDrop* clone () const;

	void setCommand( const QString& );
	const QString& command() const { return _command; }

	virtual bool readConfigGroup ( const KConfigBase& cfg );  
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;

	virtual void addConfigPage ( KDropCfgDialog * ); 

	static const char *CmdCfgKey;

protected slots:
	void receiveInput( KProcess *, char *buffer, int len );
	void processExit( KProcess * );

private:
	KExternDrop& operator=( const KExternDrop& );
	KExternDrop( const KExternDrop& );
};

#endif // SSK_EDROP_H
