/***************************************************************************
                            HTMLTableCellElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLTABLECELLELEMENT_H
#define HTMLTABLECELLELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The object used to represent the <code> TH </code> and <code> TD
 </code> elements. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html edef]-TD">
 TD element definition </a> in HTML 4.0.

 
 @short 
 The object used to represent the <code> TH </code> and <code> TD
 </code> elements.
*/

@interface HTMLTableCellElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The index of this cell in the row.

     
*/
- (long) cellIndex;

/** 
 see @ref cellIndex

 This function is obsolete - the cellIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
- setCellIndex: (long)arg1;

/** 
 Abbreviation for header cells. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-abbr">
 abbr attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) abbr;

/** 
 see @ref abbr
     
*/
- setAbbr: (NSString *)arg1;

/** 
 Horizontal alignment of data in cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-align-TD">
 align attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Names group of related headers. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-axis">
 axis attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) axis;

/** 
 see @ref axis
     
*/
- setAxis: (NSString *)arg1;

/** 
 Cell background color. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
- (NSString *) bgColor;

/** 
 see @ref bgColor
     
*/
- setBgColor: (NSString *)arg1;

/** 
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-char">
 char attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) ch;

/** 
 see @ref ch
     
*/
- setCh: (NSString *)arg1;

/** 
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) chOff;

/** 
 see @ref chOff
     
*/
- setChOff: (NSString *)arg1;

/** 
 Number of columns spanned by cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-colspan">
 colspan attribute definition </a> in HTML 4.0.

     
*/
- (long) colSpan;

/** 
 see @ref colSpan
     
*/
- setColSpan: (long)arg1;

/** 
 List of <code> id </code> attribute values for header cells.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-headers">
 headers attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) headers;

/** 
 see @ref headers
     
*/
- setHeaders: (NSString *)arg1;

/** 
 Cell height. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-height-TH">
 height attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) height;

/** 
 see @ref height
     
*/
- setHeight: (NSString *)arg1;

/** 
 Suppress word wrapping. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-nowrap">
 nowrap attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (BOOL) noWrap;

/** 
 see @ref noWrap
     
*/
- setNoWrap: (BOOL)arg1;

/** 
 Number of rows spanned by cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-rowspan">
 rowspan attribute definition </a> in HTML 4.0.

     
*/
- (long) rowSpan;

/** 
 see @ref rowSpan
     
*/
- setRowSpan: (long)arg1;

/** 
 Scope covered by header cells. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-scope">
 scope attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) scope;

/** 
 see @ref scope
     
*/
- setScope: (NSString *)arg1;

/** 
 Vertical alignment of data in cell. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-valign">
 valign attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) vAlign;

/** 
 see @ref vAlign
     
*/
- setVAlign: (NSString *)arg1;

/** 
 Cell width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-width-TH">
 width attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) width;

/** 
 see @ref width
     
*/
- setWidth: (NSString *)arg1;
@end

#endif
