/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __window_recent_history_menu_h
#define __window_recent_history_menu_h

#include "window-recent-history.h"
#include <bonobo/bonobo-ui-component.h>

/* object forward declarations */

typedef struct _GaleonWindowRecentHistoryMenu GaleonWindowRecentHistoryMenu;
typedef struct _GaleonWindowRecentHistoryMenuClass GaleonWindowRecentHistoryMenuClass;
typedef struct _GaleonWindowRecentHistoryMenuPrivate GaleonWindowRecentHistoryMenuPrivate;

/**
 * Editor object
 */

#define GALEON_TYPE_WINDOW_RECENT_HISTORY_MENU	      	(galeon_window_recent_history_menu_get_type())
#define GALEON_WINDOW_RECENT_HISTORY_MENU(object)	(G_TYPE_CHECK_INSTANCE_CAST((object), \
							 GALEON_TYPE_WINDOW_RECENT_HISTORY_MENU,\
							 GaleonWindowRecentHistoryMenu))
#define GALEON_WINDOW_RECENT_HISTORY_MENU_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), \
							 GALEON_TYPE_WINDOW_RECENT_HISTORY_MENU,\
							 GaleonWindowRecentHistoryMenuClass))
#define GALEON_IS_WINDOW_RECENT_HISTORY_MENU(object)	(G_TYPE_CHECK_INSTANCE_TYPE((object), \
							 GALEON_TYPE_WINDOW_RECENT_HISTORY_MENU))
#define GALEON_IS_WINDOW_RECENT_HISTORY_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), \
							   GALEON_TYPE_WINDOW_RECENT_HISTORY_MENU))
#define GALEON_WINDOW_RECENT_HISTORY_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), \
							  GALEON_TYPE_WINDOW_RECENT_HISTORY_MENU,\
							  GaleonWindowRecentHistoryMenuClass))

struct _GaleonWindowRecentHistoryMenuClass 
{
	GObjectClass parent_class;
	
	/* signals */
	void	(*activated)	(GaleonWindowRecentHistoryMenu *wrhm, 
				 const char *url, const char *title);
};

/* Remember: fields are public read-only */
struct _GaleonWindowRecentHistoryMenu
{
	GObject parent_object;

	GaleonWindowRecentHistoryMenuPrivate *priv;
};

GType
galeon_window_recent_history_menu_get_type		(void);

GaleonWindowRecentHistoryMenu *
galeon_window_recent_history_menu_new			(void);

void
galeon_window_recent_history_menu_set_history		(GaleonWindowRecentHistoryMenu *wrhm,
							 GaleonWindowRecentHistory *wrh);

void
galeon_window_recent_history_menu_set_path		(GaleonWindowRecentHistoryMenu *wrhm,
							 BonoboUIComponent *uic, const gchar *path);

#endif

