/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "nsIGenericFactory.h"

#include "ExternalProtocolService.h"
#include "nsAboutRedirector.h"
#include "nsMailtoUrl.h"
#include "gUrlCID.h"

////////////////////////////////////////////////////////////////////////
// Define the contructor function for the objects
//
// NOTE: This creates an instance of objects by using the default constructor
//
NS_GENERIC_FACTORY_CONSTRUCTOR(GExternalProtocolService)
NS_GENERIC_FACTORY_CONSTRUCTOR(nsMailtoUrl);

////////////////////////////////////////////////////////////////////////
// Define a table of CIDs implemented by this module along with other
// information like the function to create an instance, contractid, and
// class name.
//
static nsModuleComponentInfo components[] = {
  { G_EXTERNALPROTOCOLSERVICE_CLASSNAME,
    G_EXTERNALPROTOCOLSERVICE_CID,
    NS_EXTERNALPROTOCOLSERVICE_CONTRACTID, 
    GExternalProtocolServiceConstructor },
  { NS_MAILTOURL_CLASSNAME,
    NS_MAILTOURL_CID,
    NS_MAILTOURL_CONTRACTID,
    nsMailtoUrlConstructor },
  { G_ABOUT_TOPHER_MODULE_CLASSNAME,
    G_ABOUT_REDIRECTOR_MODULE_CID,
    G_ABOUT_TOPHER_MODULE_CONTRACTID,
    nsAboutRedirector::Create }
};


////////////////////////////////////////////////////////////////////////
// Implement the NSGetModule() exported function for your module
// and the entire implementation of the module object.
//
NS_IMPL_NSGETMODULE(gProtocolHandlers, components)
