/* -*- C++ -*-

  $Id: InsertPartTool.h,v 1.8 2002/06/26 09:21:56 faure Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef InsertPartTool_h_
#define InsertPartTool_h_

#include <koQueryTrader.h>
#include <Tool.h>

namespace Kontour {
class Canvas;
class GDocument;
class Coord;

class InsertPartTool : public Tool {
public:
  InsertPartTool (CommandHistory* history);

  virtual void processEvent (QEvent* e, GDocument* doc, Canvas* canvas);
  virtual void activate (GDocument* doc, Canvas* canvas);
  virtual void deactivate (GDocument*, Canvas*);

  void setPartEntry (KoDocumentEntry& entry);

protected:
  void processButtonPressEvent (QMouseEvent* e);
  void processMouseMoveEvent (QMouseEvent* e);
  void processButtonReleaseEvent (QMouseEvent* e);
private:
  KoDocumentEntry docEntry;
  GDocument *doc;
  Canvas *canvas;
  enum State { S_Init, S_Rubberband};
  State state;
  Coord selPoint[2];

  bool validEntry;
};
};
using namespace Kontour;

#endif
