#ifndef _VITERBI_H
#define _VITERBI_H

/* ---------------------------------------------------------------------- */

#define PATHMEM 64

struct viterbi {
	int nstates;

	int *output;

	int *metrics[PATHMEM];
	int *history[PATHMEM];

	int sequence[PATHMEM];

	int mettab[2][256];

	unsigned int ptr;
};

extern struct viterbi *viterbi_init(int k, int poly1, int poly2);
extern void viterbi_free(struct viterbi *v);
extern void viterbi_reset(struct viterbi *v);
extern int viterbi_decode(struct viterbi *v, unsigned char *sym, int *metric);

/* ---------------------------------------------------------------------- */

struct encoder {
	int *output;
	unsigned int shreg;
	unsigned int shregmask;
};

extern struct encoder *encoder_init(int k, int poly1, int poly2);
extern void encoder_free(struct encoder *e);
extern int encoder_encode(struct encoder *e, int bit);

/* ---------------------------------------------------------------------- */

#endif
