#include <klocale.h>
#include <kstandarddirs.h>

#include <qvariant.h>
#include <knuminput.h>
#include <kurllabel.h>
#include <kurlrequester.h>
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qvbox.h>
#include <qhbox.h>

#include "prefdialogview.h"

/* 
 *  Constructs a prefsDialogData which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
prefsDialogData::prefsDialogData( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : KDialogBase( parent, name, modal, i18n("KWeather Preferences"), Ok | Cancel )
{
    resize( 450, 280 ); 
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 450, 280 ) );
    setMaximumSize( QSize( 640, 480 ) );
    setIcon( QPixmap( locate( "data", "kweather/sunny.png" ) ) );
    setFocusPolicy( QDialog::TabFocus );

    QVBox *topBox = new QVBox( this ); 
    topBox->setSpacing(KDialog::spacingHint());
    setMainWidget( topBox );

    QHBox *locationBox = new QHBox(topBox); 
    locationBox->setSpacing(KDialog::spacingHint()); 
    locationLabel = new QLabel( locationBox );
    locationLabel->setText( tr2i18n( "ICAO location code:" ) );
    locationLabel->setFixedWidth( locationLabel->sizeHint().width() );

    m_reportLocation = new QLineEdit( locationBox, "m_reportLocation" );
    m_reportLocation->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, m_reportLocation->sizePolicy().hasHeightForWidth() ) );
    m_reportLocation->setMinimumSize( QSize( 80, 0 ) );
    m_reportLocation->setMaximumSize( QSize( 80, 32767 ) );
    m_reportLocation->setCursor( QCursor( 0 ) );
    m_reportLocation->setText( QString::null );
    m_reportLocation->setMaxLength( 5 );
    QToolTip::add( m_reportLocation, tr2i18n( "Enter the 4 character <BR> ICAO location code for your station." ) );
    QWhatsThis::add( m_reportLocation, tr2i18n( "Enter the 4 character ICAO location code here. A search page has been provided at:  <BR><a href=\"http://www.nws.noaa.gov/tg/siteloc.shtml\">http://www.nws.noaa.gov/tg/siteloc.shtml</a><BR>\n"
"Examples of codes are: KPNE, KMKE, EDDA<BR>\n"
"<B>NOTE:</B><i>  You may have better luck with manned stations than with automated monitoring stations.</i>" ) );

    ICAOlink = new KURLLabel( locationBox, "ICAOlink" );
    ICAOlink->setMinimumSize( QSize( 180, 10 ) );
    ICAOlink->setText(  i18n ( "Lookup Your ICAO Code" ) );
    ICAOlink->setURL( "http://www.nws.noaa.gov/tg/siteloc.shtml");
    QToolTip::add( ICAOlink, tr2i18n( "Click on this link to search<br>for your ICAO code." ) );
    QWhatsThis::add( ICAOlink, tr2i18n( "Clicking on this link will open your web browser with the NOAA's search page. This search page will allow you to find the closest weather station to your location." ) );

    QHGroupBox *fontGroupBox = new QHGroupBox(i18n("Panel Font"), topBox);

    samplefont = new QLabel( fontGroupBox, "samplefont" );
    samplefont->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, samplefont->sizePolicy().hasHeightForWidth() ) );
    samplefont->setFrameShape( QLabel::WinPanel );
    samplefont->setFrameShadow( QLabel::Sunken );
    samplefont->setLineWidth( 2 );
    samplefont->setMargin( 0 );
    samplefont->setMidLineWidth( 0 );
    samplefont->setText( QString::null );
    samplefont->setTextFormat( QLabel::AutoText );
    samplefont->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );

    fontButton = new QPushButton( fontGroupBox, "fontButton" );
    fontButton->setText( tr2i18n( "&Choose..." ) );
    fontButton->setFixedWidth( fontButton->sizeHint().width() );

    QVGroupBox *optionsGroupBox = new QVGroupBox(i18n("Options"), topBox);

    m_smallView = new QCheckBox( optionsGroupBox, "m_smallView" );
    m_smallView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, 0, 0, m_smallView->sizePolicy().hasHeightForWidth() ) );
    m_smallView->setText( tr2i18n( "Show &icon only" ) );
    QToolTip::add( m_smallView, tr2i18n( "Click here to show only <BR> the weather icon." ) );
    QWhatsThis::add( m_smallView, tr2i18n( "This feature causes KWeather to only take up one slot on the Kicker. Normally this application will take up two slots. The small view will only show the weather icon, while the normal view will display both the icon and the current weather statistics. For the small view the weather statistics will be put on the button's tool tip." ) );

    m_offlineMode = new QCheckBox( optionsGroupBox, "m_offlineMode" );
    m_offlineMode->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, 0, 0, m_offlineMode->sizePolicy().hasHeightForWidth() ) );
    m_offlineMode->setText( tr2i18n( "&Offline mode" ) );
    QToolTip::add( m_offlineMode, tr2i18n( "Click here to disable weather updates." ) );
    QWhatsThis::add( m_offlineMode, tr2i18n( "You should really select this option if you are not connected to the network." ) );

    m_updateInterval = new KIntNumInput( optionsGroupBox, "m_updateInterval" );
    m_updateInterval->setLabel("&Update interval:");
    m_updateInterval->setRange( 30, 120 );
    m_updateInterval->setSuffix( i18n( " min" ) );
    m_updateInterval->setEnabled( TRUE );

    QVGroupBox *logGroupBox = new QVGroupBox(i18n("Logging"), topBox);
    m_enableLog = new QCheckBox( logGroupBox, "m_enableLog" );
    m_enableLog->setText( tr2i18n( "Enable &logging" ) );

    QHBox *logBox = new QHBox( logGroupBox ); 
    m_labelLogFile = new QLabel( logBox, "m_labelLogFile" );
    m_labelLogFile->setText( tr2i18n( "Log file:" ) );
    m_logFile = new KURLRequester( logBox, "m_logFile" );
    m_logFile->setMinimumSize( QSize( 252, 0 ) );
    QToolTip::add( m_logFile, tr2i18n( "Enter the logfile name." ) );
    QWhatsThis::add( m_logFile, tr2i18n( "Enter the full path and filename to enable logging in KWeather." ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
prefsDialogData::~prefsDialogData()
{
    // no need to delete child widgets, Qt does it all for us
}

#include "prefdialogview.moc"
