/***************************************************************************
                          akbytestreamsender.h  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AKBYTESTREAMSENDER_H
#define AKBYTESTREAMSENDER_H

#include <soundserver.h>
#include <stdsynthmodule.h>

#include <qobject.h>

#include "recordfile.h"

using namespace Arts;

/// Arnolds ByteSoundProducer.

/**
  Plays the file it gets.

  See @ref AKByteStreamReceiver

 *@author Arnold Krille
 */

class AKByteStreamSender : public QObject,
                           public ByteSoundProducerV2_skel,
                           public StdSynthModule
{
   Q_OBJECT
public:
	/// Constructor
	/**
		@param input The file where the data is written to.
		@param minStreamBufferTime Minimum-Buffer-Time. use: @code server.minStreamBufferTime() @endcode
		@param parent The parent QObject. Is forwarded to QObject.
		@param name The Name. Is forwarded to QObject and used for the own title, which can be seen in the audiomanager if you connect this object directly to the soundserver.
	*/
	AKByteStreamSender( RecordFile *input, float minStreamBufferTime, QObject *parent=0, const char* name=0 );
	/// Destructor
	~AKByteStreamSender();
	/// Starts the stream.
	void streamStart();
	/// What to do on EOF.
	void handle_eof();
	/// When data is requested (Polling)
	void request_outdata(DataPacket<mcopbyte> *packet);

	/// Returns the Samplingrate.
	long samplingRate() { return cfgSamplingRate; }
	/// Returns the channels.
	long channels() { return cfgChannels; }
	/// Returns the bits.
	long bits() { return cfgBits; }
	/// Returns wether we have finished or not.
	bool finished() { return ! ( _file && _file->file().isOpen() ); }
	/// Returns the title.
	std::string title() { return cfgTitle; }

public slots:
	/// Sets a new File for Playback.
	void file( RecordFile *input );

signals:
	/// Informs that we are playing.
	void sPlayIsRunning();
	/// Informs that we are not playing anymore.
	void sPlayStops();
	/// Informs when we can play or when not.
	void sCanPlay(bool);

protected:
	/// calculates the number of packets
	void file();

private:
	int cfgSamplingRate, cfgChannels, cfgBits, packets;
	float i_minStreamBufferTime;
	std::string cfgTitle;
	enum { packetCapacity = 4096 };
	RecordFile *_file;

};

#endif
