/*  This file is part of the KDE project
    Copyright (C) 2002 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

*/

#include <klocale.h>

#include "artsmodules.h"
#include "connect.h"
#include "debug.h"

using namespace Arts;

namespace Arts {

class StereoCompressorGuiFactory_impl : virtual public StereoCompressorGuiFactory_skel
{
public:
	Widget createGui( Object object )
	{
		arts_return_val_if_fail(!object.isNull(), Arts::Widget::null() );

		Synth_STEREO_COMPRESSOR comp = DynamicCast(object);
		arts_return_val_if_fail(!comp.isNull(), Arts::Widget::null());

		HBox hbox;
		hbox.width(330); hbox.height(80); hbox.show();

		Poti attack;
		attack.x(10); attack.y(10); attack.caption(i18n("attack").utf8().data());
		attack.color("blue");
		attack.min(0.1); attack.max(250);
		attack.value( comp.attack() );
		attack.range(250);
		attack.parent( hbox );
		attack.show();
		connect( attack, "value_changed", comp, "attack" );
		hbox._addChild( attack, "compAttackObj" );

		Poti release;
		release.x(50); release.y(10); release.caption(i18n("release").utf8().data());
		release.color("blue");
		release.min(0.1); release.max(250);
		release.value( comp.release() );
		release.range(250);
		release.parent( hbox );
		release.show();
		connect( release, "value_changed", comp, "release" );
		hbox._addChild( release, "compReleaseObj" );

		Poti threshold;
		threshold.x(90); threshold.y(10); threshold.caption(i18n("threshold").utf8().data());
		threshold.min(0.00001); threshold.max(1);
		threshold.value( comp.threshold() );
		threshold.logarithmic( 2.0 );
		threshold.range(200);
		threshold.parent( hbox );
		threshold.show();
		connect( threshold, "value_changed", comp, "threshold" );
		hbox._addChild( threshold, "compThresholdObj" );

		Poti ratio;
		ratio.x(130); ratio.y(10); ratio.caption(i18n("ratio").utf8().data());
		ratio.min(0); ratio.max(1);
		ratio.value( comp.ratio() );
		ratio.range(200);
		ratio.parent( hbox );
		ratio.show();
		connect( ratio, "value_changed", comp, "ratio" );
		hbox._addChild( ratio, "compRatioObj" );

		Poti output;
		output.x(170); output.y(10); output.caption(i18n("output").utf8().data());
		output.min(0.1); output.max(10.0);
		output.value( comp.output() );
		output.logarithmic( 2.0 );
		output.range(200);
		output.parent( hbox );
		output.show();
		connect( output, "value_changed", comp, "output" );
		hbox._addChild( output, "compOutputObj" );

		Button bon;
		bon.x(210); bon.y(10); bon.text(i18n("Bypass").utf8().data());
		bon.toggle( true );
		bon.parent( hbox );
		bon.show();
		connect( bon, "pressed_changed", comp, "thru" );
		hbox._addChild( bon, "OnThruObj" );

		return hbox;
	}
};

// vim:sw=4:ts=4

REGISTER_IMPLEMENTATION(StereoCompressorGuiFactory_impl);

}
