//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMHEIGHTFIELD_H
#define PMHEIGHTFIELD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmsolidobject.h"

class PMViewStructure;

/**
 * Class for povray height fields.
 */ 

class PMHeightField : public PMSolidObject
{
   typedef PMSolidObject Base;
public:
   /** Height field type */
   enum HeightFieldType { HFgif, HFtga, HFpot, HFpng, HFpgm, HFppm, HFsys };
   /** Creates an empty PMHeightField */
   PMHeightField( );
   /** deletes the PMHeightField */
   virtual ~PMHeightField( );

   /** */
   virtual PMObject* newObject( ) const { return new PMHeightField( ); }
   /** */
   virtual QString className( ) const { return QString( "heightfield" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTHeightField; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMHeightFieldEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the name of the pixmap that is displayed in the tree view
    * and dialog view */
   virtual QString pixmap( ) const { return QString( "pmheightfield" ); }

   /** Returns the height field type */
   HeightFieldType heightFieldType( ) const { return m_hfType; }
   /** Sets the height field type */
   void setHeightFieldType( HeightFieldType t );
   /** Returns the file name */
   QString fileName( ) const { return m_fileName; }
   /** Sets the file name */
   void setFileName( const QString& name );
   /** Returns the hierarchy flag */
   bool hierarchy( ) const { return m_hierarchy; }
   /** Sets the hierarchy flag */
   void setHierarchy( bool h );
   /** Returns the smooth flag */
   bool smooth( ) const { return m_smooth; }
   /** Sets the smooth flag */
   void setSmooth( bool s );
   /** Returns the water level */
   double waterLevel( ) const { return m_waterLevel; }
   /** Sets the water level */
   void setWaterLevel( double wl );
   
   /** */
   virtual void restoreMemento( PMMemento* s );
   /** */
   virtual void cleanUp( ) const;
   
protected:
   /** */
   virtual bool isDefault( );
   /** */
   virtual void createViewStructure( );
   /** */
   virtual PMViewStructure* defaultViewStructure( ) const;
   
private:
   static QString typeToString( HeightFieldType t );
   static HeightFieldType stringToType( QString str );
   
   /** IDs for @ref PMMementoData */
   enum PMHeightFieldMementoID { PMHeightFieldTypeID, PMFileNameID,
                                 PMHierarchyID, PMSmoothID, PMWaterLevelID };
   
   HeightFieldType m_hfType;
   QString m_fileName;
   bool m_hierarchy;
   bool m_smooth;
   double m_waterLevel;
   
   /** The default view structure. It can be shared between height fields */
   static PMViewStructure* s_pDefaultViewStructure;
};

#endif
