/* -*- C++ -*-

  $Id: CreateOvalCmd.cc,v 1.14 2002/02/27 22:27:06 rm Exp $

  This file is part of Kontour.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)
  Copyright (C) 2001 Igor Janssen (rm@linux.ru.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "CreateOvalCmd.h"

#include <klocale.h>

#include "GDocument.h"
#include "GPage.h"
#include "GOval.h"

CreateOvalCmd::CreateOvalCmd(GDocument *aGDoc, GOval *oval):
Command(aGDoc, i18n("Create Oval"))
{
  object = oval;
  object->ref();
}

CreateOvalCmd::~CreateOvalCmd()
{
  if(object)
    object->unref();
}

void CreateOvalCmd::execute()
{
  document()->activePage()->insertObject(object);
  document()->emitChanged(object->boundingBox(), true);
}

void CreateOvalCmd::unexecute()
{
  document()->activePage()->deleteObject(object);
}
