/* $Id: weatherservice.h,v 1.10 2002/09/03 15:42:05 geiseri Exp $ */
#ifndef _WEATHER_SERVICE
#define _WEATHER_SERVICE

#include <qstringlist.h>
#include <qstring.h>
#include <dcopobject.h>
#include <qpixmap.h>

class WeatherLib;

class WeatherService : public QObject, public DCOPObject
{
	Q_OBJECT
	K_DCOP

	private:
		WeatherLib  *m_weatherLib;

	private slots:
		void updated(const QString &stationID);
		void updateing(const QString &stationID);

	public:
		WeatherService();
		~WeatherService();

	k_dcop_signals:
		void fileUpdateing(QString);
		void fileUpdate(QString);
		
	k_dcop:
		QString temperature(QString stationID);
		QString dewPoint(QString stationID);
		QString relitiveHumidity(QString stationID);
		QString heatIndex(QString stationID);
		QString windChill(QString stationID);
		QString wind(QString stationID);
		QString pressure(QString stationID);
		QPixmap currentIcon(QString stationID);
		QString currentIconString(QString stationID);
		QString date(QString stationID);
		QString visability(QString stationID);
		QStringList cover(QString stationID);
		QStringList weather(QString stationID);
		
		void update(QString stationID);
		bool forceUpdate(QString stationID);
		void removeStation(QString stationID);
		bool addStation(QString stationID);
		QStringList listStations();
		
		void setMaxAge(int age);
		int maxAge();

		void exit();
};
#endif
