using System;
using System.Collections;
using System.IO;
using System.Text;
using System.Xml;

public class Application
{
	static bool   ToStdOut         = false;
	static bool   Quiet            = false;
	static string OutputFilename   = "out.xml";
	static string DefaultNamespace = "DefaultNamespace";

	static void Msgl (string fmt, params object[] arg)
	{
		if (! Quiet)
			Console.Error.WriteLine (fmt, arg);
	}

	static void Msg (string fmt, params object[] arg)
	{
		if (! Quiet)
			Console.Error.Write (fmt, arg);
	}

	static void Usage ()
	{
		Console.WriteLine ("Usage: parser.exe [options] HEADER...");
		Console.WriteLine ("options:");
		Console.WriteLine (" -c,      --to-stdout      Output to STDOUT");
		Console.WriteLine (" -f NAME, --filename NAME  Use output filename NAME");
		Console.WriteLine (" -h,      --help           Print help message");
		Console.WriteLine (" -n NS,   --namespace NS   Use default namespace NS");
		Console.WriteLine (" -q,      --quiet          No status messages");
		Console.WriteLine ("");
		Console.WriteLine (" --show-warnings            Display warning messages");
		Console.WriteLine (" --omit-stubs              Omit empty classes");
	}

	// FIXME Replace with a real getopt implementation.
	static string[] GetOptions (string[] args)
	{
		ArrayList nargs = new ArrayList ();

		for (int i=0; i<args.Length; i++)
		{
			switch (args[i])
			{
			case "-c":
			case "--to-stdout":
				ToStdOut = true;
				break;
			case "-f":
			case "--filename":
				OutputFilename = args[++i];
				break;
			case "-h":
			case "--help":
				Usage ();
				Environment.Exit (0);
				break;
			case "-n":
			case "--namespace":
				DefaultNamespace = args[++i];
				break;
			case "-q":
			case "--quiet":
				Quiet = true;
				break;
			case "--show-warnings":
				Parser.ShowWarnings = true;
				break;
			case "--omit-stubs":
				Parser.OmitStubs = true;
				break;
			default:
				nargs.Add (args[i]);
				break;
			}
		}

		string[] ret = new string[nargs.Count];
		nargs.CopyTo (ret);

		return ret;
	}

	public static int Main (string[] args)
	{
		args = GetOptions (args);
		Parser.@namespace.Name = DefaultNamespace;
		NamespaceList nslist = new NamespaceList ();
		nslist.Add (Parser.@namespace);

		if (args.Length == 0)
		{
			Console.Error.WriteLine ("Error: No header files specified");
			Usage ();
			return -1;
		}

		Msg ("Parsing...", args.Length);

		foreach (string file in args)
		{
			StreamReader reader = new StreamReader (file);
			Parser parser = new Parser (reader);
			parser.Parse ();
			reader.Close ();
		}

		int c = 0, e = 0;

		foreach (Namespace ns in nslist)
		{
			c += ns.Classes.Count;
			e += ns.Enums.Count;
		}

		Msgl ("{0} namespace(s), {1} class(es), {2} enum(s) in {0} header(s).",
			nslist.Count, c, e, args.Length);

		XmlTextWriter writer;

		if (ToStdOut)
			writer = new XmlTextWriter (Console.Out);
		else
			writer = new XmlTextWriter (OutputFilename, new System.Text.ASCIIEncoding ());


		writer.Formatting = Formatting.Indented;
		//writer.IndentChar = '\t';
		//writer.Indentation = 1;

		Msg ("Writing {0}...", OutputFilename);
		nslist.Archive (writer);
		writer.Flush (); // FIXME Sometimes get incomplete files unless you flush here.
		Msgl ("done.");

		return 0;
	}
}
