/***************************************************************************
                            URLArgs.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef URLARGS_H
#define URLARGS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 URLArgs is a set of arguments bundled into a structure,
 to allow specifying how a URL should be opened by -openURL.
 In other words, this is like arguments to -openURL, but without
 have to change the signature of -openURL (since openURL is a
 generic KParts method).
 The parts (with a browser extension) who care about urlargs will
 use those arguments, others will ignore them.

 This can also be used the other way round, when a part asks
 for a URL to be opened (with openURLRequest or createNewWindow).
 
 @short 
 URLArgs is a set of arguments bundled into a structure,
 to allow specifying how a URL should be opened by openURL().
*/
@interface  URLArgs : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- initWithBOOL: (BOOL)reload xOffset: (int)xOffset yOffset: (int)yOffset serviceType: (NSString *)serviceType;
- initWithBOOL: (BOOL)reload xOffset: (int)xOffset yOffset: (int)yOffset ;
- (void) dealloc;

/** 
 KHTML-specific field, header defining the type of the POST data.
   
*/
- setContentType: (NSString *)contentType;

/** 
 KHTML-specific field, header defining the type of the POST data.
   
*/
- (NSString *) contentType;

/** 
 KHTML-specific field, whether to do a POST instead of a GET,
 for the next openURL.
   
*/
- setDoPost: (BOOL)enable;

/** 
 KHTML-specific field, whether to do a POST instead of a GET,
 for the next openURL.
   
*/
- (BOOL) doPost;

/** 
 Whether to lock the history when opening the next URL.
 This is used during e.g. a redirection, to avoid a new entry
 in the history.
   
*/
- setLockHistory: (BOOL)lock;
- (BOOL) lockHistory;
@end

#endif
