/***************************************************************************
                            PartManager.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef PARTMANAGER_H
#define PARTMANAGER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The part manager is an object which knows about a collection of parts
 (even nested ones) and handles activation/deactivation.

 Applications that want to embed parts without merging GUIs
 only use a -[KParts PartManager]. Those who want to merge GUIs use a
 @ref -[KParts MainWindow]for example, in addition to a part manager.

 Parts know about the part manager to add nested parts to it.
 See also @ref -[KParts Part]::-manager and @ref -[KParts Part]::-setManager.
 
 @short 
 The part manager is an object which knows about a collection of parts
 (even nested ones) and handles activation/deactivation.
*/
@class KInstance; 
@class Part; 

@interface PartManager : QObject 

/** 
 Constructs a part manager.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;

/** 
 Constructs a part manager.

*/
- initWithWidget: (QWidget *)topLevel parent: (QObject *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)topLevel parent: (QObject *)parent ;
- (void) dealloc;

/** 
 Sets the selection policy of the partmanager.
   
*/
- setSelectionPolicy: (int)policy;

/** 
 Returns the current selection policy.
   
*/
- (int) selectionPolicy;

/** 
 Specifies whether the partmanager should handle/allow nested parts
 or not.

  This is a property the shell has to set/specify. Per
 default we assume that the shell cannot handle nested
 parts. However in case of a KOffice shell for example we allow
 nested parts.  A Part is nested (a child part) if its parent
 object inherits @ref -[KParts Part].  If a child part is activated and
 nested parts are not allowed/handled, then the top parent part in
 the tree is activated.
   
*/
- setAllowNestedParts: (BOOL)allow;

/** 

*/
- (BOOL) allowNestedParts;

/** 
 Specifies whether the partmanager should ignore mouse click events for
 scrollbars or not. If the partmanager ignores them, then clicking on the
 scrollbars of a non-active/non-selected part will not change the selection
 or activation state.

 The default value is false (read: scrollbars are NOT ignored).
   
*/
- setIgnoreScrollBars: (BOOL)ignore;

/** 

*/
- (BOOL) ignoreScrollBars;

/** 

   
*/
- (BOOL) eventFilter: (QObject *)obj ev: (QEvent *)ev;

/** 
 Adds a part to the manager.

 Sets it to the active part automatically if @p setActive is true (default ).
   
*/
- addPart: (Part*)part setActive: (BOOL)setActive;
- addPart: (Part*)part ;

/** 
 Removes a part from the manager (this does not delete the object) .

 Sets the active part to 0 if @p part is the @ref -activePart .
   
*/
- removePart: (Part*)part;

/** 
 Replaces @p oldPart with @p newPart, and sets @p newPart as active if
 @p setActive is true.
 This is an optimised version of @ref removePart + @ref addPart
   
*/
- replacePart: (Part*)oldPart newPart: (Part*)newPart setActive: (BOOL)setActive;
- replacePart: (Part*)oldPart newPart: (Part*)newPart ;

/** 
 Sets the active part.

 The active part receives activation events.

 @p widget can be used to specify which widget was responsible for the activation.
 This is important if you have multiple views for a document/part , like in KOffice .
   
*/
- setActivePart: (Part*)part widget: (QWidget *)widget;
- setActivePart: (Part*)part ;

/** 
 Returns the active part.

*/
- (Part*) activePart;

/** 
 Returns the active widget of the current active part (see @ref activePart ).
   
*/
- (QWidget*) activeWidget;

/** 
 Sets the selected part.

 The selected part receives selection events.

 @p widget can be used to specify which widget was responsible for the selection.
 This is important if you have multiple views for a document/part , like in KOffice .
   
*/
- setSelectedPart: (Part*)part widget: (QWidget *)widget;
- setSelectedPart: (Part*)part ;

/** 
 Returns the current selected part.
   
*/
- (Part*) selectedPart;

/** 
 Returns the selected widget of the current selected part (see @ref selectedPart ).
   
*/
- (QWidget*) selectedWidget;

/** 
 Adds the @p topLevel widget to the list of managed toplevel widgets.
 Usually a PartManager only listens for events (for activation/selection)
 for one toplevel widget (and its children) , the one specified in the
 constructor. Sometimes however (like for example when using the KDE dockwidget
 library) , it is necessary to extend this.
   
*/
- addManagedTopLevelWidget: (QWidget *)topLevel;

/** 
 Removes the @p topLevel widget from the list of managed toplevel widgets.

*/
- removeManagedTopLevelWidget: (QWidget *)topLevel;

/** 
 Changes the active instance when the active part changes.
 The active instance is used by KBugReport and KAboutDialog.
 Override if you really need to - usually you don't need to.
   
*/
- setActiveInstance: (KInstance*)instance;

/** 
 Removes a part when it is destroyed.

*/
- slotObjectDestroyed;

/** 

   
*/
- slotWidgetDestroyed;

/** 

   
*/
- slotManagedTopLevelWidgetDestroyed;
+ (int) Direct;
+ (int) TriState;
@end

/** Override these methods in subclasses of PartManager to customise event handling behaviour */
@protocol PartManagerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
