/***************************************************************************
                            KPixmap.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPIXMAP_H
#define KPIXMAP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QPixmap.h>

/**

 Off-screen paint device with extended features.

 KPixmap has two new color modes, WebColor and LowColor, applicable
 to 8bpp displays.

 In WebColor mode all images are dithered to the Netscape palette,
 even when they have their own color table. WebColor is the default
 mode for KPixmap so that standard applications can share the Netscape
 palette across the desktop.

 In LowColor mode images are checked to see if their color table
 matches the KDE icon palette. If the color tables do not match, the
 images are dithered to a minimal 3x3x3 color cube. LowColor mode can
 be used to load icons, background images etc. so that components of
 the desktop which are always present use no more than 40 colors.

 @author Mark Donohoe (donohoe@kde.org)

 @version $Id: KPixmap.h,v 1.3 2002/03/15 02:12:21 rdale Exp $
 
 @short 
 Off-screen paint device with extended features.
*/
@interface KPixmap : QPixmap 

/** 
 Constructs a null pixmap.
	 
*/
- init;

/** 
 Destructs the pixmap.
	 
*/
- (void) dealloc;

/** 
 Copies the QPixmap @p pix.
         
*/
- initWithPixmap: (QPixmap *)pix;

/** 
 Converts an image and sets this pixmap.

 The conversion_flags argument is a bitwise-OR from the
 following choices. The options marked (default) are the
 choice if no other choice from the list is included (they
 are zero):

 Color/Mono preference

 Dithering mode preference, for RGB channels

 Dithering mode preference, for alpha channel

 Color matching versus dithering preference

 Passing 0 for @p conversion_flags gives all the default
 options.

*/
- (BOOL) convertFromImage: (QImage *)img conversion_flags: (int)conversion_flags;

/** 
 This is an overloaded member function, provided for
 convenience. It differs from the above function only in
 what argument(s) it accepts.

*/
- (BOOL) convertFromImage: (QImage *)img mode: (int)mode;
- (BOOL) convertFromImage: (QImage *)img ;

/** 
 Loads a pixmap from the file @p fileName.

 If format is specified, the loader attempts to read the
 pixmap using the specified format. If format is not
 specified (default), the loader reads a few bytes from the
 header to guess the file format.

 See the @ref -convertFromImage documentation for a description
 of the conversion_flags argument.

 The @ref QImageIO documentation lists the supported image
 formats and explains how to add extra formats.

*/
- (BOOL) load: (NSString *)fileName format: (NSString *)format conversion_flags: (int)conversion_flags;

/** 
 This is an overloaded member function, provided for
 convenience. It differs from the above function only in
 what argument(s) it accepts.

*/
- (BOOL) load: (NSString *)fileName format: (NSString *)format mode: (int)mode;
- (BOOL) load: (NSString *)fileName ;

/** 
 Returns true if the image posesses a color table that
 matches the Icon palette or false otherwise.

 An image with one color not found in the Icon palette is
 considered to be a match, since this extra color may be a
 transparent background.

*/
- (BOOL) checkColorTable: (QImage *)image;
+ (int) Auto;
+ (int) Color;
+ (int) Mono;
+ (int) LowColor;
+ (int) WebColor;
+ (int) Horizontal;
+ (int) Vertical;
+ (int) Diagonal;
+ (int) CrossDiagonal;
@end

#endif
