/***************************************************************************
                            KPanelMenu.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Base class to build dynamically loaded menu entries for the K-menu, or the panel.

 This class allows to build menu entries that will be dynamically added either to
 the K-menu, or to the panel as a normal button. These dynamic menus are located
 in shared libraries that will be loaded at runtime by Kicker (the KDE panel).

 To build such a menu, you have to inherit this class and implement the pure virtual
 functions #initialize() and {@link #slotExec}. You also have to provide a factory
 object in your library, see {@link KLibFactory}. This factory is only used to construct
 the menu object.

 Finally, you also have to provide a desktop file describing your dynamic menu. The
 relevant entries are: Name, Comment, Icon and X-KDE-Library (which contains the
 library name without any extension). This desktop file has to be installed in
 $KDEDIR/share/apps/kicker/menuext/.

 @author The kicker maintainer, Michael Goffioul <goffioul@imec.be>
 
 @short Base class to build dynamically loaded menu entries for the K-menu, or the panel.

*/
public class KPanelMenu extends KPopupMenu  {
	protected KPanelMenu(Class dummy){super((Class) null);}


/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Get the directory path associated with this menu, or String.null if
 there's no such associated path.

*/
	public native String path();

/** 
 Set a directory path to be associated with this menu.

*/
	public native void setPath( String p);

/** 
 Tell if the menu has been initialized, that is it already contains items.
 This is useful when you need to know if you have to clear the menu, or to
 fill it.

*/
	public native boolean initialized();

/** 
 Set the initial state. Set it to true when you menu is filled with the items
 you want.

*/
	public native void setInitialized( boolean on);

/** 
 Disable the automatic clearing of the menu. Kicker uses a cache system for
 its menus. After a specific configurable delay, the menu will be cleared.
 Use this function if you want to disable kicker's cache system, and avoid
 the clearing of your menu.
     
*/
	public native void disableAutoClear();

/** 
 Reinitialize the menu: the menu is first cleared, the initial state is set
 to false, and finally #initialize() is called. Use this if you want to
 refill your menu immediately.
     
*/
	public native void reinitialize();

/** 
 Deinitialize the menu: the menu is cleared and the initialized state is set to
 false. #initialize() is NOT called. It will be called before the menu is
 next shown, however. Use this slot if you want a delayed reinitialization.

*/
	public native void deinitialize();
}
