package org.kde.koala;
import org.kde.qt.*;


/** {@link KFileDetailView} emits these signals */
public interface KFileDetailViewSignals {
	void pressed( QListViewItem arg1, QPoint arg2, int arg3 );
	void verticalSliderPressed();
	void horizontalSliderPressed();

/** 
 This signal is emitted whenever the user executes an listview item.
 That means depending on the KDE wide Single Click/Double Click
 setting the user clicked or double clicked on that item.

 Note that you may not delete any {@link QListViewItem} objects in slots
 connected to this signal.
   
*/
	void executed( QListViewItem item, QPoint pos, int c );
	void rightButtonClicked( QListViewItem arg1, QPoint arg2, int arg3 );

/** 
 Connect to this signal if you want to do some preprocessing before
 a move is made, for example, to disable sorting

 This is sent only once per each groups of moves.  That is, for each
 drop that is a move this will be emitted once, before KListView calls
 {@link KFileDetailView#moveItem}

*/
	void aboutToMove();
	void rightButtonPressed( QListViewItem arg1, QPoint arg2, int arg3 );
	void onViewport();
	void onItem( QListViewItem item );
	void returnPressed( QListViewItem arg1 );
	void contentsMoving( int x, int y );

/** 
 This signal gets emitted whenever something acceptable is
 dropped onto the listview.

 This function also provides a parent, in the event that your listview
 is a tree

*/
	void dropped( QDropEvent e, QListViewItem parent, QListViewItem after );
	void currentChanged( QListViewItem arg1 );

/** 
 Same as above, but without the extra information.
   
*/
	void itemRenamed( QListViewItem item );
	void destroyed( QObject obj );
	void contextMenuRequested( QListViewItem arg1, QPoint arg2, int arg3 );
	void verticalSliderReleased();

/** 
 This signal is emitted whenever a context-menu should be shown for item <code>i.</code>
 It automatically adjusts for all settings involved (Menu key, showMenuOnPress/Click).

*/
	void contextMenu( KListView l, QListViewItem i, QPoint p );

/** 
 This signal is emitted when the shortcut key for popup-menus is pressed.

 Normally you should not use this, just connect a slot to signal
 {@link KFileDetailView#contextMenu} to correctly
 handle showing context menus regardless of settings.

*/
	void menuShortCutPressed( KListView list, QListViewItem item );
	void selectionChanged( QListViewItem arg1 );

/** 
 This signal is emitted after all the items have been moved. It reports info for
 each and every item moved, in order.  The first element in <code>items</code> associates
 with the first of afterFirst and afterNow.

*/
//	void moved( QPtrList<QListViewItem>* items, QPtrList<QListViewItem>* afterFirst, QPtrList<QListViewItem>* afterNow );

/** 
 This signal gets emitted whenever the user double clicks into the
 listview.

 Note that you may not delete any {@link QListViewItem} objects in slots
 connected to this signal.

 This signal is more or less here for the sake of completeness.
 You should normally not need to use this. In most cases its better
 to use {@link KFileDetailView#executed} instead.
   
*/
	void doubleClicked( QListViewItem item, QPoint pos, int c );
	void horizontalSliderReleased();
	void spacePressed( QListViewItem arg1 );
	void expanded( QListViewItem item );
	void mouseButtonClicked( int arg1, QListViewItem arg2, QPoint arg3, int arg4 );
	void collapsed( QListViewItem item );
	void mouseButtonPressed( int arg1, QListViewItem arg2, QPoint arg3, int arg4 );
	void clicked( QListViewItem arg1, QPoint arg2, int arg3 );
}

