/***************************************************************************
                          dubview.h  -  description
                             -------------------
    begin                : Tue Oct 23 01:44:51 EEST 2001
    copyright            : (C) 2001 by Eray Ozkural (exa)
    email                : erayo@cs.bilkent.edu.tr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DUBVIEW_H
#define DUBVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>

#include <fileselectorwidget.h>

class DubDoc;

/** The DubView class provides the view widget for the DubApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As DubView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the DubApp class to manipulate and display
 * the document structure provided by the DubDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class DubView : public FileSelectorWidget
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    DubView(QWidget *parent = 0);
    /** Destructor for the main view */
    ~DubView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a DubApp instance as a parent
     * widget to get to the window document pointer by calling the DubApp::getDocument() method.
     *
     * @see DubApp#getDocument
     */
    DubDoc *getDocument() const;

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
  /** Return item list of view */
  QPtrList<KFileItem>& items();
  /** No descriptions */
  void selectFile(KFileItem* file);

  private:
	
};

#endif // DUBVIEW_H
