/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public abstract class Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    final PKIXBuilderParameters buildParams;
    final X500Name targetSubjectDN;

    Builder(PKIXBuilderParameters pKIXBuilderParameters, X500Name x500Name) {
        this.buildParams = pKIXBuilderParameters;
        this.targetSubjectDN = x500Name;
    }

    abstract Collection getMatchingCerts(State var1) throws CertStoreException, CertificateException, IOException;

    abstract void verifyCert(X509Certificate var1, State var2, List var3) throws GeneralSecurityException;

    abstract boolean isPathCompleted(X509Certificate var1);

    abstract void addCertToPath(X509Certificate var1, LinkedList var2);

    abstract void removeFinalCertFromPath(LinkedList var1);

    public static int distance(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2) throws IOException {
        switch (generalNameInterface.constrains(generalNameInterface2)) {
            case -1: {
                throw new IOException("Names are different types");
            }
            case 3: {
                throw new IOException("Names are same type but in different subtrees");
            }
            case 0: {
                return 0;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IOException("Unknown name relationship");
            }
        }
        return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
    }

    public static int hops(GeneralNameInterface generalNameInterface, GeneralNameInterface generalNameInterface2) throws IOException {
        int n2 = generalNameInterface.constrains(generalNameInterface2);
        switch (n2) {
            case -1: {
                throw new IOException("Names are different types");
            }
            case 3: {
                break;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            case 1: {
                return generalNameInterface2.subtreeDepth() - generalNameInterface.subtreeDepth();
            }
            default: {
                throw new IOException("Unknown name relationship");
            }
        }
        if (generalNameInterface.getType() != 4) {
            throw new IOException("hopDistance not implemented for this name type");
        }
        X500Name x500Name = (X500Name)generalNameInterface;
        X500Name x500Name2 = (X500Name)generalNameInterface2;
        X500Name x500Name3 = x500Name.commonAncestor(x500Name2);
        if (x500Name3 == null) {
            throw new IOException("Names are in different namespaces");
        }
        int n3 = x500Name3.subtreeDepth();
        int n4 = x500Name.subtreeDepth();
        int n5 = x500Name2.subtreeDepth();
        return n4 + n5 - 2 * n3;
    }

    public static int targetDistance(NameConstraintsExtension nameConstraintsExtension, X509Certificate x509Certificate, GeneralNameInterface generalNameInterface) throws IOException {
        GeneralNameInterface generalNameInterface2;
        GeneralSubtrees generalSubtrees;
        NameConstraintsExtension nameConstraintsExtension2;
        GeneralSubtrees generalSubtrees2;
        block39: {
            CertificateExtensions certificateExtensions;
            X509CertInfo x509CertInfo;
            Vector vector;
            GeneralNameInterface generalNameInterface3;
            block37: {
                generalNameInterface3 = null;
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
                vector = null;
                x509CertInfo = null;
                byte[] byArray = null;
                generalSubtrees2 = null;
                certificateExtensions = null;
                nameConstraintsExtension2 = null;
                generalSubtrees = null;
                generalNameInterface2 = null;
                if (nameConstraintsExtension != null && !nameConstraintsExtension.verify(x509Certificate)) {
                    throw new IOException("certificate does not satisfy existing name constraints");
                }
                try {
                    byArray = x509Certificate.getTBSCertificate();
                    x509CertInfo = new X509CertInfo(byArray);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("Builder.targetDistance() unexpected exception extracting TBSCert");
                        exception.printStackTrace();
                    }
                    throw new IOException("Unable to extract TBSCertificate from X509Certificate" + exception.getMessage());
                }
                X500Name x500Name = null;
                try {
                    x500Name = (X500Name)x509CertInfo.get("subject.dname");
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("Builder.targetDistance() 2 unexpected exception Unable to extract CertificateSubjectName from X509Certificate");
                        exception.printStackTrace();
                    }
                    throw new IOException("Unable to extract CertificateSubjectName from X509Certificate: " + exception.getMessage());
                }
                if (x500Name == null || x500Name.toString() == null || x500Name.toString() == "") {
                    x500Name = new X500Name("");
                }
                if (x500Name.equals(generalNameInterface)) {
                    return 0;
                }
                try {
                    block38: {
                        certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
                        if (certificateExtensions == null) break block37;
                        try {
                            subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)certificateExtensions.get("SubjectAlternativeName");
                        }
                        catch (IOException iOException) {
                            subjectAlternativeNameExtension = null;
                        }
                        catch (Exception exception) {
                            if (debug == null) break block38;
                            debug.println("Builder.targetDistance() 3 unexpected exception");
                            exception.printStackTrace();
                        }
                    }
                    if (subjectAlternativeNameExtension != null) {
                        vector = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
                    }
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("Builder.targetDistance() 4 Unable to extract SubjectAlternativeNameExtension from X509Certificate");
                        exception.printStackTrace();
                    }
                    throw new IOException("Unable to extract SubjectAlternativeNameExtension from X509Certificate: " + exception.getMessage());
                }
            }
            if (vector != null) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    generalNameInterface3 = ((GeneralName)vector.get(n2)).getName();
                    if (generalNameInterface3.equals(generalNameInterface)) {
                        return 0;
                    }
                    ++n2;
                }
            }
            try {
                certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
                if (certificateExtensions != null) {
                    try {
                        nameConstraintsExtension2 = (NameConstraintsExtension)certificateExtensions.get("NameConstraints");
                        break block39;
                    }
                    catch (IOException iOException) {
                        return -1;
                    }
                    catch (Exception exception) {
                        if (debug != null) {
                            debug.println("Builder.targetDistance() 5 unexpected exception");
                            exception.printStackTrace();
                        }
                        break block39;
                    }
                }
                return -1;
            }
            catch (Exception exception) {
                if (debug == null) break block39;
                debug.println("Builder.targetDistance() 6 Unable to extract NameConstraintsExtension from X509Certificate");
                exception.printStackTrace();
            }
        }
        if (nameConstraintsExtension != null) {
            nameConstraintsExtension.merge(nameConstraintsExtension2);
        } else {
            nameConstraintsExtension = nameConstraintsExtension2 == null ? new NameConstraintsExtension(new GeneralSubtrees(), new GeneralSubtrees()) : nameConstraintsExtension2;
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() merged constraints: " + String.valueOf(nameConstraintsExtension));
        }
        generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
        generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
        if (generalSubtrees != null) {
            generalSubtrees.reduce(generalSubtrees2);
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() reduced constraints: " + String.valueOf(generalSubtrees));
        }
        if (!nameConstraintsExtension.verify(generalNameInterface)) {
            throw new IOException("New certificate not allowed to sign certificate for target");
        }
        if (generalSubtrees == null) {
            return -1;
        }
        int n3 = 0;
        while (n3 < generalSubtrees.size()) {
            generalNameInterface2 = ((GeneralSubtree)generalSubtrees.get(n3)).getName().getName();
            try {
                int n4 = Builder.distance(generalNameInterface2, generalNameInterface);
                if (n4 >= 0) {
                    return n4 + 1;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n3;
        }
        return -1;
    }

    Set getMatchingPolicies() {
        Set set = this.buildParams.getInitialPolicies();
        if (!set.isEmpty() && !set.contains("2.5.29.32.0") && this.buildParams.isPolicyMappingInhibited()) {
            set.add("2.5.29.32.0");
            return set;
        }
        return new HashSet();
    }
}

