/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.WriterToASCI;
import org.apache.xalan.serialize.WriterToUTF8;
import org.apache.xalan.serialize.WriterToUTF8Buffered;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SerializerToXML
implements ContentHandler,
LexicalHandler,
DeclHandler,
Serializer,
DOMSerializer {
    protected Writer m_writer = null;
    boolean m_shouldFlush = true;
    protected String m_encoding = null;
    static boolean javaEncodingIsISO = false;
    public boolean m_shouldNotWriteXMLHeader = false;
    public String m_version = null;
    protected BoolStack m_elemStack = new BoolStack();
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    protected BoolStack m_cdataSectionStates = new BoolStack();
    protected Vector m_cdataSectionNames = null;
    protected boolean m_inCData = false;
    protected final char[] m_lineSep = System.getProperty("line.separator").toCharArray();
    protected final int m_lineSepLen = this.m_lineSep.length;
    protected boolean m_ispreserve = false;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_isprevtext = false;
    protected boolean m_doIndent = false;
    protected int m_currentIndent = 0;
    public int m_indentAmount = 0;
    protected int level = 0;
    boolean m_startNewLine;
    boolean m_needToOutputDocTypeDecl = true;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_standalone = false;
    boolean m_standaloneWasSpecified = false;
    String m_mediatype;
    protected boolean m_inEntityRef = false;
    private boolean m_inDoctype = false;
    protected static CharInfo m_xmlcharInfo = new CharInfo(CharInfo.XML_ENTITIES_RESOURCE);
    protected CharInfo m_charInfo;
    private static Hashtable m_charInfos = null;
    boolean m_isUTF8;
    protected int m_maxCharacter = Encodings.getLastPrintable();
    public boolean m_spaceBeforeClose = false;
    protected Properties m_format;
    private static final boolean DEBUG = false;
    protected int m_pos = 0;
    private String m_elemName = "";

    protected boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    protected boolean isCDataSection() {
        return this.m_inCData || this.m_cdataSectionStates.peekOrFalse();
    }

    protected final void outputLineSep() throws SAXException {
        try {
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public SerializerToXML() {
        this.m_charInfo = m_xmlcharInfo;
    }

    public void CopyFrom(SerializerToXML serializerToXML) {
        this.m_writer = serializerToXML.m_writer;
        this.m_encoding = serializerToXML.m_encoding;
        this.m_shouldNotWriteXMLHeader = serializerToXML.m_shouldNotWriteXMLHeader;
        this.m_elemStack = serializerToXML.m_elemStack;
        this.m_ispreserve = serializerToXML.m_ispreserve;
        this.m_preserves = serializerToXML.m_preserves;
        this.m_isprevtext = serializerToXML.m_isprevtext;
        this.m_doIndent = serializerToXML.m_doIndent;
        this.m_currentIndent = serializerToXML.m_currentIndent;
        this.m_indentAmount = serializerToXML.m_indentAmount;
        this.level = serializerToXML.level;
        this.m_startNewLine = serializerToXML.m_startNewLine;
        this.m_needToOutputDocTypeDecl = serializerToXML.m_needToOutputDocTypeDecl;
        this.m_doctypeSystem = serializerToXML.m_doctypeSystem;
        this.m_doctypePublic = serializerToXML.m_doctypePublic;
        this.m_standalone = serializerToXML.m_standalone;
        this.m_mediatype = serializerToXML.m_mediatype;
        this.m_maxCharacter = serializerToXML.m_maxCharacter;
        this.m_spaceBeforeClose = serializerToXML.m_spaceBeforeClose;
        this.m_inCData = serializerToXML.m_inCData;
        this.m_pos = 0;
    }

    public synchronized void init(Writer writer, Properties properties) {
        this.init(writer, properties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init(Writer writer, Properties properties, boolean bl2) {
        this.m_shouldFlush = bl2;
        this.m_writer = writer;
        this.m_format = properties;
        this.m_cdataSectionNames = OutputProperties.getQNameProperties("cdata-section-elements", properties);
        this.m_indentAmount = OutputProperties.getIntProperty(OutputProperties.S_KEY_INDENT_AMOUNT, properties);
        this.m_doIndent = OutputProperties.getBooleanProperty("indent", properties);
        this.m_shouldNotWriteXMLHeader = OutputProperties.getBooleanProperty("omit-xml-declaration", properties);
        this.m_doctypeSystem = properties.getProperty("doctype-system");
        this.m_doctypePublic = properties.getProperty("doctype-public");
        this.m_standaloneWasSpecified = null != properties.get("standalone");
        this.m_standalone = OutputProperties.getBooleanProperty("standalone", properties);
        this.m_mediatype = properties.getProperty("media-type");
        if (null != this.m_doctypePublic && this.m_doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (null == this.m_encoding) {
            this.m_encoding = Encodings.getMimeEncoding(properties.getProperty("encoding"));
        }
        this.m_isUTF8 = this.m_encoding.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
        String string = (String)properties.get(OutputProperties.S_KEY_ENTITIES);
        if (null != string) {
            try {
                Object object;
                this.m_charInfo = null;
                if (null == m_charInfos) {
                    object = m_xmlcharInfo;
                    synchronized (object) {
                        if (null == m_charInfos) {
                            m_charInfos = new Hashtable();
                        }
                    }
                } else {
                    this.m_charInfo = (CharInfo)m_charInfos.get(string);
                }
                if (null == this.m_charInfo) {
                    object = string.indexOf(58) < 0 ? SystemIDResolver.getAbsoluteURIFromRelative(string) : SystemIDResolver.getAbsoluteURI(string, null);
                    this.m_charInfo = new CharInfo((String)object);
                    m_charInfos.put(string, this.m_charInfo);
                }
            }
            catch (TransformerException transformerException) {
                throw new WrappedRuntimeException(transformerException);
            }
        }
    }

    public synchronized void init(OutputStream outputStream, Properties properties) throws UnsupportedEncodingException {
        Object object;
        if (null == properties) {
            object = new OutputProperties("xml");
            properties = ((OutputProperties)object).getProperties();
        }
        this.m_encoding = Encodings.getMimeEncoding(properties.getProperty("encoding"));
        if (this.m_encoding.equalsIgnoreCase("UTF-8")) {
            if (outputStream instanceof BufferedOutputStream) {
                this.init(new WriterToUTF8(outputStream), properties, true);
            } else if (outputStream instanceof FileOutputStream) {
                this.init(new WriterToUTF8Buffered(outputStream), properties, true);
            } else {
                this.init(new WriterToUTF8(outputStream), properties, true);
            }
        } else if (this.m_encoding.equals("WINDOWS-1250") || this.m_encoding.equals("US-ASCII") || this.m_encoding.equals("ASCII")) {
            this.init(new WriterToASCI(outputStream), properties, true);
        } else {
            try {
                object = Encodings.getWriter(outputStream, this.m_encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: encoding \"" + this.m_encoding + "\" not supported" + ", using " + "UTF-8");
                this.m_encoding = "UTF-8";
                object = Encodings.getWriter(outputStream, this.m_encoding);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
            this.init((Writer)object, properties, true);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    void outputDocTypeDecl(String string, boolean bl2) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write("<!DOCTYPE ");
            writer.write(string);
            if (null != this.m_doctypePublic) {
                writer.write(" PUBLIC \"");
                writer.write(this.m_doctypePublic);
                writer.write(34);
            }
            if (null != this.m_doctypeSystem) {
                if (null == this.m_doctypePublic) {
                    writer.write(" SYSTEM \"");
                } else {
                    writer.write(" \"");
                }
                writer.write(this.m_doctypeSystem);
                if (bl2) {
                    writer.write("\">");
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else {
                    writer.write(34);
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void outputEntityDecl(String string, String string2) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write("<!ENTITY ");
            writer.write(string);
            writer.write(" \"");
            writer.write(string2);
            writer.write("\">");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startDocument() throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        if (!this.m_shouldNotWriteXMLHeader) {
            String string;
            String string2 = Encodings.getMimeEncoding(this.m_encoding);
            String string3 = string = null == this.m_version ? "1.0" : this.m_version;
            String string4 = this.m_standaloneWasSpecified ? " standalone=\"" + (this.m_standalone ? "yes" : "no") + "\"" : "";
            try {
                Writer writer = this.m_writer;
                writer.write("<?xml version=\"");
                writer.write(string);
                writer.write("\" encoding=\"");
                writer.write(string2);
                writer.write(34);
                writer.write(string4);
                writer.write("?>");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.m_doIndent && !this.m_isprevtext) {
            this.outputLineSep();
        }
        this.flushWriter();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_doctypeSystem = string3;
        this.m_doctypePublic = string2;
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(string, false);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.m_inDoctype = true;
    }

    public void endDTD() throws SAXException {
        try {
            if (!this.m_inDoctype) {
                this.m_writer.write("]>");
            } else {
                this.m_writer.write(62);
            }
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    protected static final boolean subPartMatch(String string, String string2) {
        return string == string2 || null != string && string.equals(string2);
    }

    protected void pushState(String string, String string2, Vector vector, BoolStack boolStack) {
        boolean bl2;
        if (null != vector) {
            bl2 = false;
            if (null != string && string.length() == 0) {
                string = null;
            }
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                QName qName = (QName)vector.elementAt(n3);
                if (qName.getLocalName().equals(string2) && SerializerToXML.subPartMatch(string, qName.getNamespaceURI())) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
        } else {
            bl2 = boolStack.peekOrFalse();
        }
        boolStack.push(bl2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToOutputDocTypeDecl && null != this.m_doctypeSystem) {
            this.outputDocTypeDecl(string3, true);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.writeParentTagEnd();
        this.pushState(string, string2, this.m_cdataSectionNames, this.m_cdataSectionStates);
        this.m_ispreserve = false;
        if (this.shouldIndent() && this.m_startNewLine) {
            this.indent(this.m_currentIndent);
        }
        this.m_startNewLine = true;
        try {
            this.m_writer.write(60);
            this.m_writer.write(string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        int n2 = attributes.getLength();
        int n3 = 0;
        while (n3 < n2) {
            this.processAttribute(attributes.getQName(n3), attributes.getValue(n3));
            ++n3;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
    }

    protected void writeParentTagEnd() throws SAXException {
        if (!this.m_elemStack.peekOrTrue()) {
            try {
                this.m_writer.write(62);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.m_isprevtext = false;
            this.m_elemStack.setTop(true);
            this.m_preserves.push(this.m_ispreserve);
        }
    }

    protected void openElementForChildren() {
        this.m_elemStack.push(false);
    }

    protected boolean childNodesWereAdded() {
        return this.m_elemStack.isEmpty() ? false : this.m_elemStack.pop();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean bl2 = this.childNodesWereAdded();
        try {
            Writer writer = this.m_writer;
            if (bl2) {
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                writer.write(60);
                writer.write(47);
                writer.write(string3);
                writer.write(62);
            } else if (this.m_spaceBeforeClose) {
                writer.write(" />");
            } else {
                writer.write("/>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (bl2) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    protected void processAttribute(String string, String string2) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(32);
            writer.write(string);
            writer.write("=\"");
            this.writeAttrString(string2, this.m_encoding);
            writer.write(34);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int n2;
                Writer writer = this.m_writer;
                this.writeParentTagEnd();
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                writer.write(60);
                writer.write(63);
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                if ((n2 = string2.indexOf("?>")) >= 0) {
                    if (n2 > 0) {
                        writer.write(string2.substring(0, n2));
                    }
                    writer.write("? >");
                    if (n2 + 2 < string2.length()) {
                        writer.write(string2.substring(n2 + 2));
                    }
                } else {
                    writer.write(string2);
                }
                writer.write(63);
                writer.write(62);
                if (this.m_elemStack.isEmpty()) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                this.m_startNewLine = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        try {
            Writer writer = this.m_writer;
            writer.write("<!--");
            writer.write(cArray, n2, n3);
            writer.write("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.m_startNewLine = true;
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void cdata(char[] cArray, int n2, int n3) throws SAXException {
        try {
            boolean bl2;
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            boolean bl3 = bl2 = n3 >= 1 && cArray[n2] <= this.m_maxCharacter;
            if (bl2) {
                this.m_writer.write("<![CDATA[");
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(cArray, n2, n3);
            } else {
                this.writeNormalizedChars(cArray, n2, n3, true);
            }
            if (bl2) {
                this.m_writer.write("]]>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(XSLMessages.createXPATHMessage(66, null), iOException);
        }
    }

    protected final void accum(char c2) throws SAXException {
        try {
            this.m_writer.write(c2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected final void accum(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.m_writer.write(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected final void accum(String string) throws SAXException {
        try {
            this.m_writer.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void flushWriter() throws SAXException {
        if (null != this.m_writer) {
            try {
                if (this.m_writer instanceof WriterToUTF8Buffered) {
                    if (this.m_shouldFlush) {
                        ((WriterToUTF8Buffered)this.m_writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)this.m_writer).flushBuffer();
                    }
                }
                if (this.m_writer instanceof WriterToUTF8) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else if (this.m_writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else {
                    this.m_writer.flush();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (0 == n3) {
            return;
        }
        if (this.m_inCData || this.m_cdataSectionStates.peekOrFalse()) {
            this.cdata(cArray, n2, n3);
            return;
        }
        try {
            if (this.m_disableOutputEscapingStates.peekOrFalse()) {
                this.charactersRaw(cArray, n2, n3);
                return;
            }
            Writer writer = this.m_writer;
            if (!this.m_elemStack.peekOrTrue()) {
                writer.write(62);
                this.m_isprevtext = false;
                this.m_elemStack.setTop(true);
                this.m_preserves.push(this.m_ispreserve);
            }
            int n4 = n2;
            int n5 = 0;
            int n6 = n2 + n3;
            boolean bl2 = true;
            int n7 = this.m_maxCharacter;
            BitSet bitSet = this.m_charInfo.m_specialsMap;
            int n8 = n2;
            while (n8 < n6) {
                char c2 = cArray[n8];
                if (bl2 && (c2 > ' ' || c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n')) {
                    this.m_ispreserve = true;
                    bl2 = false;
                }
                if (c2 < n7 && !bitSet.get(c2) || '\"' == c2) {
                    ++n5;
                } else {
                    if (n5 > 0) {
                        writer.write(cArray, n4, n5);
                        n5 = 0;
                    }
                    if (CharInfo.S_LINEFEED == c2) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n4 = n8 + 1;
                    } else {
                        n4 = this.accumDefaultEscape(c2, n8, cArray, n6, false);
                        n8 = n4 - 1;
                    }
                }
                ++n8;
            }
            if (n5 > 0) {
                writer.write(cArray, n4, n5);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.m_isprevtext = true;
    }

    public void charactersRaw(char[] cArray, int n2, int n3) throws SAXException {
        try {
            if (this.m_inEntityRef) {
                return;
            }
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            this.m_writer.write(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    static final boolean isUTF16Surrogate(char c2) {
        return (c2 & 0xFC00) == 55296;
    }

    int getURF16SurrogateValue(char c2, char[] cArray, int n2, int n3) throws SAXException {
        int n4;
        if (n2 + 1 >= n3) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c2)}));
        }
        if (56320 > (n4 = cArray[++n2]) || n4 >= 57344) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c2) + " " + Integer.toHexString(n4)}));
        }
        n4 = (c2 - 55296 << 10) + n4 - 56320 + 65536;
        return n4;
    }

    protected int writeUTF16Surrogate(char c2, char[] cArray, int n2, int n3) throws IOException, SAXException {
        int n4 = this.getURF16SurrogateValue(c2, cArray, n2, n3);
        this.m_writer.write(38);
        this.m_writer.write(35);
        this.m_writer.write(Integer.toString(n4));
        this.m_writer.write(59);
        return ++n2;
    }

    void writeNormalizedChars(char[] cArray, int n2, int n3, boolean bl2) throws IOException, SAXException {
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            String string;
            char c2 = cArray[n5];
            if (CharInfo.S_LINEFEED == c2) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (bl2 && c2 > this.m_maxCharacter) {
                if (n5 != 0) {
                    this.m_writer.write("]]>");
                }
                if (SerializerToXML.isUTF16Surrogate(c2)) {
                    n5 = this.writeUTF16Surrogate(c2, cArray, n5, n4);
                } else {
                    this.m_writer.write("&#");
                    string = Integer.toString(c2);
                    this.m_writer.write(string);
                    this.m_writer.write(59);
                }
                if (n5 != 0 && n5 < n4 - 1) {
                    this.m_writer.write("<![CDATA[");
                }
            } else if (bl2 && n5 < n4 - 2 && ']' == c2 && ']' == cArray[n5 + 1] && '>' == cArray[n5 + 2]) {
                this.m_writer.write("]]]]><![CDATA[>");
                n5 += 2;
            } else if (c2 <= this.m_maxCharacter) {
                this.m_writer.write(c2);
            } else if (SerializerToXML.isUTF16Surrogate(c2)) {
                n5 = this.writeUTF16Surrogate(c2, cArray, n5, n4);
            } else {
                this.m_writer.write("&#");
                string = Integer.toString(c2);
                this.m_writer.write(string);
                this.m_writer.write(59);
            }
            ++n5;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (0 == n3) {
            return;
        }
        this.characters(cArray, n2, n3);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        this.m_inEntityRef = true;
    }

    public void endEntity(String string) throws SAXException {
        this.m_inEntityRef = false;
    }

    public void entityReference(String string) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        try {
            Writer writer = this.m_writer;
            writer.write("&");
            writer.write(string);
            writer.write(";");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            writer.write("<!ELEMENT ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            if (!string.equals(this.m_elemName)) {
                writer.write("<!ATTLIST ");
                writer.write(string);
                writer.write(" ");
                this.m_elemName = string;
            } else {
                this.m_pos -= 3;
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            writer.write(string2);
            writer.write(" ");
            writer.write(string3);
            writer.write(" ");
            writer.write(string4);
            writer.write(">");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.outputEntityDecl(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int accumDefaultEntity(char c2, int n2, char[] cArray, int n3, boolean bl2) throws SAXException {
        try {
            if (!bl2 && CharInfo.S_LINEFEED == c2) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                return n2 + 1;
            } else {
                if (!this.m_charInfo.isSpecial(c2)) return n2;
                String string = this.m_charInfo.getEntityNameForChar(c2);
                if (null == string) return n2;
                Writer writer = this.m_writer;
                writer.write(38);
                writer.write(string);
                writer.write(59);
            }
            return n2 + 1;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected int accumDefaultEscape(char c2, int n2, char[] cArray, int n3, boolean bl2) throws SAXException {
        int n4 = this.accumDefaultEntity(c2, n2, cArray, n3, bl2);
        if (n2 == n4) {
            ++n4;
            try {
                if ('\ud800' <= c2 && c2 < '\udc00') {
                    int n5;
                    if (n2 + 1 >= n3) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c2)}));
                    }
                    if (56320 > (n5 = cArray[++n2]) || n5 >= 57344) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c2) + " " + Integer.toHexString(n5)}));
                    }
                    n5 = (c2 - 55296 << 10) + n5 - 56320 + 65536;
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(n5));
                    this.m_writer.write(";");
                } else if (c2 > this.m_maxCharacter || this.m_charInfo.isSpecial(c2)) {
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(c2));
                    this.m_writer.write(";");
                } else {
                    this.m_writer.write(c2);
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        return n4;
    }

    public void writeAttrString(String string, String string2) throws SAXException {
        try {
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            Writer writer = this.m_writer;
            int n3 = 0;
            while (n3 < n2) {
                char c2 = cArray[n3];
                if (c2 < this.m_maxCharacter && !this.m_charInfo.isSpecial(c2)) {
                    writer.write(c2);
                } else {
                    if (CharInfo.S_CARRIAGERETURN == c2 && n3 + 1 < n2 && CharInfo.S_LINEFEED == cArray[n3 + 1]) {
                        ++n3;
                        c2 = CharInfo.S_LINEFEED;
                    }
                    this.accumDefaultEscape(c2, n3, cArray, n2, true);
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    public void printSpace(int n2) throws SAXException {
        try {
            int n3 = 0;
            while (n3 < n2) {
                this.m_writer.write(32);
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void indent(int n2) throws SAXException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_doIndent) {
            this.printSpace(n2);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            this.init(outputStream, this.m_format);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public OutputStream getOutputStream() {
        if (this.m_writer instanceof WriterToUTF8Buffered) {
            return ((WriterToUTF8Buffered)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToUTF8) {
            return ((WriterToUTF8)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToASCI) {
            return ((WriterToASCI)this.m_writer).getOutputStream();
        }
        return null;
    }

    public void setWriter(Writer writer) {
        this.m_writer = writer;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void setOutputFormat(Properties properties) {
        boolean bl2 = this.m_shouldFlush;
        this.init(this.m_writer, properties, false);
        this.m_shouldFlush = bl2;
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    public boolean reset() {
        return false;
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker treeWalker = new TreeWalker(this, new DOM2Helper());
            treeWalker.traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }
}

