/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class JLayeredPane
extends JComponent
implements Accessible {
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer PALETTE_LAYER = new Integer(100);
    public static final Integer MODAL_LAYER = new Integer(200);
    public static final Integer POPUP_LAYER = new Integer(300);
    public static final Integer DRAG_LAYER = new Integer(400);
    public static final Integer FRAME_CONTENT_LAYER = new Integer(-30000);
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    private Hashtable componentToLayer;
    private boolean optimizedDrawingPossible = true;

    public JLayeredPane() {
        this.setLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOptimizedDrawing() {
        boolean bl2 = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            Integer n2 = null;
            int n3 = 0;
            int n4 = this.getComponentCount();
            while (n3 < n4) {
                n2 = null;
                if ((this.getComponent(n3) instanceof JInternalFrame || this.getComponent(n3) instanceof JComponent && (n2 = (Integer)((JComponent)this.getComponent(n3)).getClientProperty(LAYER_PROPERTY)) != null) && (n2 == null || !n2.equals(FRAME_CONTENT_LAYER))) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
        }
        this.optimizedDrawingPossible = !bl2;
    }

    protected void addImpl(Component component, Object object, int n2) {
        int n3 = DEFAULT_LAYER;
        if (object instanceof Integer) {
            n3 = (Integer)object;
            this.setLayer(component, n3);
        } else {
            n3 = this.getLayer(component);
        }
        int n4 = this.insertIndexForLayer(n3, n2);
        super.addImpl(component, object, n4);
        component.validate();
        component.repaint();
        this.validateOptimizedDrawing();
    }

    public void remove(int n2) {
        Component component = this.getComponent(n2);
        super.remove(n2);
        this.validateOptimizedDrawing();
    }

    public boolean isOptimizedDrawingEnabled() {
        return this.optimizedDrawingPossible;
    }

    public static void putLayer(JComponent jComponent, int n2) {
        Integer n3 = new Integer(n2);
        jComponent.putClientProperty(LAYER_PROPERTY, n3);
    }

    public static int getLayer(JComponent jComponent) {
        Integer n2 = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        if (n2 != null) {
            return n2;
        }
        return DEFAULT_LAYER;
    }

    public static JLayeredPane getLayeredPaneAbove(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null && !(container instanceof JLayeredPane)) {
            container = container.getParent();
        }
        return (JLayeredPane)container;
    }

    public void setLayer(Component component, int n2) {
        this.setLayer(component, n2, -1);
    }

    public void setLayer(Component component, int n2, int n3) {
        Integer n4 = this.getObjectForLayer(n2);
        if (n2 == this.getLayer(component) && n3 == this.getPosition(component)) {
            if (component instanceof JComponent) {
                this.repaint(((JComponent)component)._bounds);
            } else {
                this.repaint(component.getBounds());
            }
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(LAYER_PROPERTY, n4);
        } else {
            this.getComponentToLayer().put(component, n4);
        }
        if (component.getParent() == null || component.getParent() != this) {
            if (component instanceof JComponent) {
                this.repaint(((JComponent)component)._bounds);
            } else {
                this.repaint(component.getBounds());
            }
            return;
        }
        this.remove(component);
        this.add(component, null, n3);
        if (component instanceof JComponent) {
            this.repaint(((JComponent)component)._bounds);
        } else {
            this.repaint(component.getBounds());
        }
    }

    public int getLayer(Component component) {
        Integer n2 = component instanceof JComponent ? (Integer)((JComponent)component).getClientProperty(LAYER_PROPERTY) : (Integer)this.getComponentToLayer().get(component);
        if (n2 == null) {
            return DEFAULT_LAYER;
        }
        return n2;
    }

    public int getIndexOf(Component component) {
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (component == this.getComponent(n3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void moveToFront(Component component) {
        this.setPosition(component, 0);
    }

    public void moveToBack(Component component) {
        this.setPosition(component, this.getComponentCountInLayer(this.getLayer(component)));
    }

    public void setPosition(Component component, int n2) {
        this.setLayer(component, this.getLayer(component), n2);
    }

    public int getPosition(Component component) {
        int n2 = 0;
        int n3 = this.getComponentCount();
        int n4 = this.getIndexOf(component);
        if (n4 == -1) {
            return -1;
        }
        int n5 = this.getLayer(component);
        int n6 = n4 - 1;
        while (n6 >= 0) {
            int n7 = this.getLayer(this.getComponent(n6));
            if (n7 == n5) {
                ++n2;
            } else {
                return n2;
            }
            --n6;
        }
        return n2;
    }

    public int highestLayer() {
        if (this.getComponentCount() > 0) {
            return this.getLayer(this.getComponent(0));
        }
        return 0;
    }

    public int lowestLayer() {
        int n2 = this.getComponentCount();
        if (n2 > 0) {
            return this.getLayer(this.getComponent(n2 - 1));
        }
        return 0;
    }

    public int getComponentCountInLayer(int n2) {
        int n3 = 0;
        int n4 = this.getComponentCount();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.getLayer(this.getComponent(n5));
            if (n6 == n2) {
                ++n3;
            } else if (n3 > 0 || n6 < n2) break;
            ++n5;
        }
        return n3;
    }

    public Component[] getComponentsInLayer(int n2) {
        int n3 = 0;
        Component[] componentArray = new Component[this.getComponentCountInLayer(n2)];
        int n4 = this.getComponentCount();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.getLayer(this.getComponent(n5));
            if (n6 == n2) {
                componentArray[n3++] = this.getComponent(n5);
            } else if (n3 > 0 || n6 < n2) break;
            ++n5;
        }
        return componentArray;
    }

    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            Rectangle rectangle = graphics.getClipBounds();
            Color color = this.getBackground();
            if (color == null) {
                color = Color.lightGray;
            }
            graphics.setColor(color);
            if (rectangle != null) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        super.paint(graphics);
    }

    protected Hashtable getComponentToLayer() {
        if (this.componentToLayer == null) {
            this.componentToLayer = new Hashtable(4);
        }
        return this.componentToLayer;
    }

    protected Integer getObjectForLayer(int n2) {
        Integer n3;
        switch (n2) {
            case 0: {
                n3 = DEFAULT_LAYER;
                break;
            }
            case 100: {
                n3 = PALETTE_LAYER;
                break;
            }
            case 200: {
                n3 = MODAL_LAYER;
                break;
            }
            case 300: {
                n3 = POPUP_LAYER;
                break;
            }
            case 400: {
                n3 = DRAG_LAYER;
                break;
            }
            default: {
                n3 = new Integer(n2);
            }
        }
        return n3;
    }

    protected int insertIndexForLayer(int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        int n6 = this.getComponentCount();
        int n7 = 0;
        while (n7 < n6) {
            int n8 = this.getLayer(this.getComponent(n7));
            if (n4 == -1 && n8 == n2) {
                n4 = n7;
            }
            if (n8 < n2) {
                if (n7 == 0) {
                    n4 = 0;
                    n5 = 0;
                    break;
                }
                n5 = n7;
                break;
            }
            ++n7;
        }
        if (n4 == -1 && n5 == -1) {
            return n6;
        }
        if (n4 != -1 && n5 == -1) {
            n5 = n6;
        }
        if (n5 != -1 && n4 == -1) {
            n4 = n5;
        }
        if (n3 == -1) {
            return n5;
        }
        if (n3 > -1 && n4 + n3 <= n5) {
            return n4 + n3;
        }
        return n5;
    }

    protected String paramString() {
        String string = this.optimizedDrawingPossible ? "true" : "false";
        return super.paramString() + ",optimizedDrawingPossible=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJLayeredPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

