/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.io.ByteToCharGB18030;
import sun.io.CharToByteGB18030;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;

public class GB18030
extends Charset {
    private static final int GB18030_SINGLE_BYTE = 1;
    private static final int GB18030_DOUBLE_BYTE = 2;
    private static final int GB18030_FOUR_BYTE = 3;
    static ByteToCharGB18030 decoderGB18K;
    static CharToByteGB18030 encoderGB18K;
    static /* synthetic */ Class class$sun$nio$cs$ext$GB18030;

    public GB18030() {
        super("GB18030", ExtendedCharsets.aliasesFor("GB18030"));
        decoderGB18K = new ByteToCharGB18030();
        encoderGB18K = new CharToByteGB18030();
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset.name().equals("GBK") || charset.name().equals("ISO-8859-1") || charset.name().equals("ISO-8859-2") || charset.name().equals("ISO-8859-3") || charset.name().equals("ISO-8859-4") || charset.name().equals("ISO-8859-5") || charset.name().equals("ISO-8859-6") || charset.name().equals("ISO-8859-7") || charset.name().equals("ISO-8859-8") || charset.name().equals("ISO-8859-9") || charset.name().equals("ISO-8859-13") || charset.name().equals("UTF-8") || charset.name().equals("UTF-16") || charset.name().equals("UTF-16LE") || charset.name().equals("UTF-16BE") || charset.name().equals("ISO-8859-15") || charset.name().equals("windows-1251") || charset.name().equals("windows-1252") || charset.name().equals("windows-1253") || charset.name().equals("windows-1254") || charset.name().equals("windows-1255") || charset.name().equals("windows-1256") || charset.name().equals("windows-1257") || charset.name().equals("windows-1258") || charset.name().equals("windows-932") || charset.name().equals("windows-936") || charset.name().equals("windows-949") || charset.name().equals("windows-950") || charset.name().equals("windows-31j") || charset.name().equals("JIS0201") || charset.name().equals("JIS0208") || charset.name().equals("JIS0212") || charset.name().equals("Shift_JIS") || charset.name().equals("EUC-CN") || charset.name().equals("EUC-KR") || charset.name().equals("EUC-TW") || charset.name().equals("EUC-JP") || charset.name().equals("EUC-JP-LINUX") || charset.name().equals("KOI8-R") || charset.name().equals("TIS-620") || charset.name().equals("ISCII91") || charset.name().equals("Big5") || charset.name().equals("Big5-HKSCS") || charset.name().equals("ISO-2022-JP") || charset.name().equals("ISO-2022-KR") || charset.name().equals("ISO-2022-CN-CNS") || charset.name().equals("ISO-2022-CN-GB") || charset.name().equals("Big5-HKSCS") || charset.name().equals("Johab") || charset instanceof GB18030;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private int currentState = 2;
        short[] index1;
        String[] index2;
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        static final /* synthetic */ boolean $assertionsDisabled;

        private Encoder(Charset charset) {
            super(charset, 4.0f, 4.0f);
            this.index1 = encoderGB18K.getIndex1();
            this.index2 = encoderGB18K.getIndex2();
        }

        public boolean canEncode(char c) {
            return c != '\ufffd';
        }

        private int getGB18030(short[] sArray, String[] stringArray, char c) {
            int n = sArray[(c & 0xFF00) >> 8] << 8;
            return stringArray[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
        }

        protected void implReset() {
            this.currentState = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            if (!$assertionsDisabled && n > n2) {
                throw new AssertionError();
            }
            n = n <= n2 ? n : n2;
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            n3 = n3 <= n4 ? n3 : n4;
            boolean bl = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            this.currentState = 2;
            try {
                while (n < n2) {
                    int n8;
                    char c = cArray[n];
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        n5 = (cArray[n] - 55296) * 1024 + (cArray[n + 1] - 56320) + 189000;
                        this.currentState = 3;
                        n += this.sgp.increment();
                    } else if (c >= '\u0000' && c <= '\u007f') {
                        this.currentState = 1;
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)c;
                        ++n;
                    } else if (c <= '\ua4c6' || c >= '\ue000') {
                        n8 = this.getGB18030(this.index1, this.index2, c);
                        if (n8 == 65533) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        n6 = (n8 & 0xFF00) >> 8;
                        n7 = n8 & 0xFF;
                        n5 = (n6 - 32) * 256 + n7;
                        if (c >= '\ue000' && c < '\uf900') {
                            n5 += 33469;
                        } else if (c >= '\uf900') {
                            n5 += 37801;
                        }
                        this.currentState = n6 > 128 ? 2 : 3;
                    } else if (c >= '\ua4c7' && c <= '\ud7ff') {
                        n5 = c - 21827;
                        this.currentState = 3;
                    }
                    if (this.currentState == 1) continue;
                    if (this.currentState == 2) {
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)n6;
                        byArray[n3++] = (byte)n7;
                        ++n;
                        continue;
                    }
                    if (n4 - n3 < 4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byte by = (byte)(n5 % 10 + 48);
                    byte by2 = (byte)((n5 /= 10) % 126 + 129);
                    byte by3 = (byte)((n5 /= 126) % 10 + 48);
                    n8 = (byte)(n5 / 10 + 129);
                    byArray[n3++] = n8;
                    byArray[n3++] = by3;
                    byArray[n3++] = by2;
                    byArray[n3++] = by;
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block21: {
                CoderResult coderResult2;
                block25: {
                    CoderResult coderResult3;
                    block24: {
                        CoderResult coderResult4;
                        block23: {
                            CoderResult coderResult5;
                            boolean bl = false;
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = 0;
                            this.currentState = 2;
                            n = charBuffer.position();
                            try {
                                while (true) {
                                    int n5;
                                    if (!charBuffer.hasRemaining()) {
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block21;
                                    }
                                    char c = charBuffer.get();
                                    if (Surrogate.is(c)) {
                                        n2 = this.sgp.parse(c, charBuffer);
                                        if (n2 == 0) {
                                            CoderResult coderResult6 = this.sgp.error();
                                            Object var15_18 = null;
                                            charBuffer.position(n);
                                            return coderResult6;
                                        }
                                        n2 += 189000;
                                        this.currentState = 3;
                                        n += this.sgp.increment();
                                    } else if (c >= '\u0000' && c <= '\u007f') {
                                        this.currentState = 1;
                                        if (byteBuffer.remaining() < 1) {
                                            coderResult5 = CoderResult.OVERFLOW;
                                            break;
                                        }
                                        byteBuffer.put((byte)c);
                                        ++n;
                                    } else if (c <= '\ua4c6' || c >= '\ue000') {
                                        n5 = this.getGB18030(this.index1, this.index2, c);
                                        if (n5 == 65533) {
                                            coderResult4 = CoderResult.unmappableForLength(1);
                                            break block23;
                                        }
                                        n3 = (n5 & 0xFF00) >> 8;
                                        n4 = n5 & 0xFF;
                                        n2 = (n3 - 32) * 256 + n4;
                                        if (c >= '\ue000' && c < '\uf900') {
                                            n2 += 33469;
                                        } else if (c >= '\uf900') {
                                            n2 += 37801;
                                        }
                                        this.currentState = n3 > 128 ? 2 : 3;
                                    } else if (c >= '\ua4c7' && c <= '\ud7ff') {
                                        n2 = c - 21827;
                                        this.currentState = 3;
                                    }
                                    if (this.currentState == 1) continue;
                                    if (this.currentState == 2) {
                                        if (byteBuffer.remaining() < 2) {
                                            coderResult3 = CoderResult.OVERFLOW;
                                            break block24;
                                        } else {
                                            byteBuffer.put((byte)n3);
                                            byteBuffer.put((byte)n4);
                                            ++n;
                                            continue;
                                        }
                                    }
                                    if (byteBuffer.remaining() < 4) {
                                        coderResult2 = CoderResult.OVERFLOW;
                                        break block25;
                                    }
                                    byte by = (byte)(n2 % 10 + 48);
                                    byte by2 = (byte)((n2 /= 10) % 126 + 129);
                                    byte by3 = (byte)((n2 /= 126) % 10 + 48);
                                    n5 = (byte)(n2 / 10 + 129);
                                    byteBuffer.put((byte)n5);
                                    byteBuffer.put(by3);
                                    byteBuffer.put(by2);
                                    byteBuffer.put(by);
                                    ++n;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var15_24 = null;
                                charBuffer.position(n);
                                throw throwable;
                            }
                            Object var15_19 = null;
                            charBuffer.position(n);
                            return coderResult5;
                        }
                        Object var15_20 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var15_21 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var15_22 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var15_23 = null;
            charBuffer.position(n);
            return coderResult;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ext$GB18030 == null ? (class$sun$nio$cs$ext$GB18030 = GB18030.class$("sun.nio.cs.ext.GB18030")) : class$sun$nio$cs$ext$GB18030).desiredAssertionStatus();
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final char REPLACE_CHAR = '\ufffd';
        private int currentState = 2;
        short[] b2cOuter = decoderGB18K.getOuter();
        String[] b2cInner = decoderGB18K.getInner();
        short[] index1 = decoderGB18K.getDBIndex1();
        String[] index2 = decoderGB18K.getDBIndex2();
        static final /* synthetic */ boolean $assertionsDisabled;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 2.0f);
        }

        private char getChar(int n) {
            int n2 = n >> 8 & 0xFF;
            int n3 = n & 0xFF;
            int n4 = 0;
            int n5 = 255;
            if (n2 < 0 || n2 > this.b2cOuter.length || n3 < n4 || n3 > n5) {
                return '\ufffd';
            }
            int n6 = (this.b2cOuter[n2] & 0xF) * (n5 - n4 + 1) + (n3 - n4);
            return this.b2cInner[this.b2cOuter[n2] >> 4].charAt(n6);
        }

        protected char decodeDouble(int n, int n2) {
            int n3 = 64;
            int n4 = 254;
            if (n < 0 || n > this.index1.length || n2 < n3 || n2 > n4) {
                return '\ufffd';
            }
            int n5 = (this.index1[n] & 0xF) * (n4 - n3 + 1) + (n2 - n3);
            return this.index2[this.index1[n] >> 4].charAt(n5);
        }

        protected void implReset() {
            this.currentState = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            if (!$assertionsDisabled && n > n2) {
                throw new AssertionError();
            }
            n = n <= n2 ? n : n2;
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 1;
            try {
                while (n < n2) {
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    n6 = byArray[n] & 0xFF;
                    n5 = 1;
                    if ((n6 & 0xFFFFFF80) == 0) {
                        this.currentState = 1;
                    } else {
                        if (n6 < 129 || n6 > 254) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (n2 - n < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n7 = byArray[n + 1] & 0xFF;
                        n5 = 2;
                        if (n7 < 48) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (n7 >= 48 && n7 <= 57) {
                            this.currentState = 3;
                            if (n2 - n < 4) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n8 = byArray[n + 2] & 0xFF;
                            if (n8 < 129 || n8 > 254) {
                                CoderResult coderResult = CoderResult.malformedForLength(3);
                                return coderResult;
                            }
                            n9 = byArray[n + 3] & 0xFF;
                            n5 = 4;
                            if (n9 < 48 || n9 > 57) {
                                CoderResult coderResult = CoderResult.malformedForLength(4);
                                return coderResult;
                            }
                        } else {
                            if (n7 == 127 || n7 == 255 || n7 < 64) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            this.currentState = 2;
                        }
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    switch (this.currentState) {
                        case 1: {
                            cArray[n3++] = (char)n6;
                            break;
                        }
                        case 2: {
                            cArray[n3++] = this.decodeDouble(n6, n7);
                            break;
                        }
                        case 3: {
                            int n10 = (((n6 - 129) * 10 + (n7 - 48)) * 126 + n8 - 129) * 10 + n9 - 48;
                            int n11 = n10 >> 8 & 0xFF;
                            int n12 = n10 & 0xFF;
                            if (n10 <= 19042) {
                                cArray[n3++] = this.getChar(n10);
                                break;
                            }
                            if (n10 > 19042 && n10 <= 33468) {
                                cArray[n3++] = (char)(n10 + 21827);
                                break;
                            }
                            if (n10 >= 33469 && n10 <= 33549) {
                                cArray[n3++] = this.getChar(n10);
                                break;
                            }
                            if (n10 >= 33549 && n10 <= 37800) {
                                cArray[n3++] = (char)(n10 + 25943);
                                break;
                            }
                            if (n10 >= 37801 && n10 <= 39419) {
                                cArray[n3++] = this.getChar(n10);
                                break;
                            }
                            if (n10 >= 189000 && n10 < 1237576) {
                                if (n10 >= 1237576) {
                                    CoderResult coderResult = CoderResult.malformedForLength(4);
                                    return coderResult;
                                }
                                n10 -= 123464;
                                if (n4 - n3 < 2) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                cArray[n3++] = (char)((n10 - 65536) / 1024 + 55296);
                                cArray[n3++] = (char)((n10 - 65536) % 1024 + 56320);
                                break;
                            }
                            CoderResult coderResult = CoderResult.malformedForLength(n5);
                            return coderResult;
                        }
                    }
                    n += n5;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            block28: {
                CoderResult coderResult2;
                block36: {
                    CoderResult coderResult3;
                    block35: {
                        CoderResult coderResult4;
                        block34: {
                            CoderResult coderResult5;
                            block33: {
                                CoderResult coderResult6;
                                block32: {
                                    CoderResult coderResult7;
                                    block31: {
                                        CoderResult coderResult8;
                                        block30: {
                                            CoderResult coderResult9;
                                            n = byteBuffer.position();
                                            int n2 = 1;
                                            try {
                                                while (true) {
                                                    if (!byteBuffer.hasRemaining()) {
                                                        coderResult = CoderResult.UNDERFLOW;
                                                        break block28;
                                                    }
                                                    int n3 = 0;
                                                    int n4 = 0;
                                                    int n5 = 0;
                                                    int n6 = 0;
                                                    n3 = byteBuffer.get() & 0xFF;
                                                    n2 = 1;
                                                    if ((n3 & 0xFFFFFF80) == 0) {
                                                        this.currentState = 1;
                                                    } else {
                                                        if (byteBuffer.remaining() < 1) {
                                                            CoderResult coderResult10 = CoderResult.UNDERFLOW;
                                                            Object var16_19 = null;
                                                            byteBuffer.position(n);
                                                            return coderResult10;
                                                        }
                                                        n4 = byteBuffer.get() & 0xFF;
                                                        n2 = 2;
                                                        if (n4 < 48) {
                                                            coderResult9 = CoderResult.malformedForLength(1);
                                                            break;
                                                        }
                                                        if (n4 >= 48 && n4 <= 57) {
                                                            this.currentState = 3;
                                                            if (byteBuffer.remaining() < 2) {
                                                                coderResult8 = CoderResult.UNDERFLOW;
                                                                break block30;
                                                            }
                                                            n5 = byteBuffer.get() & 0xFF;
                                                            if (n5 < 129 || n5 > 254) {
                                                                coderResult7 = CoderResult.malformedForLength(3);
                                                                break block31;
                                                            }
                                                            n6 = byteBuffer.get() & 0xFF;
                                                            n2 = 4;
                                                            if (n6 < 48 || n6 > 57) {
                                                                coderResult6 = CoderResult.malformedForLength(4);
                                                                break block32;
                                                            }
                                                        } else {
                                                            if (n4 == 127 || n4 == 255 || n4 < 64) {
                                                                coderResult5 = CoderResult.malformedForLength(2);
                                                                break block33;
                                                            }
                                                            this.currentState = 2;
                                                        }
                                                    }
                                                    if (charBuffer.remaining() < 1) {
                                                        coderResult4 = CoderResult.OVERFLOW;
                                                        break block34;
                                                    }
                                                    switch (this.currentState) {
                                                        case 1: {
                                                            charBuffer.put((char)n3);
                                                            break;
                                                        }
                                                        case 2: {
                                                            charBuffer.put(this.decodeDouble(n3, n4));
                                                            break;
                                                        }
                                                        case 3: {
                                                            int n7 = (((n3 - 129) * 10 + (n4 - 48)) * 126 + n5 - 129) * 10 + n6 - 48;
                                                            int n8 = n7 >> 8 & 0xFF;
                                                            int n9 = n7 & 0xFF;
                                                            if (n7 <= 19042) {
                                                                charBuffer.put(this.getChar(n7));
                                                                break;
                                                            }
                                                            if (n7 > 19042 && n7 <= 33468) {
                                                                charBuffer.put((char)(n7 + 21827));
                                                                break;
                                                            }
                                                            if (n7 >= 33469 && n7 <= 33549) {
                                                                charBuffer.put(this.getChar(n7));
                                                                break;
                                                            }
                                                            if (n7 >= 33549 && n7 <= 37800) {
                                                                charBuffer.put((char)(n7 + 25943));
                                                                break;
                                                            }
                                                            if (n7 >= 37801 && n7 <= 39417) {
                                                                charBuffer.put(this.getChar(n7));
                                                                break;
                                                            }
                                                            if (n7 < 189000 || n7 >= 1237576) break;
                                                            if (n7 >= 1237576) {
                                                                coderResult3 = CoderResult.malformedForLength(4);
                                                                break block35;
                                                            }
                                                            n7 -= 123464;
                                                            if (charBuffer.remaining() < 2) {
                                                                coderResult2 = CoderResult.OVERFLOW;
                                                                break block36;
                                                            } else {
                                                                charBuffer.put((char)((n7 - 65536) / 1024 + 55296));
                                                                charBuffer.put((char)((n7 - 65536) % 1024 + 56320));
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    n += n2;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var16_29 = null;
                                                byteBuffer.position(n);
                                                throw throwable;
                                            }
                                            Object var16_20 = null;
                                            byteBuffer.position(n);
                                            return coderResult9;
                                        }
                                        Object var16_21 = null;
                                        byteBuffer.position(n);
                                        return coderResult8;
                                    }
                                    Object var16_22 = null;
                                    byteBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var16_23 = null;
                                byteBuffer.position(n);
                                return coderResult6;
                            }
                            Object var16_24 = null;
                            byteBuffer.position(n);
                            return coderResult5;
                        }
                        Object var16_25 = null;
                        byteBuffer.position(n);
                        return coderResult4;
                    }
                    Object var16_26 = null;
                    byteBuffer.position(n);
                    return coderResult3;
                }
                Object var16_27 = null;
                byteBuffer.position(n);
                return coderResult2;
            }
            Object var16_28 = null;
            byteBuffer.position(n);
            return coderResult;
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ext$GB18030 == null ? (class$sun$nio$cs$ext$GB18030 = GB18030.class$("sun.nio.cs.ext.GB18030")) : class$sun$nio$cs$ext$GB18030).desiredAssertionStatus();
        }
    }
}

